/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.custom;

import com.dataiku.dip.custom.CustomJavaRuntimeDataProvider;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.FilteringProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.formats.custom.CustomJavaFormatDesc;
import com.dataiku.dip.formats.custom.LoadedJavaFormat;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.plugin.CustomFormat;
import com.dataiku.dip.plugin.CustomFormatInput;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.plugin.tools.PluginClazzLoader;
import com.dataiku.dip.security.AuthCtx;
import com.google.gson.JsonObject;

public class CustomJavaFormatExtractor
extends ArchiveCapableFormatExtractor {
    protected final LoadedJavaFormat loaded;
    protected final CustomJavaRuntimeDataProvider service;
    protected final JsonObject config;
    protected final String projectKey;
    protected final AuthCtx authCtx;

    public CustomJavaFormatExtractor(AuthCtx authCtx, String projectKey, JsonObject config, LoadedJavaFormat loaded, CustomJavaRuntimeDataProvider service) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.config = config;
        this.loaded = loaded;
        this.service = service;
    }

    @Override
    public boolean doExtractStream(InputStreamWithContextInfo isn, ProcessorOutput output, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        ClassLoader classLoader = this.service.getClassloader(this.loaded.getType());
        CustomFormat format = (CustomFormat)new PluginClazzLoader(classLoader).loadClazz(((CustomJavaFormatDesc)this.loaded.getDesc()).formatClass);
        if (observer != null) {
            output = new LimitCheckerProcessorOutput((ProcessorOutput)output, observer);
        }
        PluginSettingsResolver.ResolvedSettings resolvedSettings = this.service.getExpandedPluginSettings(this.loaded.getType(), this.authCtx, this.projectKey, this.config);
        try (CustomFormatInput reader = format.getReader(resolvedSettings.config, resolvedSettings.pluginConfig);){
            reader.setSchema(this.schema, this.allowExtraColumns);
            reader.setWarningsContext(this.warnContext);
            reader.run(isn, output, cf, rf);
        }
        catch (LimitCheckerProcessorOutputException e) {
            return false;
        }
        return true;
    }

    private class LimitCheckerProcessorOutput
    extends FilteringProcessorOutput {
        private final ArchiveCapableFormatExtractor.ArchiveCapableObserver observer;
        private int readRows;

        public LimitCheckerProcessorOutput(ProcessorOutput downstream, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) {
            super(downstream);
            this.readRows = 0;
            this.observer = observer;
        }

        public void emitRow(Row row) throws Exception {
            ++this.readRows;
            if (!this.observer.checkLimit(this.readRows)) {
                throw new LimitCheckerProcessorOutputException();
            }
            if (this.readRows % 1000 == 0) {
                this.observer.onInterval(this.readRows);
            }
            this.downstream.emitRow(row);
        }

        public void lastRowEmitted() throws Exception {
            this.observer.onEnd(this.readRows);
            super.lastRowEmitted();
        }
    }

    private class LimitCheckerProcessorOutputException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private LimitCheckerProcessorOutputException() {
        }
    }
}

