/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.hive.HiveCodes;
import com.dataiku.dip.hive.HiveProgressListener;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HiveLogParser
implements DKUtils.LineSubscription {
    private static final Pattern launchingJobPattern = Pattern.compile("^Launching Job ([0-9]+) out of ([0-9]+)\\s*$");
    private static final Pattern mapredProgressPattern = Pattern.compile("^[0-9\\-\\s,:]+Stage-[0-9]+\\s*map\\s*=\\s*([0-9]+)%,\\s*reduce\\s*=\\s*([0-9]+)%.+$");
    private static final Pattern decimalErrorPattern = Pattern.compile("^.*ClassCastException.+(HiveDecimalWritable|DoubleColumnVector).+(DoubleWritable|DecimalColumnVector).*$");
    private static final Pattern hiveLegacyUnionSupportPattern = Pattern.compile("^FAILED: ParseException line \\d+:\\d+ missing ALL at 'SELECT' near '<EOF>'$");
    private final HiveProgressListener listener;
    private String lastDetectedError = "";
    private String lastDecimalError = "";
    private HiveCodes lastExplainableError;
    private int nbJobs = -1;
    private int currentJob = -1;
    private int mapProgress = 0;
    private int reduceProgress = 0;

    public HiveLogParser(HiveProgressListener listener) {
        this.listener = (HiveProgressListener)Preconditions.checkNotNull((Object)listener);
    }

    public synchronized void handle(String str, boolean replace) {
        Matcher decimalErrorMatcher;
        Matcher mapredProgressMatcher;
        this.lastDetectedError = str;
        Matcher launchingJobMatcher = launchingJobPattern.matcher(str);
        if (launchingJobMatcher.matches()) {
            if (this.nbJobs == -1) {
                this.nbJobs = Integer.parseInt(launchingJobMatcher.group(2));
            }
            this.currentJob = Integer.parseInt(launchingJobMatcher.group(1)) - 1;
            this.mapProgress = 0;
            this.reduceProgress = 0;
            this.listener.jobChanged(this.currentJob, this.nbJobs);
            this.listener.progressChanged(this.computeGlobalProgress());
        }
        if ((mapredProgressMatcher = mapredProgressPattern.matcher(str)).matches()) {
            this.mapProgress = Integer.parseInt(mapredProgressMatcher.group(1));
            this.reduceProgress = Integer.parseInt(mapredProgressMatcher.group(2));
            this.listener.progressChanged(this.computeGlobalProgress());
        }
        if ((decimalErrorMatcher = decimalErrorPattern.matcher(str)).matches()) {
            this.lastDecimalError = str;
        }
        if (hiveLegacyUnionSupportPattern.matcher(str).matches()) {
            this.lastExplainableError = HiveCodes.ERR_HIVE_LEGACY_UNION_SUPPORT;
        }
    }

    private synchronized double computeGlobalProgress() {
        if (this.currentJob == -1 || this.nbJobs == -1) {
            return 0.0;
        }
        return ((double)this.currentJob + (double)(this.mapProgress + this.reduceProgress) / 200.0) / (double)this.nbJobs;
    }

    public synchronized String getLastError() {
        return this.lastDetectedError;
    }

    public synchronized String getLastDecimalError() {
        return this.lastDecimalError;
    }

    public synchronized HiveCodes getLastExplainableError() {
        return this.lastExplainableError;
    }

    public void close() throws IOException {
    }
}

