/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.rcfile;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.formats.hive.HiveFileOutputWriter;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatConfig;
import com.dataiku.dip.output.CanListFilesWrittenTo;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.io.Writable;

public class RCFileOutput
implements Output,
CanListFilesWrittenTo {
    private final Partition targetPartition;
    private final int targetSplit;
    private final RCFileFormatConfig config;
    private final WarningsContext warningsContext;
    private final HDFSProvider provider;
    private final Dataset dataset;

    public RCFileOutput(HDFSProvider provider, Dataset dataset, Partition targetPartition, int targetSplit, RCFileFormatConfig config, WarningsContext warningsContext) {
        this.provider = provider;
        this.dataset = dataset;
        this.targetPartition = targetPartition;
        this.targetSplit = targetSplit;
        this.config = (RCFileFormatConfig)Preconditions.checkNotNull((Object)config);
        this.warningsContext = (WarningsContext)Preconditions.checkNotNull((Object)warningsContext);
    }

    public OutputWriter getWriter(Output.WriteMode mode) throws IOException, DKUSecurityException {
        assert (mode == Output.WriteMode.APPEND);
        return new RCFileOutputWriter();
    }

    public List<String> list(OutputWriter writer) throws IOException, InterruptedException {
        return ((HiveFileOutputWriter)writer).gatherWritesInProgress();
    }

    public List<String> recoverList() throws IOException, CodedException, DKUSecurityException {
        return HiveFileOutputWriter.gatherPathsWrittenToAndNotCommitted(this.provider, this.targetSplit);
    }

    public class RCFileOutputWriter
    extends HiveFileOutputWriter {
        public RCFileOutputWriter() throws DKUSecurityException, IOException {
            super(RCFileOutput.this.provider, RCFileOutput.this.dataset, RCFileOutput.this.targetPartition, RCFileOutput.this.targetSplit, RCFileOutput.this.warningsContext, RCFileOutput.this.config);
        }

        @Override
        protected String getFileExtension() {
            return "rc";
        }

        @Override
        protected HiveOutputFormat<? extends Writable, ? extends Writable> getFileOutputFormat() {
            return new RCFileOutputFormat();
        }
    }
}

