/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;

public class IntegrationHooksRegistry {
    private static final Map<String, IntegrationMeta> library = Maps.newLinkedHashMap();

    public static IntegrationMeta getMeta(IntegrationHook messaging) {
        return IntegrationHooksRegistry.getMeta(messaging.getType());
    }

    public static IntegrationMeta getMeta(IntegrationChannel channel) {
        return IntegrationHooksRegistry.getMeta(channel.getType());
    }

    public static synchronized IntegrationMeta getMeta(String type) {
        if (library.containsKey(type)) {
            return library.get(type);
        }
        throw new UnknownIntegrationTypeException("Unknown integration type " + type);
    }

    public static synchronized void register(IntegrationMeta meta) {
        library.put(meta.getType(), meta);
    }

    public static IntegrationEventHandler buildSender(AuthCtx authCtx, IntegrationHook hook, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
        IntegrationEventHandler runner = IntegrationHooksRegistry.getMeta(hook).buildHandler(authCtx, hook, permissionCheckContext);
        SpringUtils.getInstance().autowire((Object)runner);
        return runner;
    }

    public static class UnknownIntegrationTypeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnknownIntegrationTypeException(String message) {
            super(message);
        }
    }
}

