/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.retrieval;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedRetrievableKnowledgeDAO
extends AbstractStandardDAO<RetrievableKnowledge>
implements RetrievableKnowledgeDAO {
    @Autowired
    private VariablesService variablesService;

    @Override
    protected RetrievableKnowledge getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.getDAOFile(projectKey, id))) {
            return null;
        }
        RetrievableKnowledge obj = unsafe ? (RetrievableKnowledge)tr.readObjectUnsafe(rf, RetrievableKnowledge.class) : (RetrievableKnowledge)tr.readObject(rf, RetrievableKnowledge.class);
        obj.id = id;
        obj.projectKey = projectKey;
        obj.filterCapabilities = new RetrievableKnowledge.FilterCapabilities(obj.vectorStoreType.supportedFiltersOperators, obj.vectorStoreType.supportedBooleanOperators);
        return obj;
    }

    public static boolean looksLikeARetrievableKnowledgeId(String name) {
        return name.length() == 8;
    }

    @Override
    protected List<RetrievableKnowledge> list_noTag(String projectKey, boolean unsafe) throws IOException {
        RelFile retrievableKnowledgesFolder = this.retrievableKnowledgesFolder(projectKey);
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<RetrievableKnowledge> ret = new ArrayList<RetrievableKnowledge>();
        if (tr.isDirectory(retrievableKnowledgesFolder)) {
            for (RelFile f : tr.listFiles(retrievableKnowledgesFolder)) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    RetrievableKnowledge obj = (RetrievableKnowledge)this.getMandatory(projectKey, id, unsafe);
                    ret.add(obj);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to read knowledge bank file: " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    public void save(RetrievableKnowledge rk) throws IOException {
        rk.resolvedIndexName = null;
        super.save(rk);
    }

    @Override
    protected RetrievableKnowledge getOrNull(String projectKey, String id, boolean unsafe) throws IOException {
        RetrievableKnowledge rk = (RetrievableKnowledge)super.getOrNull(projectKey, id, unsafe);
        this.resolveIndexName(rk);
        return rk;
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Knowledge bank is not specified");
        return new RelFile(this.retrievableKnowledgesFolder(projectKey), new String[]{id + ".json"});
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE.toHumanReadableString();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile retrievableKnowledgeFile = this.getDAOFile(projectKey, id);
        t.deleteFile(retrievableKnowledgeFile);
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile retrievableKnowledgesFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(retrievableKnowledgesFolder = this.retrievableKnowledgesFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(retrievableKnowledgesFolder).size();
    }

    private RelFile retrievableKnowledgesFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "knowledge-banks"});
    }

    private void resolveIndexName(RetrievableKnowledge rk) {
        if (rk != null && rk.vectorStoreType != null && rk.vectorStoreType.hasIndex) {
            try {
                rk.resolvedIndexName = this.variablesService.getForProject(rk.projectKey).expand(rk.indexName);
            }
            catch (IllegalArgumentException e) {
                rk.resolvedIndexName = null;
                this.logger.error((Object)("Failed to resolve indexName: " + rk.indexName), (Throwable)e);
            }
        }
    }
}

