/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.logging;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class SparkLoggingConfigurator {
    private static Logger logger = Logger.getLogger((String)"dku.logging.spark");

    public static void configure() {
        try {
            File installFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"logging", "dku-spark-log4j.properties"});
            SparkLoggingConfigurator.addLog4jLoggingIfFileExists(installFile);
            File userFile = ApplicationConfigurator.getUserResourceFile((String[])new String[]{"logging", "dku-spark-log4j.properties"});
            SparkLoggingConfigurator.addLog4jLoggingIfFileExists(userFile);
            installFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"logging", "dku-spark-log-jul.properties"});
            SparkLoggingConfigurator.addJulLoggingIfFileExists(installFile);
            userFile = ApplicationConfigurator.getUserResourceFile((String[])new String[]{"logging", "dku-spark-log-jul.properties"});
            SparkLoggingConfigurator.addJulLoggingIfFileExists(userFile);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to configure DKU-specific Spark logging", (Throwable)e);
        }
    }

    public static List<File> copyConfigurationFilesToRunDir(File runDir) {
        ArrayList files = Lists.newArrayList();
        try {
            File file;
            File installFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"logging", "dku-spark-log4j.properties"});
            logger.info((Object)("Copy additional Spark logging from " + String.valueOf(installFile)));
            if (installFile.exists() && installFile.isFile()) {
                file = new File(runDir, "dku-spark-log4j.properties");
                FileUtils.copyFile((File)installFile, (File)file);
                files.add(file);
            }
            File userFile = ApplicationConfigurator.getUserResourceFile((String[])new String[]{"logging", "dku-spark-log4j.properties"});
            logger.info((Object)("Copy additional Spark logging from " + String.valueOf(userFile)));
            if (userFile.exists() && userFile.isFile()) {
                file = new File(runDir, "dku-spark-log4j.user.properties");
                FileUtils.copyFile((File)userFile, (File)file);
                files.add(file);
            }
            installFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"logging", "dku-spark-log-jul.properties"});
            logger.info((Object)("Copy additional Spark JUL logging from " + String.valueOf(installFile)));
            if (installFile.exists() && installFile.isFile()) {
                file = new File(runDir, "dku-spark-log-jul.properties");
                FileUtils.copyFile((File)installFile, (File)file);
                files.add(file);
            }
            userFile = ApplicationConfigurator.getUserResourceFile((String[])new String[]{"logging", "dku-spark-log-jul.properties"});
            logger.info((Object)("Copy additional Spark JUL logging from " + String.valueOf(userFile)));
            if (userFile.exists() && userFile.isFile()) {
                file = new File(runDir, "dku-spark-log-jul.user.properties");
                FileUtils.copyFile((File)userFile, (File)file);
                files.add(file);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to configure DKU-specific Spark logging", (Throwable)e);
        }
        return files;
    }

    public static void configureFromRunDir() {
        try {
            File installFile = new File("dku-spark-log4j.properties");
            SparkLoggingConfigurator.addLog4jLoggingIfFileExists(installFile);
            File userFile = new File("dku-spark-log4j.user.properties");
            SparkLoggingConfigurator.addLog4jLoggingIfFileExists(userFile);
            installFile = new File("dku-spark-log-jul.properties");
            SparkLoggingConfigurator.addJulLoggingIfFileExists(installFile);
            userFile = new File("dku-spark-log-jul.user.properties");
            SparkLoggingConfigurator.addJulLoggingIfFileExists(userFile);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to configure DKU-specific Spark logging", (Throwable)e);
        }
    }

    private static void addLog4jLoggingIfFileExists(File file) {
        if (file.exists() && file.isFile()) {
            logger.info((Object)("Configuring additional Spark logging from " + String.valueOf(file)));
            PropertyConfigurator.configure((String)file.getAbsolutePath());
        } else {
            logger.info((Object)("No " + String.valueOf(file) + " to configure logging from"));
        }
    }

    private static void addJulLoggingIfFileExists(File file) throws IOException, FileNotFoundException {
        if (file.exists() && file.isFile()) {
            logger.info((Object)("Configuring additional Spark logging from " + String.valueOf(file)));
            try (FileInputStream is = new FileInputStream(file);){
                LogManager.getLogManager().readConfiguration(is);
            }
        } else {
            logger.info((Object)("No " + String.valueOf(file) + " to configure logging from"));
        }
    }
}

