/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.managedfolder;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSProviderService;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsHandler;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDatasetParams;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.DirectoryAware;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSMovingItem;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksCRUDService;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderCodes;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFolderSelection;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.probes.BasicProbeType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.variables.VariablesUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagedFoldersService {
    private final int maxPreviewLength = 65536;
    @Autowired
    private ManagedFolderDAO dao;
    @Autowired
    private FSProviderService fsProviderService;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private LabelingTasksCRUDService labelingTasksCRUDService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private KernelsManagedFolderService kernelsManagedFolderService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TaggableObjectDiffService colaborativeMetadataDiffService;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private FlowExecutionService2 flowExecutionService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    protected PermissionsService permissionsService;
    @Autowired
    protected ProjectsService projectsService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    private static Pattern archiveMimeTypePattern = Pattern.compile("^.*\\/.*(zip|tar|bz|gz)2?$", 2);
    private static DKULogger logger = DKULogger.getLogger((String)"dku.managedfolders");

    public ManagedFolder getOrNull(String projectKey, String id) throws IOException {
        return (ManagedFolder)this.dao.getOrNull(projectKey, id);
    }

    public ManagedFolder getOrNullUnsafe(String projectKey, String id) throws IOException {
        return (ManagedFolder)this.dao.getOrNullUnsafe(projectKey, id);
    }

    public ManagedFolder getMandatory(String projectKey, String id) throws IOException, NotFoundException {
        return (ManagedFolder)this.dao.getMandatory(projectKey, id);
    }

    public ManagedFolder getMandatoryUnsafe(String projectKey, String id) throws IOException, NotFoundException {
        return (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, id);
    }

    public ManagedFolder getMandatoryUnsafe(AnyLoc loc) throws IOException, NotFoundException {
        return (ManagedFolder)this.dao.getMandatoryUnsafe(loc);
    }

    public ManagedFolder lookup(String projectKey, String lookup) throws IOException {
        ManagedFolder ret = (ManagedFolder)this.dao.getOrNull(projectKey, lookup);
        if (ret != null) {
            return ret;
        }
        for (ManagedFolder box : this.dao.list(projectKey)) {
            if (!box.name.equals(lookup)) continue;
            return box;
        }
        return null;
    }

    public ManagedFolder save(ManagedFolder mf, boolean creation, boolean summaryOnly) throws Exception {
        TaggableObjectChangedEvent.ActionType action;
        Preconditions.checkNotNull((Object)mf.projectKey);
        Preconditions.checkNotNull((Object)mf.id);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        ManagedFolder preExisting = (ManagedFolder)this.dao.getOrNullUnsafe(mf.projectKey, mf.id);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(mf, preExisting);
        TaggableObjectDiffService.TaggableObjectsDiff diff = new TaggableObjectDiffService.TaggableObjectsDiff();
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", mf.name);
        if (creation) {
            action = TaggableObjectChangedEvent.ActionType.MANAGED_FOLDER_CREATE;
            mf.creationTag = new VersionTag(t.getUser().getIdentifier());
            this.addDefaultMetricsStuff(mf);
            this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(mf);
        } else if (mf.name != null && preExisting != null && !mf.name.equals(preExisting.name)) {
            action = TaggableObjectChangedEvent.ActionType.MANAGED_FOLDER_RENAME;
            details.addProperty("oldName", preExisting.name);
            details.addProperty("newName", mf.name);
        } else {
            action = TaggableObjectChangedEvent.ActionType.MANAGED_FOLDER_EDIT;
            diff = this.colaborativeMetadataDiffService.diff(preExisting, mf, t.getUser().getIdentifier());
        }
        AbstractFSDatasetHandler.AbstractFSConfig params = mf.getParams();
        String path = params.path;
        if (StringUtils.isBlank((String)path) || "/".equals(path)) {
            String connectionName = StringUtils.defaultIfBlank((String)params.connection, (String)"no_connection");
            boolean allowed = ApplicationConfigurator.getParams().getBoolParam("dku.datasets.managed." + connectionName + ".allowClearRoot", false);
            if (!allowed) {
                throw new CodedException((InfoMessage.MessageCode)ManagedFolderCodes.ERR_FOLDER_INVALID_CONFIG, "Placing a managed folder at the root of a connection is not permitted");
            }
        }
        ManagedFoldersService.checkConnectionPermission(mf.params, t.getUser(), "save a managed folder on");
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), (TaggableObjectsService.TaggableObject)this.dao.getOrNull(mf.projectKey, mf.id), mf);
        this.dao.save(mf);
        if (diff.metadataChanged()) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        }
        if (!summaryOnly) {
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.MANAGED_FOLDER, mf.projectKey, mf.id, t.getUser(), action).withDetails(details));
        }
        this.taggingService.onObjectSaved(mf.projectKey, mf.tags);
        if (action == TaggableObjectChangedEvent.ActionType.MANAGED_FOLDER_RENAME) {
            this.graphService.invalidateCache();
        }
        return mf;
    }

    public void rename(String projectKey, String managedFolderId, String newName) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)newName), (Object)"Managed folder name cannot be blank");
        ManagedFolder managedFolder = (ManagedFolder)this.dao.getMandatory(projectKey, managedFolderId);
        String newNameTrimmed = newName.trim();
        if (newNameTrimmed.equals(managedFolder.name)) {
            return;
        }
        ManagedFolder renamedManagedFolder = new ManagedFolder(managedFolder);
        renamedManagedFolder.name = newNameTrimmed;
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdate(renamedManagedFolder, managedFolder);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        ManagedFoldersService.checkConnectionPermission(renamedManagedFolder.params, t.getUser(), "rename a managed folder on");
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), managedFolder, renamedManagedFolder);
        this.dao.save(renamedManagedFolder);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", renamedManagedFolder.name);
        details.addProperty("oldName", managedFolder.name);
        details.addProperty("newName", renamedManagedFolder.name);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.MANAGED_FOLDER, renamedManagedFolder.projectKey, renamedManagedFolder.id, t.getUser(), TaggableObjectChangedEvent.ActionType.MANAGED_FOLDER_RENAME).withDetails(details));
        this.graphService.invalidateCache();
    }

    protected void addDefaultMetricsStuff(ManagedFolder odb) {
        ProbesSet metrics = new ProbesSet();
        Probe probe = new Probe("basic");
        BasicProbeType.BasicProbeConfiguration conf = new BasicProbeType.BasicProbeConfiguration();
        probe.withConfiguration(conf).withEnabled(true);
        probe.meta = new BasicProbeType().getMeta();
        probe.computeOnBuildMode = Probe.ComputeMode.PARTITION;
        metrics.probes.add(probe);
        metrics.displayedState.partition = "NP";
        metrics.displayedState.metrics.add("basic:COUNT_FILES");
        metrics.displayedState.metrics.add("basic:SIZE");
        odb.metrics = metrics;
        ChecksSet checks = new ChecksSet();
        checks.displayedState.partition = "NP";
        odb.checks = checks;
    }

    public void setExploreOnSinglePartition(String projectKey, String folderId, String partitionId) throws Exception {
        ManagedFolder odb = this.getMandatory(projectKey, folderId);
        odb.selection = ManagedFolderSelection.newSinglePartition(partitionId);
        this.save(odb, false, false);
    }

    public void setExploreSettings(String projectKey, String folderId, ManagedFolderSelection selection) throws Exception {
        ManagedFolder odb = this.getMandatory(projectKey, folderId);
        odb.selection = selection;
        this.save(odb, false, false);
    }

    public ManagedFolder create(String projectKey, String name, ManagedFolderCreationSettings settings, AuthCtx authCtx) throws Exception {
        if (settings == null) {
            throw new CodedException((InfoMessage.MessageCode)ManagedFolderCodes.ERR_FOLDER_INVALID_CONFIG, "No settings were provided to create the folder.");
        }
        if (StringUtils.isBlank((String)settings.connectionId)) {
            throw new CodedException((InfoMessage.MessageCode)ManagedFolderCodes.WARN_FOLDER_CONNECTION_TYPE_ERROR, "No connection was provided to store the managed folder into.");
        }
        FSProviderService.FSProviderTypeProvider fsProviderProvider = this.fsProviderService.getFSProviderTypeProvider(authCtx, settings.connectionId);
        String outputFolderType = fsProviderProvider.providerType;
        if (settings.typeOptionId != null) {
            outputFolderType = settings.typeOptionId;
        }
        Partitionable copyPartitioningFrom = null;
        if (settings.partitioningOptionId != null && settings.partitioningOptionId.startsWith("copy:dataset:")) {
            loc = DatasetLocUtils.resolveSmart(projectKey, settings.partitioningOptionId.replace("copy:dataset:", ""));
            copyPartitioningFrom = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc));
        } else if (settings.partitioningOptionId != null && settings.partitioningOptionId.startsWith("copy:folder:")) {
            loc = DatasetLocUtils.resolveSmart(projectKey, settings.partitioningOptionId.replace("copy:folder:", ""));
            copyPartitioningFrom = (Partitionable)this.dao.getMandatoryUnsafe(loc);
        } else if (settings.partitioningOptionId != null && settings.partitioningOptionId.startsWith("copy:")) {
            loc = DatasetLocUtils.resolveSmart(projectKey, settings.partitioningOptionId.replace("copy:", ""));
            copyPartitioningFrom = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc));
        }
        ManagedFolder odb = new ManagedFolder(projectKey, SecretKeyGenerator.generate((int)8));
        odb.name = name;
        this.flowZonesService.attachObjectToZone(settings.zone, projectKey, odb);
        if (copyPartitioningFrom != null && copyPartitioningFrom.getPartitioningSchema() != null) {
            odb.partitioning = ManagedDatasetsHelper.copyToFSLikePartitioning(copyPartitioningFrom.getPartitioningSchema());
        }
        if (fsProviderProvider.isCustom) {
            odb.type = fsProviderProvider.providerType;
            odb.params = new CustomFSProviderDatasetParams();
            odb.params.path = "/${projectKey}/${odbId}";
        } else {
            DatasetHandlerFactory.getMeta(outputFolderType).fillManagedFolderParams(odb, fsProviderProvider.connection, false);
        }
        this.create(odb, authCtx);
        return odb;
    }

    public void create(ManagedFolder mf, AuthCtx authCtx) throws Exception {
        ManagedFoldersService.checkConnectionPermission(mf.params, authCtx, "create a managed folder on");
        this.save(mf, true, false);
        this.onPostManagedFolderCreation(mf, authCtx);
        this.graphService.invalidateCache();
    }

    public List<ManagedFolder> list(String projectKey) throws IOException {
        return this.dao.list(projectKey);
    }

    private void onPostManagedFolderCreation(ManagedFolder mf, AuthCtx authCtx) {
        TransactionContext.retrieveWrite().onPostCommit(() -> {
            try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
                if ("HDFS".equals(mf.getType())) {
                    new HDFSPermissionsHandler(handler).setGatewayACLCreate(authCtx);
                }
                handler.ensurePartitionFolder(null);
            }
            catch (Exception ex) {
                logger.warn((Object)"Could not initialize folder", (Throwable)ex);
            }
        });
    }

    public Callable<Void> handleCreateSubFolderRequest(String projectKey, String odbId, final String path, AuthCtx authCtx) throws Exception {
        ManagedFolder mf = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, odbId);
        final ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);
        final FSProvider provider = handler.getProvider();
        if (!(provider instanceof DirectoryAware)) {
            throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_CANNOT_CREATE_FOLDER_ON_DIRECTORY_UNAWARE_FS, "");
        }
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    ((DirectoryAware)provider).ensureDirectory(path);
                }
                finally {
                    handler.close();
                }
                return null;
            }
        };
    }

    public FutureResponse<FSMoveResult> handleRenameItemRequest(String projectKey, String folderId, String path, boolean isDirectory, String newName, AuthCtx authCtx) throws Exception {
        if (newName.indexOf("/") != -1) {
            throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_INVALID_FILE_NAME, "New name cannot contain '/'");
        }
        if (newName.indexOf("\\") != -1) {
            throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_INVALID_FILE_NAME, "New name cannot contain '\\'");
        }
        if (StringUtils.equals((String)newName, (String)"..")) {
            throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_INVALID_FILE_NAME, "New name cannot be '..'");
        }
        if (StringUtils.equals((String)newName, (String)".")) {
            throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_INVALID_FILE_NAME, "New name cannot be '.'");
        }
        String newPath = PathUtils.concatLNT((String[])new String[]{path.substring(0, path.length() - FilenameUtils.getName((String)path).length()), newName});
        FSMovingItem[] itemToMove = new FSMovingItem[]{new FSMovingItem(path, newPath, isDirectory)};
        return this.handleMoveItemsRequest(projectKey, folderId, itemToMove, authCtx);
    }

    public FutureResponse<FSMoveResult> handleMoveItemsRequest(String projectKey, String folderId, final FSMovingItem[] items, AuthCtx authCtx) throws Exception {
        ManagedFolderHandler handler;
        try (Transaction t = this.transactionService.beginRead();){
            ManagedFolder mf = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, folderId);
            handler = (ManagedFolderHandler)mf.buildHandler(authCtx);
        }
        final FSProvider provider = handler.getProvider();
        SimpleFutureThread<FSMoveResult> sft = new SimpleFutureThread<FSMoveResult>(authCtx){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected FSMoveResult compute() throws Exception {
                FSMoveResult result = new FSMoveResult();
                result.paths = new ArrayList<FSBrowsePath>();
                try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Moving items", (double)items.length, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    for (FSMovingItem item : items) {
                        try {
                            if (item.isDirectory) {
                                provider.moveDirectory(item.fromPath, item.toPath);
                                result.paths.add(handler.browse(item.toPath, FSProvider.FSBrowseStrategy.DIRECTORY));
                            } else {
                                provider.moveFile(item.fromPath, item.toPath);
                                result.paths.add(handler.browse(item.toPath, FSProvider.FSBrowseStrategy.FILE));
                            }
                        }
                        catch (CodedException e) {
                            result.messages.add(InfoMessage.fatal((InfoMessage.MessageCode)e.getCode(), (String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
                        }
                        catch (Exception e) {
                            result.messages.add(InfoMessage.fatal((String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
                        }
                        result.summarize();
                        state.increment(1.0);
                    }
                    ManagedFoldersService.this.graphService.invalidateCache();
                }
                finally {
                    handler.close();
                }
                return result;
            }

            public FuturePayload getPayload() {
                FuturePayload fp = new FuturePayload();
                fp.action = "managed_folders_move";
                fp.displayName = "List importable SQL tables in ";
                return fp;
            }
        };
        return this.futureService.runFuture(sft, 0L, new TypeToken<FutureResponse<FSMoveResult>>(){});
    }

    public void performDeletion(AuthCtx authCtx, String projectKey, String odbId, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        ManagedFolder odb = null;
        try {
            odb = (ManagedFolder)this.dao.getOrNull(projectKey, odbId);
            this.customPolicyHooksRegistry.onPreObjectDelete(authCtx, odb);
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            // empty catch block
        }
        TaggableObjectsDeletionService.DeletionImpact di = this.computeDeletionImpact(authCtx, projectKey, odbId, ignored);
        for (TaggableObjectsDeletionService.ImpactedDataset impactedDataset2 : di.deletedDatasets) {
            this.datasetSaveService.delete(impactedDataset2.projectKey, impactedDataset2.name);
        }
        HashSet<TaggableObjectsService.TaggableObjectRef> ignoredWithDeletedDatasets = ignored == null ? new HashSet<TaggableObjectsService.TaggableObjectRef>() : new HashSet<TaggableObjectsService.TaggableObjectRef>(ignored);
        ignoredWithDeletedDatasets.addAll(di.deletedDatasets.stream().map(impactedDataset -> new TaggableObjectsService.TaggableObjectRef(impactedDataset.projectKey, ITaggingService.TaggableType.DATASET, impactedDataset.name)).collect(Collectors.toList()));
        for (TaggableObjectsDeletionService.ImpactedRecipe recipe : di.deletedRecipes) {
            this.recipeSaveService.delete(recipe.projectKey, recipe.name);
        }
        for (TaggableObjectsDeletionService.ImpactedLabelingTask labelingTask : di.deletedLabelingTasks) {
            this.labelingTasksCRUDService.delete(authCtx, labelingTask.projectKey, labelingTask.id, ignoredWithDeletedDatasets);
        }
        JsonObject jsonObject = new JsonObject();
        try {
            if (odb != null) {
                this.flowZonesService.cleanupObjectFromZones(projectKey, odb);
                jsonObject.addProperty("objectDisplayName", odb.name);
            }
        }
        catch (Exception labelingTask) {
            // empty catch block
        }
        try {
            this.exposedObjectsService.removeExposedObject(projectKey, ITaggingService.TaggableType.MANAGED_FOLDER, odbId);
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Unable to remove objet sharing for %s(%s) on project %s.", new Object[]{ITaggingService.TaggableType.MANAGED_FOLDER, odbId, projectKey});
        }
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.MANAGED_FOLDER, projectKey, odbId, t.getUser(), TaggableObjectChangedEvent.ActionType.MANAGED_FOLDER_DELETE).withDetails(jsonObject));
        this.dao.delete(projectKey, odbId);
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, String projectKey, String folderId, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        return this.computeDeletionImpact(authCtx, projectKey, projectKey, folderId, ignored);
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, @Nonnull String contextProjectKey, String projectKey, String folderId, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        ProjectFlowGraph projectFlowGraph;
        FlowComputable fcUnsafe;
        TaggableObjectsDeletionService.DeletionImpact di = new TaggableObjectsDeletionService.DeletionImpact();
        AnyLoc folderLoc = new AnyLoc(projectKey, folderId);
        List<SerializedRecipe> connectedRecipes = this.graphService.getSuccessorAndPredecessorRecipesAcrossProjectsUnsafe(folderLoc);
        for (SerializedRecipe serializedRecipe : connectedRecipes) {
            this.addRecipeToDeletionImpact(authCtx, serializedRecipe, di, contextProjectKey, ignored);
        }
        if (!contextProjectKey.equals(projectKey)) {
            for (SerializedRecipe serializedRecipe : this.recipesDAO.listUnsafe(contextProjectKey)) {
                if (!serializedRecipe.getFlatInputs().stream().map(input -> input.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(folderLoc)) && !serializedRecipe.getFlatOutputs().stream().map(output -> output.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(folderLoc))) continue;
                this.addRecipeToDeletionImpact(authCtx, serializedRecipe, di, contextProjectKey, ignored);
            }
        }
        List<LabelingTask> successorLabelingTasks = this.graphService.getSuccessorLabelingTasksAcrossProjectsUnsafe(folderLoc);
        for (LabelingTask labelingTask : successorLabelingTasks) {
            this.addLabelingTaskToDeletionImpact(authCtx, labelingTask, di, contextProjectKey, ignored);
        }
        if (!contextProjectKey.equals(projectKey)) {
            for (LabelingTask sr : this.labelingTasksDAO.listUnsafe(contextProjectKey)) {
                if (!sr.getFlatInputs().stream().map(input -> input.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(folderLoc))) continue;
                this.addLabelingTaskToDeletionImpact(authCtx, sr, di, contextProjectKey, ignored);
            }
        }
        if ((fcUnsafe = (projectFlowGraph = this.graphService.getProjectGraphUnsafe(projectKey)).getComputable(projectKey + "." + folderId)) != null) {
            this.addImplicitRecipesToDeletionImpact(authCtx, fcUnsafe.getSuccessors(), di, ignored);
        }
        Set<String> folderExpositionTargetProjects = this.projectsService.getObjectExpositionTargetProjects(folderLoc.getProjectKey(), folderLoc.getId());
        for (String targetProject : folderExpositionTargetProjects) {
            ProjectFlowGraph foreignGraphUnsafe;
            FlowComputable foreignFcUnsafe;
            if (!this.permissionsService.hasProjectPrivilege(authCtx, targetProject, Privileges.ProjectLevelPrivilegeType.READ_CONF) || (foreignFcUnsafe = (foreignGraphUnsafe = this.graphService.getProjectGraphUnsafe(targetProject)).getComputable(projectKey + "." + folderId)) == null) continue;
            this.addForeignImplicitRecipesToDeletionImpact(foreignFcUnsafe.getSuccessors(), di, ignored);
        }
        TaggableObjectsDeletionService.AvailableDeletionOptions availableOptions = new TaggableObjectsDeletionService.AvailableDeletionOptions();
        availableOptions.shouldGiveOptionToDropData = true;
        ManagedFolder odb = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, folderId);
        AbstractFSDatasetHandler.AbstractFSConfig params = odb.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class);
        boolean bl = availableOptions.isDropDataDangerous = StringUtils.isBlank((String)params.path) || "/".equals(params.path);
        if (availableOptions.isDropDataDangerous) {
            String connectionName = StringUtils.defaultIfBlank((String)params.connection, (String)"no_connection");
            boolean allowed = ApplicationConfigurator.getParams().getBoolParam("dku.datasets.managed." + connectionName + ".allowClearRoot", false);
            if (!allowed) {
                availableOptions.shouldGiveOptionToDropData = false;
            }
        }
        di.availableOptions.put(projectKey + "." + folderId, availableOptions);
        return di;
    }

    private void addLabelingTaskToDeletionImpact(AuthCtx authCtx, LabelingTask labelingTask, TaggableObjectsDeletionService.DeletionImpact di, @Nonnull String contextProjectKey, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws DKUSecurityException {
        String labelingTaskProjectKey = labelingTask.getProjectKey();
        if (ignored == null || !ignored.contains(new TaggableObjectsService.TaggableObjectRef(labelingTaskProjectKey, ITaggingService.TaggableType.LABELING_TASK, labelingTask.id))) {
            TaggableObjectsDeletionService.ImpactedLabelingTask impactedLabelingTask = new TaggableObjectsDeletionService.ImpactedLabelingTask(labelingTaskProjectKey, labelingTask.id, labelingTask.name);
            if (contextProjectKey.equals(labelingTaskProjectKey)) {
                di.deletedLabelingTasks.add(impactedLabelingTask);
                try {
                    di.merge(this.labelingTasksCRUDService.computeDeletionImpact(authCtx, labelingTaskProjectKey, labelingTask.id, ignored));
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to compute labeling task deletion impact: ", (Throwable)e);
                }
            } else if (this.permissionsService.hasProjectPrivilege(authCtx, labelingTaskProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                di.foreignReadableLabelingTasks.add(impactedLabelingTask);
            }
        }
    }

    private void addRecipeToDeletionImpact(AuthCtx authCtx, SerializedRecipe sr, TaggableObjectsDeletionService.DeletionImpact di, @Nonnull String contextProjectKey, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws DKUSecurityException {
        String recipeProjectKey = sr.getProjectKey();
        if (ignored == null || !ignored.contains(new TaggableObjectsService.TaggableObjectRef(sr.getProjectKey(), ITaggingService.TaggableType.RECIPE, sr.name))) {
            TaggableObjectsDeletionService.ImpactedRecipe impactedRecipe = new TaggableObjectsDeletionService.ImpactedRecipe(recipeProjectKey, sr.name, sr.type);
            if (contextProjectKey.equals(recipeProjectKey)) {
                di.deletedRecipes.add(impactedRecipe);
            } else if (this.permissionsService.hasProjectPrivilege(authCtx, recipeProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                di.foreignReadableRecipes.add(impactedRecipe);
            }
        }
    }

    private void addImplicitRecipesToDeletionImpact(AuthCtx authCtx, List<? extends GraphNode> nodes, TaggableObjectsDeletionService.DeletionImpact di, Set<TaggableObjectsService.TaggableObjectRef> ignored) {
        for (GraphNode graphNode : nodes) {
            try {
                if (!(graphNode instanceof FlowImplicitRecipe)) continue;
                for (GraphNode graphNode2 : graphNode.getSuccessors()) {
                    if (!(graphNode2 instanceof FlowDataset)) continue;
                    FlowDataset fd = (FlowDataset)graphNode2;
                    SerializedDataset sds = fd.getSerializedMandatoryUnsafe(this.datasetsDAO);
                    di.deletedDatasets.add(new TaggableObjectsDeletionService.ImpactedDataset(sds.projectKey, sds.name, sds.type));
                    di.merge(this.datasetDeletionService.computeDeletionImpact(authCtx, Dataset.fromSerialized(sds), ignored, false));
                }
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get managed folder info: ", (Throwable)e);
            }
        }
    }

    private void addForeignImplicitRecipesToDeletionImpact(List<? extends GraphNode> nodes, TaggableObjectsDeletionService.DeletionImpact di, Set<TaggableObjectsService.TaggableObjectRef> ignored) {
        for (GraphNode graphNode : nodes) {
            try {
                if (!(graphNode instanceof FlowImplicitRecipe)) continue;
                for (GraphNode graphNode2 : graphNode.getSuccessors()) {
                    if (!(graphNode2 instanceof FlowDataset)) continue;
                    FlowDataset fd = (FlowDataset)graphNode2;
                    SerializedDataset sds = fd.getSerializedMandatoryUnsafe(this.datasetsDAO);
                    di.foreignReadableDatasets.add(new TaggableObjectsDeletionService.ImpactedDataset(sds.projectKey, sds.name, sds.type));
                }
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get managed folder info: ", (Throwable)e);
            }
        }
    }

    public void clear(AuthCtx authCtx, ManagedFolder odb) throws Exception {
        logger.info((Object)("Clear managed folder " + odb.getDisplayName() + " (" + odb.getFullId() + ")"));
        this.kernelsManagedFolderService.clear(authCtx, odb);
        DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(odb.projectKey, odb.id);
        this.jobsDatabaseService.clearForDataset(loc);
        try {
            this.flowExecutionService.clearTimestampsForDataset(loc);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to clear timestamps for folder " + odb.getFullName()), (Throwable)e);
        }
    }

    public void clear(AuthCtx authCtx, ManagedFolder odb, List<String> partitionIds) throws Exception {
        this.kernelsManagedFolderService.clear(authCtx, odb, partitionIds);
        DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(odb.projectKey, odb.id);
        for (String partitionId : partitionIds) {
            this.jobsDatabaseService.clearForDataset(loc, partitionId);
        }
        try {
            this.flowExecutionService.clearTimestampsForDatasetPartitions(loc, partitionIds);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to clear timestamps for folder " + odb.getFullName()), (Throwable)e);
        }
    }

    public FSPathOrDirectory getItemInfo(String projectKey, String folderId, String itemPath, AuthCtx authCtx) throws Exception {
        ManagedFolder mf = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, folderId);
        ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);
        try (FSProvider provider = handler.getProvider();){
            FSPathOrDirectory fSPathOrDirectory = provider.stat(itemPath);
            return fSPathOrDirectory;
        }
    }

    public Callable<ItemPreview> handlePreviewRequest(String projectKey, String folderId, final String itemPath, AuthCtx authCtx) throws Exception {
        ManagedFolder mf = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, folderId);
        final ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);
        handler.getProvider();
        return new Callable<ItemPreview>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ItemPreview call() throws Exception {
                try {
                    ItemPreview tried;
                    String mimeTypeInside;
                    Object itemStream;
                    ItemPreview preview = new ItemPreview();
                    preview.itemPath = itemPath;
                    preview.name = FilenameUtils.getName((String)itemPath);
                    preview.contentType = handler.getFileContentType(itemPath);
                    EnrichedInputStream enrichedInputStream = handler.getInputStream(itemPath);
                    preview.size = enrichedInputStream.size();
                    long itemSizeFromHandler = handler.getFileSize(itemPath);
                    if (itemPath.endsWith(".gz")) {
                        itemStream = new GzipCompressorInputStream(enrichedInputStream.rawStream());
                        try {
                            mimeTypeInside = DKUtils.guessMimeTypeFromExtension((String)itemPath.substring(0, itemPath.length() - ".gz".length()));
                            tried = ManagedFoldersService.this.previewAsText(mimeTypeInside, preview, itemSizeFromHandler, (InputStream)itemStream);
                            if (tried != null) {
                                ItemPreview itemPreview = tried;
                                return itemPreview;
                            }
                        }
                        finally {
                            ((InputStream)itemStream).close();
                        }
                    }
                    if (itemPath.endsWith(".bz2")) {
                        itemStream = new BZip2CompressorInputStream(enrichedInputStream.rawStream());
                        try {
                            mimeTypeInside = DKUtils.guessMimeTypeFromExtension((String)itemPath.substring(0, itemPath.length() - ".bz2".length()));
                            tried = ManagedFoldersService.this.previewAsText(mimeTypeInside, preview, itemSizeFromHandler, (InputStream)itemStream);
                            if (tried != null) {
                                ItemPreview itemPreview = tried;
                                return itemPreview;
                            }
                        }
                        finally {
                            ((InputStream)itemStream).close();
                        }
                    }
                    if (preview.contentType != null) {
                        if (preview.contentType.startsWith("image/")) {
                            preview.type = PreviewType.IMAGE;
                            itemStream = preview;
                            return itemStream;
                        }
                        if (archiveMimeTypePattern.matcher(preview.contentType).matches()) {
                            preview.type = PreviewType.ARCHIVE;
                            itemStream = preview;
                            return itemStream;
                        }
                        if (preview.contentType.equals("application/pdf") || preview.contentType.equals("application/x-pdf")) {
                            preview.type = PreviewType.PDF;
                            itemStream = preview;
                            return itemStream;
                        }
                    }
                    itemStream = enrichedInputStream.rawStream();
                    try {
                        ItemPreview tried2 = ManagedFoldersService.this.previewAsText(preview.contentType, preview, itemSizeFromHandler, (InputStream)itemStream);
                        if (tried2 != null) {
                            ItemPreview itemPreview = tried2;
                            return itemPreview;
                        }
                    }
                    finally {
                        if (itemStream != null) {
                            ((InputStream)itemStream).close();
                        }
                    }
                    preview.type = PreviewType.BINARY;
                    ItemPreview itemPreview = preview;
                    return itemPreview;
                }
                finally {
                    handler.close();
                }
            }
        };
    }

    private ItemPreview previewAsText(String mimeType, ItemPreview preview, long itemSizeFromHandler, InputStream itemStream) throws IOException {
        Charset[] charsets;
        boolean isText = DKUtils.isTextLikeMimeType((String)preview.contentType);
        byte[] readBytes = new byte[65536];
        int readFromStream = itemStream.read(readBytes);
        ByteBuffer buffer = readFromStream > 0 ? ByteBuffer.wrap(readBytes, 0, readFromStream) : ByteBuffer.allocate(0);
        boolean hasMoreBytes = readFromStream > 0 && itemSizeFromHandler > (long)readFromStream;
        for (Charset charset : charsets = new Charset[]{StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1}) {
            logger.info((Object)("Trying to get sample with charset " + charset.name()));
            ItemPreview tried = this.tryPreviewWithCharset(preview, buffer, charset, hasMoreBytes, isText);
            if (tried == null) continue;
            tried.contentType = mimeType;
            return tried;
        }
        return null;
    }

    private ItemPreview tryPreviewWithCharset(ItemPreview preview, ByteBuffer buffer, Charset charset, boolean hasMoreBytes, boolean isText) {
        CharsetDecoder cd = charset.newDecoder();
        cd.onMalformedInput(CodingErrorAction.REPORT);
        cd.onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer decoded = CharBuffer.allocate(131072);
        buffer.rewind();
        CoderResult decoding = cd.decode(buffer, decoded, !hasMoreBytes);
        if (!decoding.isError()) {
            decoded.flip();
            String previewHead = decoded.toString();
            if (!(this.hasStrangeCharacters(previewHead) || !isText && this.hasLongLine(previewHead))) {
                preview.type = "application/json".equals(preview.contentType) ? PreviewType.JSON : PreviewType.TEXT;
                preview.hasMore = hasMoreBytes;
                preview.charsetUsed = charset.name();
                preview.head = previewHead;
                return preview;
            }
        }
        return null;
    }

    private boolean hasStrangeCharacters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c2 = s.charAt(i);
            if (c2 > '\b') continue;
            return true;
        }
        return false;
    }

    private boolean hasLongLine(String s) {
        String[] lines;
        for (String line : lines = s.split("\n")) {
            if (line.length() <= 3072) continue;
            return true;
        }
        return false;
    }

    public Callable<InputStream> createPreviewImageStream(String projectKey, String folderId, String itemPath, AuthCtx authCtx) throws Exception {
        ManagedFolder mf = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, folderId);
        ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);
        handler.getProvider();
        return () -> {
            InputStream is = handler.getInputStream(itemPath).rawStream();
            return new ManagedFolderHandler.WrappedInputStream(handler, is);
        };
    }

    public void handlePreviewImageRequest(HttpServletResponse resp, String contentType, Callable<InputStream> previewImage) throws Exception {
        try (InputStream picData = previewImage.call();){
            resp.setContentType(contentType);
            IOUtils.copy((InputStream)picData, (OutputStream)resp.getOutputStream());
        }
    }

    public Callable<FSBrowsePath> handleBrowseRequest(String projectKey, String folderId, String rawPath, AuthCtx authCtx) throws Exception {
        String path;
        ManagedFolder mf = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, folderId);
        if (rawPath.length() == 0) {
            path = "/";
        } else {
            VariablesContext vc = this.variablesService.getForProject(mf.getProjectKey());
            vc.add("projectKey", mf.getProjectKey());
            vc.add("odbId", mf.getId());
            path = VariablesUtils.expand(mf.getProjectKey(), rawPath);
        }
        final ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);
        handler.getProvider();
        logger.info((Object)("Browse " + path + " from " + projectKey + "." + folderId));
        return new Callable<FSBrowsePath>(){

            @Override
            public FSBrowsePath call() throws Exception {
                try {
                    FSBrowsePath fSBrowsePath = handler.browseDirectory(path);
                    return fSBrowsePath;
                }
                finally {
                    handler.close();
                }
            }
        };
    }

    private static void checkConnectionPermission(AbstractFSDatasetHandler.AbstractFSConfig params, AuthCtx liu, String deniedAction) throws IOException, DKUSecurityException {
        assert (liu != null);
        String connection = params.getConnection();
        if (connection != null) {
            DSSConnection c2 = ConnectionsDAO.get().getMandatoryConnectionUnsafeUnexpanded(liu, connection);
            boolean allowManagedFolders = c2.allowManagedFolders;
            if (!allowManagedFolders && DKUApp.getParams().getBoolParam("dku.security.unsafe.securityBypasses.allowManagedFoldersDespiteConnectionRejectingThem", false)) {
                logger.warn((Object)"UNSECURE: Disabling security check for 'allowManagedFolders' flag on connections (requested by admin)");
                allowManagedFolders = true;
            }
            if (!c2.isFreelyUsableBy(liu) || !allowManagedFolders) {
                throw new SecurityException("You may not " + deniedAction + " connection " + connection);
            }
        }
    }

    public static class ManagedFolderCreationSettings {
        public String partitioningOptionId;
        public String connectionId;
        public String typeOptionId;
        public String zone;
    }

    public static class ItemPreview {
        String itemPath;
        String name;
        PreviewType type;
        String head;
        String charsetUsed;
        String contentType;
        long size;
        boolean hasMore;
    }

    public static enum PreviewType {
        TEXT,
        IMAGE,
        BINARY,
        PDF,
        ARCHIVE,
        JSON;

    }

    public static class FSMoveResult
    extends InfoMessage.InfoMessages {
        public List<FSBrowsePath> paths;
    }
}

