/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec;

import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.ModelEvaluationComparatorsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.mec.ModelComparison;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LicenseFeaturesStatusBuilder;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelComparisonsCRUDService {
    @Autowired
    ModelEvaluationComparatorsDAO modelEvaluationComparatorsDAO;
    @Autowired
    TaggableObjectsService taggableObjectsService;
    @Autowired
    TaggingService taggingService;
    @Autowired
    TaggableObjectDiffService taggableObjectDiffService;
    @Autowired
    CustomFieldsService customFieldsService;
    @Autowired
    PubSubService pubSubService;
    @Autowired
    CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    LicenseStatusService licenseStatusService;
    @Autowired
    LicenseEnforcementService licenseEnforcementService;

    public ModelComparison getMandatory(String projectKey, String id) throws IOException {
        return (ModelComparison)this.modelEvaluationComparatorsDAO.getMandatory(projectKey, id);
    }

    public ModelComparison getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return (ModelComparison)this.modelEvaluationComparatorsDAO.getMandatoryUnsafe(projectKey, id);
    }

    public void delete(AuthCtx authCtx, String projectKey, String id) throws IOException, CodedException {
        this.customPolicyHooksRegistry.onPreObjectDelete(authCtx, (TaggableObjectsService.TaggableObject)this.modelEvaluationComparatorsDAO.getOrNull(projectKey, id));
        this.modelEvaluationComparatorsDAO.delete(projectKey, id);
        this.pubSubService.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.MODEL_COMPARISON, projectKey, id, authCtx, TaggableObjectChangedEvent.ActionType.MODEL_COMPARISON_DELETE));
    }

    public List<ModelComparison> list(String projectKey) throws IOException {
        return this.modelEvaluationComparatorsDAO.list(projectKey);
    }

    public List<ModelComparison> listUnsafe(String projectKey) throws IOException {
        return this.modelEvaluationComparatorsDAO.listUnsafe(projectKey);
    }

    public ModelComparison save(AuthCtx authCtx, ModelComparison modelComparison, boolean creation, boolean summaryOnly) throws IOException, CodedException, DKUSecurityException, LicenseRestrictionException {
        TaggableObjectChangedEvent.ActionType action;
        Preconditions.checkNotNull((Object)modelComparison.projectKey);
        Preconditions.checkNotNull((Object)modelComparison.id);
        if (modelComparison.modelTaskType.isLLM()) {
            LicenseStatusService.LicensingStatus ls = this.licenseStatusService.getLicensingStatus();
            AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus featuresStatus = LicenseFeaturesStatusBuilder.getFeaturesStatus(ls);
            if (!featuresStatus.advancedLLMMeshAllowed) {
                throw new LicenseRestrictionException("LLM Evaluation requires Advanced LLM Mesh, which is not enabled in your license.");
            }
            this.licenseEnforcementService.checkFullLLMMeshAllowed(authCtx);
        }
        RWTransactionRef t = TransactionContext.retrieveWrite();
        ModelComparison preExisting = (ModelComparison)this.modelEvaluationComparatorsDAO.getOrNullUnsafe(modelComparison.projectKey, modelComparison.id);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(modelComparison, preExisting);
        TaggableObjectDiffService.TaggableObjectsDiff diff = new TaggableObjectDiffService.TaggableObjectsDiff();
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", modelComparison.displayName);
        if (creation) {
            modelComparison.creationTag = new VersionTag(t.getUser().getIdentifier());
            action = TaggableObjectChangedEvent.ActionType.MODEL_COMPARISON_CREATE;
            this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(modelComparison);
        } else if (modelComparison.displayName != null && preExisting != null && !modelComparison.displayName.equals(preExisting.displayName)) {
            action = TaggableObjectChangedEvent.ActionType.MODEL_COMPARISON_RENAME;
            details.addProperty("newName", modelComparison.displayName);
            details.addProperty("oldName", preExisting.displayName);
        } else {
            action = TaggableObjectChangedEvent.ActionType.MODEL_COMPARISON_EDIT;
            diff = this.taggableObjectDiffService.diff(preExisting, modelComparison, t.getUser().getIdentifier());
        }
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), (TaggableObjectsService.TaggableObject)this.modelEvaluationComparatorsDAO.getOrNull(modelComparison.projectKey, modelComparison.id), modelComparison);
        this.modelEvaluationComparatorsDAO.save(modelComparison);
        if (diff.metadataChanged()) {
            this.taggableObjectDiffService.publishAfterTransaction(diff);
        }
        if (!summaryOnly) {
            this.pubSubService.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.MODEL_COMPARISON, modelComparison.projectKey, modelComparison.id, t.getUser(), action).withDetails(details));
        }
        this.taggingService.onObjectSaved(modelComparison.projectKey, modelComparison.tags);
        return modelComparison;
    }

    public ModelComparison create(AuthCtx authCtx, String projectKey, String displayName, ModelComparison.ModelTaskType modelTaskType) throws IOException, CodedException, DKUSecurityException, LicenseRestrictionException {
        if (null == modelTaskType) {
            throw new IllegalArgumentException("Model task type is not supported.");
        }
        ModelComparison modelComparison = new ModelComparison(projectKey);
        modelComparison.displayName = displayName;
        modelComparison.modelTaskType = modelTaskType;
        this.save(authCtx, modelComparison, true, false);
        return modelComparison;
    }

    public ModelComparison getOrNull(String projectKey, String id) throws IOException {
        return (ModelComparison)this.modelEvaluationComparatorsDAO.getOrNull(projectKey, id);
    }

    public int approximateCount(String projectKey) throws IOException {
        return this.modelEvaluationComparatorsDAO.approximateCount(projectKey);
    }
}

