/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.analysis.coreservices.PredictionService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.prediction.PredictionPostComputationHandler;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.prediction.PredictionIndividualExplanations;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.mec.AbstractModelEvaluation;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.ModelComparisonsService;
import com.dataiku.dip.mec.ModelEvaluationCodes;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.mec.drift.DriftParams;
import com.dataiku.dip.mec.drift.DriftResult;
import com.dataiku.dip.mec.drift.DriftService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Params;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelEvaluationService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private PredictionService predictionService;
    @Autowired
    private DriftService driftService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.services.modelevaluation");

    public AbstractModelEvaluation getModelEvaluation(FullModelEvaluationId fme) throws IOException {
        return fme.getModelEvaluation();
    }

    public void saveModelUserMeta(TabularModelEvaluation me, ModelUserMeta meta) throws IOException {
        switch (Objects.requireNonNull(me.modelType)) {
            case ANALYSIS_MODEL: 
            case SAVED_MODEL: 
            case EXTERNAL: {
                me.modelParams.addProperty("name", StringUtils.defaultIfBlank((String)meta.name, (String)me.modelParams.get("name").getAsString()));
                me.modelParams.addProperty("description", meta.description);
                break;
            }
            default: {
                throw new NotImplementedException("Unknown model type in evaluation: " + String.valueOf((Object)me.modelType));
            }
        }
        this.save(me);
    }

    public FutureResponse<DriftResult> startDriftComputation(DSSAuthCtx owner, String projectKey, ModelLikeId referenceModelLikeId, ModelLikeId currentModelLikeId, DriftParams params) throws Exception {
        return this.driftService.startDriftComputation(owner, projectKey, referenceModelLikeId, currentModelLikeId, params);
    }

    public ModelLikeId getReferenceForDrift(ModelLikeId currentId) throws IOException {
        return this.driftService.getReferenceForDrift(currentId);
    }

    public List<ModelComparisonsService.ComparableModelItem> getCompatibleReferences(String projectKey, ModelLikeId currentId, @Nullable InfoMessage.InfoMessages infoMessages, int maxComparables) throws IOException, DKUSecurityException {
        return this.driftService.getCompatibleReferences(projectKey, currentId, infoMessages, maxComparables);
    }

    public void save(AbstractModelEvaluation me) throws IOException {
        JSON.prettyToFile((Object)me, (File)me.ref.getModelEvaluationFile());
    }

    public FutureResponse<?> subpopulationComputationStart(DSSAuthCtx user, FullModelEvaluationId fme, List<String> features, JsonObject computationParams) throws Exception {
        if (computationParams == null) {
            computationParams = new JsonObject();
        }
        PredictionService.assertFeaturesInModelPerFeature(fme, features, PredictionPostComputationHandler.PostComputationCommand.MODELLESS_SUBPOPULATION);
        computationParams.add("features_to_compute", (JsonElement)JSON.toJsonArray(features));
        Params dipProperties = ApplicationConfigurator.getParams();
        int maxModalities = dipProperties.getIntParam("dku.ml.postTraining.subpopulation.maxModalities", Integer.valueOf(10));
        computationParams.addProperty("max_modalities", (Number)maxModalities);
        PredictionPostComputationHandler.PostComputationCommand.MODELLESS_SUBPOPULATION.checkCompatible(fme);
        PredictionPostComputationHandler.SubpopulationMEWorkThread thread = new PredictionPostComputationHandler.SubpopulationMEWorkThread(user, fme, features, computationParams);
        return this.futureService.runFuture(thread, 0L, thread.getTypeToken());
    }

    public FutureResponse<?> pdpComputationStart(DSSAuthCtx user, FullModelEvaluationId fme, List<String> features, JsonObject computationParams) throws Exception {
        if (computationParams == null) {
            computationParams = new JsonObject();
        }
        if (null == fme.getUnderlyingModel()) {
            throw new CodedException((InfoMessage.MessageCode)ModelEvaluationCodes.ERR_SAVED_MODEL_NO_LONGER_AVAILABLE, "Model associate to " + fme.toString() + " not found");
        }
        return this.predictionService.pdpComputationStart(user, fme, features, computationParams);
    }

    public FutureResponse<?> individualExplanationsComputationStart(DSSAuthCtx user, FullModelEvaluationId fme, JsonObject computationParams) throws Exception {
        FullModelId fmi;
        if (computationParams == null) {
            computationParams = new JsonObject();
        }
        if (!(fmi = fme.getUnderlyingModel()).exists()) {
            throw new CodedException((InfoMessage.MessageCode)ModelEvaluationCodes.ERR_SAVED_MODEL_NO_LONGER_AVAILABLE, "Model " + fme.toString() + " not found");
        }
        return this.predictionService.individualExplanationsComputationStart(user, fme, computationParams);
    }

    public PredictionIndividualExplanations getIndividualExplanations(FullModelEvaluationId fme) throws IOException {
        TabularModelEvaluation me = fme.getTabularModelEvaluation();
        TabularModelEvaluation.EvaluatedDSSModel esm = me.getModelParamsAs(TabularModelEvaluation.EvaluatedDSSModel.class);
        FullModelId fmi = new FullModelId(me.ref.getProjectKey(), esm.ref, esm.versionId);
        if (!fmi.exists()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ModelEvaluationCodes.ERR_SAVED_MODEL_NO_LONGER_AVAILABLE, "Model " + String.valueOf(fme) + " not found");
        }
        return PredictionResultsReader.getIndividualExplanations(fme);
    }
}

