/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.EditableDatasetHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.HTTPDatasetHandler;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.engines.BasicMetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BasicProbeType
extends ProbeType {
    public static final String TYPE = "basic";
    private static Map<BasicMetrics, MetricMetadata> metadataPerType = Maps.newHashMap();
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.basic");

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        ArrayList computers = Lists.newArrayList();
        computers.add(new SizeComputer());
        computers.add(new FileCountComputer());
        computers.add(new ColumnCountComputer());
        return computers;
    }

    public BasicProbeType() {
        metadataPerType.put(BasicMetrics.SIZE, new MetricMetadata().withName("Size").withFullName("Size").withFormat("filesize"));
        metadataPerType.put(BasicMetrics.COUNT_FILES, new MetricMetadata().withName("File count").withFullName("File count"));
        metadataPerType.put(BasicMetrics.COUNT_COLUMNS, new MetricMetadata().withName("Column count").withFullName("Column count"));
        this.type = TYPE;
    }

    @Override
    public List<Metric> listBuildableMetrics(Object object, MetricTargetType objectType) {
        ArrayList metrics = Lists.newArrayList();
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            if (DatasetInspector.isFSLike(dataset)) {
                metrics.add(new BasicMetric(BasicMetrics.SIZE));
                metrics.add(new BasicMetric(BasicMetrics.COUNT_FILES));
            }
            if (DatasetInspector.isEditable(dataset)) {
                metrics.add(new BasicMetric(BasicMetrics.SIZE));
            }
            metrics.add(new BasicMetric(BasicMetrics.COUNT_COLUMNS));
        } else if (objectType == MetricTargetType.MANAGED_FOLDER) {
            metrics.add(new BasicMetric(BasicMetrics.SIZE));
            metrics.add(new BasicMetric(BasicMetrics.COUNT_FILES));
        }
        return metrics;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        ArrayList metrics = Lists.newArrayList();
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            if (DatasetInspector.isFSLike(dataset)) {
                metrics.add(new BasicMetric(BasicMetrics.SIZE));
                metrics.add(new BasicMetric(BasicMetrics.COUNT_FILES));
            } else if (DatasetInspector.isEditable(dataset)) {
                metrics.add(new BasicMetric(BasicMetrics.SIZE));
            }
            metrics.add(new BasicMetric(BasicMetrics.COUNT_COLUMNS));
        } else if (objectType == MetricTargetType.MANAGED_FOLDER) {
            metrics.add(new BasicMetric(BasicMetrics.SIZE));
            metrics.add(new BasicMetric(BasicMetrics.COUNT_FILES));
        } else {
            metrics.add(new BasicMetric(BasicMetrics.SIZE));
            metrics.add(new BasicMetric(BasicMetrics.COUNT_FILES));
            metrics.add(new BasicMetric(BasicMetrics.COUNT_COLUMNS));
        }
        return metrics;
    }

    @Override
    public Object listSelectableMetrics(Probe probe, Object object, MetricTargetType objectType) {
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            BasicProbeHint hint = new BasicProbeHint();
            hint.hasCountColumns = true;
            if (DatasetInspector.isFSLike(dataset)) {
                hint.hasSize = true;
                hint.hasCountFiles = true;
            }
            if (DatasetInspector.isEditable(dataset)) {
                hint.hasSize = true;
            }
            return hint;
        }
        if (objectType == MetricTargetType.MANAGED_FOLDER) {
            BasicProbeHint hint = new BasicProbeHint();
            hint.hasSize = true;
            hint.hasCountFiles = true;
            return hint;
        }
        return null;
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> column, Probe probe) {
        return null;
    }

    @Override
    public ProbeType trimForSave() {
        return new BasicProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return BasicProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(0).withName("Basic data");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return false;
    }

    public static class SizeComputer
    extends BasicMetricsEngine.BasicMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return BasicProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            Dataset dataset;
            if (metric instanceof BasicMetric && ((BasicMetric)metric).getMetricType() == BasicMetrics.SIZE && (objectType == MetricTargetType.DATASET ? DatasetInspector.isFSLike(dataset = (Dataset)object) || DatasetInspector.isEditable(dataset) : objectType == MetricTargetType.MANAGED_FOLDER)) {
                return new BasicMetricsEngine.BasicMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public String getAggregate(BasicMetricsEngine.BasicMetricsEngineCallbacks engine, MetricComputation computation) throws Exception {
            if (engine.getDataset() != null) {
                if (engine.getDatasetHandler() instanceof EditableDatasetHandler) {
                    EditableDatasetHandler handler = (EditableDatasetHandler)((Object)engine.getDatasetHandler());
                    return Long.toString(handler.getDataFileSize());
                }
                if (engine.getDatasetHandler() instanceof AbstractFSDatasetHandler) {
                    AbstractFSDatasetHandler handler = (AbstractFSDatasetHandler)engine.getDatasetHandler();
                    if (!MetricsComputationService.isFullDataset(engine.getDataset(), engine.getPartition())) {
                        FilePartition filePartition = null;
                        if (engine.getPartition() instanceof FilePartition) {
                            filePartition = (FilePartition)engine.getPartition();
                        } else {
                            logger.info((Object)("Enumerating FS to get size of partition " + engine.getPartition().id()));
                            InputFilter filter = new InputFilter().withSelectedPartition(engine.getPartition());
                            List fpl = handler.getFilterSplits(filter).getMatchingPartitions();
                            if (fpl.size() == 1) {
                                filePartition = (FilePartition)((Object)fpl.get(0));
                            }
                        }
                        if (filePartition != null) {
                            return Long.toString(filePartition.getTotalSize());
                        }
                        return null;
                    }
                    logger.info((Object)("Enumerating FS to get size of all partitions " + engine.getPartition().id()));
                    long totalSize = 0L;
                    for (Partition partition : engine.getPartitions()) {
                        if (!(partition instanceof FilePartition)) continue;
                        totalSize += ((FilePartition)partition).getTotalSize();
                    }
                    return Long.toString(totalSize);
                }
                if (engine.getDatasetHandler() instanceof HTTPDatasetHandler) {
                    HTTPDatasetHandler handler = (HTTPDatasetHandler)engine.getDatasetHandler();
                    if (!MetricsComputationService.isFullDataset(engine.getDataset(), engine.getPartition())) {
                        FilePartition filePartition = null;
                        if (engine.getPartition() instanceof FilePartition) {
                            filePartition = (FilePartition)engine.getPartition();
                        } else {
                            logger.info((Object)("Enumerating FS to get size of partition " + engine.getPartition().id()));
                            InputFilter filter = new InputFilter().withSelectedPartition(engine.getPartition());
                            List fpl = handler.getFilterSplits(filter).getMatchingPartitions();
                            if (fpl.size() == 1) {
                                filePartition = (FilePartition)((Object)fpl.get(0));
                            }
                        }
                        if (filePartition != null) {
                            return Long.toString(filePartition.getTotalSize());
                        }
                        return null;
                    }
                    logger.info((Object)("Enumerating FS to get size of all partitions " + engine.getPartition().id()));
                    long totalSize = 0L;
                    for (Partition partition : engine.getPartitions()) {
                        if (!(partition instanceof FilePartition)) continue;
                        totalSize += ((FilePartition)partition).getTotalSize();
                    }
                    return Long.toString(totalSize);
                }
                return null;
            }
            if (engine.getFolder() != null) {
                ManagedFolderHandler.ManagedFolderListing files = engine.getManagedFolderHandler().listFS(engine.getPartition(), true, false);
                long totalSize = 0L;
                for (ManagedFolderHandler.ManagedFolderListingItem file : files.items) {
                    totalSize += file.size;
                }
                return Long.toString(totalSize);
            }
            return null;
        }
    }

    public static class FileCountComputer
    extends BasicMetricsEngine.BasicMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return BasicProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof BasicMetric && ((BasicMetric)metric).getMetricType() == BasicMetrics.COUNT_FILES) {
                if (objectType == MetricTargetType.DATASET && DatasetInspector.isFSLike((Dataset)object)) {
                    return new BasicMetricsEngine.BasicMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
                }
                if (objectType == MetricTargetType.MANAGED_FOLDER) {
                    return new BasicMetricsEngine.BasicMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
                }
            }
            return null;
        }

        @Override
        public String getAggregate(BasicMetricsEngine.BasicMetricsEngineCallbacks engine, MetricComputation computation) throws Exception {
            if (engine.getDataset() != null) {
                DatasetHandler handler = engine.getDatasetHandler();
                if (handler instanceof AbstractFSDatasetHandler) {
                    return this.getAggregateFSDataset(engine, (AbstractFSDatasetHandler)handler);
                }
                if (handler instanceof HTTPDatasetHandler) {
                    return this.getAggregateHTTPDataset(engine, (HTTPDatasetHandler)handler);
                }
                return null;
            }
            if (engine.getFolder() != null) {
                ManagedFolderHandler.ManagedFolderListing files = engine.getManagedFolderHandler().listFS(engine.getPartition(), true, false);
                return Long.toString(files.items.size());
            }
            return null;
        }

        private String getAggregateFSDataset(BasicMetricsEngine.BasicMetricsEngineCallbacks engine, AbstractFSDatasetHandler handler) throws Exception {
            if (!MetricsComputationService.isFullDataset(engine.getDataset(), engine.getPartition())) {
                FilePartition filePartition = null;
                if (engine.getPartition() instanceof FilePartition) {
                    filePartition = (FilePartition)engine.getPartition();
                } else {
                    logger.info((Object)("Enumerating FS to get partition files of " + engine.getPartition().id()));
                    InputFilter filter = new InputFilter().withSelectedPartition(engine.getPartition());
                    List fpl = handler.getFilterSplits(filter).getMatchingPartitions();
                    if (fpl.size() == 1) {
                        filePartition = (FilePartition)((Object)fpl.get(0));
                    }
                }
                if (filePartition != null) {
                    return Long.toString(filePartition.getNbFiles());
                }
                return null;
            }
            logger.info((Object)"Enumerating FS to get all partition files");
            int fileCount = 0;
            for (Partition partition : engine.getPartitions()) {
                fileCount += ((FilePartition)partition).getNbFiles();
            }
            return Integer.toString(fileCount);
        }

        private String getAggregateHTTPDataset(BasicMetricsEngine.BasicMetricsEngineCallbacks engine, HTTPDatasetHandler handler) throws Exception {
            if (!MetricsComputationService.isFullDataset(engine.getDataset(), engine.getPartition())) {
                Partition partition = engine.getPartition();
                if (partition != null) {
                    return Long.toString(handler.getPartitionSplit(partition).getPaths().size());
                }
                return null;
            }
            logger.info((Object)"Enumerating FS to get all partition files");
            int fileCount = 0;
            for (Partition partition : engine.getPartitions()) {
                fileCount += handler.getPartitionSplit(partition).getPaths().size();
            }
            return Integer.toString(fileCount);
        }
    }

    public static class ColumnCountComputer
    extends BasicMetricsEngine.BasicMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return BasicProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof BasicMetric && ((BasicMetric)metric).getMetricType() == BasicMetrics.COUNT_COLUMNS && objectType == MetricTargetType.DATASET) {
                return new BasicMetricsEngine.BasicMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public String getAggregate(BasicMetricsEngine.BasicMetricsEngineCallbacks engine, MetricComputation computation) throws Exception {
            if (engine.getDataset() != null) {
                Schema schema = engine.getDataset().getSchema();
                return Integer.toString(schema.getColumns().size());
            }
            return null;
        }
    }

    public static enum BasicMetrics {
        SIZE,
        COUNT_FILES,
        COUNT_COLUMNS;

    }

    public static class BasicMetric
    extends Metric {
        public BasicMetrics metricType;

        public BasicMetric(BasicMetrics metricType) {
            super(BasicProbeType.TYPE, Type.BIGINT);
            this.metricType = metricType;
            this.id = Metric.serializeMetric(this);
        }

        public BasicMetrics getMetricType() {
            return this.metricType;
        }

        @Override
        public MetricMetadata getMeta() {
            return metadataPerType.get((Object)this.metricType);
        }

        @Override
        public String getColumn() {
            return null;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return this.getId();
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            return new Probe(this.getType()).withConfiguration(new BasicProbeConfiguration()).withMeta(ProbeType.getProbeType(BasicProbeType.TYPE).getMeta());
        }
    }

    public static class BasicProbeHint {
        boolean hasSize;
        boolean hasCountFiles;
        boolean hasCountColumns;
    }

    public static class BasicProbeConfiguration
    implements ProbeConfiguration {
    }

    public static class BasicMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof BasicMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            BasicMetric basicMetric = (BasicMetric)metric;
            return Metric.buildMetricIdFromParts(BasicProbeType.TYPE, basicMetric.getMetricType().name());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() != 2 || !parts.get(0).equals(BasicProbeType.TYPE)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
            }
            return new BasicMetric(BasicMetrics.valueOf(parts.get(1)));
        }
    }
}

