/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class ReportingProbeType
extends ProbeType {
    public static final String TYPE = "reporting";
    private static Map<ReportingMetrics, MetricMetadata> metadataPerType = Maps.newHashMap();

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        return Lists.newArrayList();
    }

    public ReportingProbeType() {
        metadataPerType.put(ReportingMetrics.WARNING_COUNT, new MetricMetadata().withName("Build warning count"));
        metadataPerType.put(ReportingMetrics.BUILD_SUCCESS, new MetricMetadata().withName("Built"));
        metadataPerType.put(ReportingMetrics.BUILD_START_DATE, new MetricMetadata().withName("Build date"));
        metadataPerType.put(ReportingMetrics.BUILD_DURATION, new MetricMetadata().withName("Build duration").withFormat("durationHHMMSSPadded"));
        metadataPerType.put(ReportingMetrics.METRICS_COMPUTATION_DURATION, new MetricMetadata().withName("Metrics computation duration").withFormat("durationHHMMSSPadded"));
        metadataPerType.put(ReportingMetrics.PRED_R2, new MetricMetadata().withName("R2"));
        metadataPerType.put(ReportingMetrics.PRED_EVS, new MetricMetadata().withName("EVS"));
        metadataPerType.put(ReportingMetrics.PRED_MAPE, new MetricMetadata().withName("MAPE"));
        metadataPerType.put(ReportingMetrics.PRED_MAE, new MetricMetadata().withName("MAE"));
        metadataPerType.put(ReportingMetrics.PRED_MSE, new MetricMetadata().withName("MSE"));
        metadataPerType.put(ReportingMetrics.PRED_RMSE, new MetricMetadata().withName("RMSE"));
        metadataPerType.put(ReportingMetrics.PRED_RMSLE, new MetricMetadata().withName("RMSLE"));
        metadataPerType.put(ReportingMetrics.PRED_PEARSON, new MetricMetadata().withName("Pearson"));
        metadataPerType.put(ReportingMetrics.PRED_CUSTOMSCORE, new MetricMetadata().withName("Custom score"));
        metadataPerType.put(ReportingMetrics.PRED_F1, new MetricMetadata().withName("F1"));
        metadataPerType.put(ReportingMetrics.PRED_RECALL, new MetricMetadata().withName("Recall"));
        metadataPerType.put(ReportingMetrics.PRED_PRECISION, new MetricMetadata().withName("Precision"));
        metadataPerType.put(ReportingMetrics.PRED_ACCURACY, new MetricMetadata().withName("Accuracy"));
        metadataPerType.put(ReportingMetrics.PRED_LOGLOSS, new MetricMetadata().withName("Log. loss"));
        metadataPerType.put(ReportingMetrics.PRED_AUC, new MetricMetadata().withName("AUC"));
        metadataPerType.put(ReportingMetrics.PRED_LIFT, new MetricMetadata().withName("Lift"));
        this.type = TYPE;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        return Lists.newArrayList();
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> column, Probe probe) {
        return null;
    }

    @Override
    public ProbeType trimForSave() {
        return new ReportingProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return ReportingProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(0).withName("Activity statistics");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return false;
    }

    public static enum ReportingMetrics {
        WARNING_COUNT,
        BUILD_SUCCESS,
        BUILD_START_DATE,
        BUILD_DURATION,
        METRICS_COMPUTATION_DURATION,
        PRED_R2,
        PRED_EVS,
        PRED_MAPE,
        PRED_MAE,
        PRED_MSE,
        PRED_RMSE,
        PRED_RMSLE,
        PRED_PEARSON,
        PRED_CUSTOMSCORE,
        PRED_F1,
        PRED_RECALL,
        PRED_PRECISION,
        PRED_ACCURACY,
        PRED_LOGLOSS,
        PRED_AUC,
        PRED_LIFT;

    }

    public static class ReportingProbeConfiguration
    implements ProbeConfiguration {
    }

    public static class ReportingMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof ReportingMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            ReportingMetric reportingMetric = (ReportingMetric)metric;
            return Metric.buildMetricIdFromParts(ReportingProbeType.TYPE, reportingMetric.getMetricType().name());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() != 2 || !parts.get(0).equals(ReportingProbeType.TYPE)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
            }
            return new ReportingMetric(ReportingMetrics.valueOf(parts.get(1)));
        }
    }

    public static class ReportingMetric
    extends Metric {
        public ReportingMetrics metricType;

        public ReportingMetric(ReportingMetrics metricType) {
            super(ReportingProbeType.TYPE, ReportingMetric.getDataTypeFromMetricType(metricType));
            this.metricType = metricType;
            this.id = Metric.serializeMetric(this);
        }

        private static Type getDataTypeFromMetricType(ReportingMetrics metricType) {
            Type resultDataType = Type.BIGINT;
            if (metricType == ReportingMetrics.BUILD_SUCCESS) {
                resultDataType = Type.BOOLEAN;
            } else if (metricType == ReportingMetrics.BUILD_START_DATE) {
                resultDataType = Type.DATE;
            } else if (metricType.name().startsWith("PRED_")) {
                resultDataType = Type.DOUBLE;
            }
            return resultDataType;
        }

        public ReportingMetrics getMetricType() {
            return this.metricType;
        }

        @Override
        public String getColumn() {
            return null;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return this.getId();
        }

        @Override
        public MetricMetadata getMeta() {
            return metadataPerType.get((Object)this.metricType);
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            return new Probe(this.getType()).withConfiguration(new ReportingProbeConfiguration()).withMeta(ProbeType.getProbeType(ReportingProbeType.TYPE).getMeta());
        }
    }
}

