/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.density;

import com.dataiku.dip.pivot.backend.density.GaussianKernelFunction;
import com.dataiku.dip.pivot.backend.density.KernelFunction;
import java.util.ArrayList;
import java.util.List;

public class NaiveStreaming1DKDE {
    private List<StepData> steps = new ArrayList<StepData>();
    private double min;
    private double max;
    private double lambda;
    private double stepLen;
    private int nbValues;
    private KernelFunction kernel;

    public NaiveStreaming1DKDE(double lambda, double min, double max, int nbSteps) {
        this.lambda = lambda;
        this.min = min;
        this.max = max;
        this.stepLen = (max - min) / (double)nbSteps;
        for (int i = 0; i < nbSteps; ++i) {
            this.steps.add(new StepData());
        }
        this.kernel = new GaussianKernelFunction();
    }

    public void add(double value) {
        ++this.nbValues;
        for (int i = 0; i < this.steps.size(); ++i) {
            double stepVal = this.min + (double)i * this.stepLen;
            double kernelInput = (value - stepVal) / this.lambda;
            this.steps.get((int)i).kernelizedDistSum += this.kernel.compute(kernelInput);
        }
    }

    public double[] getSteps() {
        double[] ret = new double[this.steps.size()];
        for (int i = 0; i < this.steps.size(); ++i) {
            ret[i] = this.min + (double)i * this.stepLen;
        }
        return ret;
    }

    public double[] getData() {
        double[] ret = new double[this.steps.size()];
        for (int i = 0; i < this.steps.size(); ++i) {
            ret[i] = 1.0 / ((double)this.nbValues * this.lambda) * this.steps.get((int)i).kernelizedDistSum;
        }
        return ret;
    }

    private static class StepData {
        double kernelizedDistSum;

        private StepData() {
        }
    }
}

