/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.hive;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.common.GenericRecipeCreator;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class HiveRecipeCreator
extends GenericRecipeCreator {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private DatasetSaveService datasetSaveService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.hive.creator");

    public HiveRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected RecipeParams makeInitialParams(SerializedRecipe sr, JsonObject creationData) {
        HiveRecipeMeta.HiveRecipeParams params = new HiveRecipeMeta.HiveRecipeParams();
        params = RecipeCreationUtils.setupHiveParams(this.authCtx, sr.projectKey, params);
        return params;
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data) throws Exception {
        String prefill;
        HiveSettings hiveSettings = new ClusterSelector().selectForProject(this.authCtx, recipe.projectKey).getHiveSettings();
        HiveRecipeMeta.HiveRecipeParams newlyCreatedRecipeParams = recipe.getParamsAs(HiveRecipeMeta.HiveRecipeParams.class);
        String firstInputRef = recipe.getInputsForRole((String)"main").get((int)0).ref;
        SerializedDataset inputSD = (SerializedDataset)this.datasetsDAO.getMandatory(DatasetLocUtils.DatasetLoc.resolveSmart(recipe.projectKey, firstInputRef));
        Dataset inputDS = Dataset.fromSerialized(inputSD);
        HiveSQLDialect dialect = new HiveSQLDialect();
        String string = prefill = data.has("script") ? data.get("script").getAsString() : null;
        if (StringUtils.isNotBlank((String)prefill)) {
            return prefill;
        }
        SelectQueryBuilder query = new SelectQueryBuilder();
        SerializedProject project = this.projectsDAO.getMandatory(recipe.projectKey);
        if (DatasetInspector.isHiveQuery(inputDS)) {
            virtualName = "${tbl:" + firstInputRef + "}";
            query.from(new QueryAst.TableVariableReference(virtualName, "This variable contains the query dataset " + firstInputRef + " as if it were a standalone table."));
        } else {
            switch (project.settings.relocationSettings.sqlLikeRecipesInitializationMode) {
                case DATASET_REFERENCES: {
                    virtualName = "${tbl:" + firstInputRef + "}";
                    query.from(new QueryAst.TableVariableReference(virtualName, "This variable contains the table name for input dataset " + firstInputRef));
                    break;
                }
                case VARIABILIZED_TABLE_REFERENCES: {
                    if (!recipe.projectKey.equals(inputSD.getProjectKey())) {
                        virtualName = "${tbl:" + firstInputRef + "}";
                        query.from(new QueryAst.TableVariableReference(virtualName, "This variable contains the table name for input dataset " + firstInputRef));
                        break;
                    }
                    SQLUtils.SQLTable sqlTable = DatasetUtils.getUnresolvedTable(inputSD, (SQLDialect)dialect, true, false);
                    if (newlyCreatedRecipeParams.executionEngine == HiveRecipeMeta.HiveExecutionEngine.HIVECLI_LOCAL && hiveSettings.overrideDatabaseInLocalMetastore) {
                        sqlTable = new SQLUtils.SQLTable(null, null, sqlTable.getTable(), false);
                    }
                    query.from(sqlTable, null);
                    break;
                }
                case RESOLVED_TABLE_REFERENCES: {
                    SQLUtils.SQLTable sqlTable = DatasetUtils.getResolvedTable(inputSD, (SQLDialect)dialect, true, false);
                    if (newlyCreatedRecipeParams.executionEngine == HiveRecipeMeta.HiveExecutionEngine.HIVECLI_LOCAL && hiveSettings.overrideDatabaseInLocalMetastore) {
                        sqlTable = new SQLUtils.SQLTable(null, null, sqlTable.getTable(), false);
                    }
                    query.from(sqlTable, null);
                    break;
                }
            }
        }
        if (inputDS.getPartitioningSchema() != null && inputDS.getPartitioningSchema().isPartitioned()) {
            Set partitioningColumns = inputDS.getPartitioningSchema().getDimensionNamesSet();
            for (SchemaColumn column : inputDS.getSchema().getColumns()) {
                if (partitioningColumns.contains(column.getName())) continue;
                query.select(column.getName());
            }
        }
        Object payload = query.toSQL(dialect);
        PartitioningScheme partitioning = inputDS.getPartitioningSchema();
        if (partitioning != null && partitioning.getDimensionNames().size() > 0) {
            payload = (String)payload + "\nWHERE ${DKU_PARTITION_FILTER_" + inputDS.getName() + "}";
        }
        return payload;
    }

    @Override
    public RecipeCreator.CreationResult copy_NT(String projectKey, SerializedRecipe.SerializedRecipeAndPayload source, JsonObject copyData) throws Exception {
        Preconditions.checkArgument((boolean)this.meta.getRecipeDesc().copiable, (Object)(this.meta.getType() + " recipes cannot be copied"));
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            SerializedRecipe copy = this.copyCore((String)projectKey, (SerializedRecipe)source.recipe, (String)source.payload, (JsonObject)copyData).recipe;
            RecipeCreator.CreationResult ret = new RecipeCreator.CreationResult();
            ret.messages.mergeFrom(this.fillEmptySchemasInOutput(copy, source.recipe));
            this.recipeSaveService.create(projectKey, copy, source.payload);
            t.commitV("Created %s recipe %s", new Object[]{copy.type, copy.name});
            RecipeCreator.CreationResult creationResult = ret.withId(copy.name);
            return creationResult;
        }
    }

    private InfoMessage.InfoMessages fillEmptySchemasInOutput(SerializedRecipe copy, SerializedRecipe source) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        List<SerializedRecipe.RecipeOutput> newOutputs = copy.getOutputsForRole("main");
        List<SerializedRecipe.RecipeOutput> oldOutputs = source.getOutputsForRole("main");
        for (int i = 0; i < newOutputs.size(); ++i) {
            AnyLoc oldLoc;
            Dataset oldDataset;
            SerializedRecipe.RecipeOutput newOutput = newOutputs.get(i);
            SerializedRecipe.RecipeOutput oldOutput = oldOutputs.get(i);
            AnyLoc newLoc = AnyLoc.resolveSmart(copy.projectKey, newOutput.ref);
            Dataset newDataset = this.datasetAccessService.getMandatory(newLoc);
            if (newDataset.getSchema().getColumns().size() != 0 || (oldDataset = this.datasetAccessService.getMandatory(oldLoc = AnyLoc.resolveSmart(source.projectKey, oldOutput.ref))).getSchema().getColumns().size() <= 0) continue;
            newDataset.setSchema(new Schema(oldDataset.getSchema()));
            logger.info((Object)("Setting schema on dataset " + newDataset.getFullName()));
            ret.mergeFrom(this.datasetSaveService.save((String)newDataset.getProjectKey(), (String)newDataset.getName(), (SerializedDataset)newDataset.serialize(), (AuthCtx)this.authCtx).messages);
        }
        return ret;
    }
}

