/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.spark;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.hproxy.utils.HiveEMRUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkConfigEnricher {
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.spark");

    public SparkConfigEnricher() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void setMetastoreConfKeysInAdditionalSparkConf(SparkExecutionConfig sec, SparkJobExecEnv def) throws IOException, DKUSecurityException {
        for (SimpleKeyValue kv : this.getMetastoreConfKeys()) {
            if (sec.hasConfKey(kv.key)) {
                logger.info((Object)("Key " + kv.key + " already set by the conf, not overriding"));
                continue;
            }
            def.additionalSparkConf.add(new AbstractSQLConnection.CustomDatabaseProperty(kv.key, kv.value, false));
        }
    }

    public void setMetastoreConfKeysInKeys(List<SimpleKeyValue> sparkConfKeys) throws IOException, DKUSecurityException {
        for (SimpleKeyValue kv : this.getMetastoreConfKeys()) {
            boolean hasItAlready = false;
            for (SimpleKeyValue skv : sparkConfKeys) {
                if (!skv.key.equals(kv.key)) continue;
                hasItAlready = true;
                break;
            }
            if (hasItAlready) {
                logger.info((Object)("Key " + kv.key + " already set by the conf, not overriding"));
                continue;
            }
            sparkConfKeys.add(new SimpleKeyValue(kv.key, kv.value));
        }
    }

    public void setMetastoreConfKeysInKeys(SparkExecutionConfig sec) throws IOException, DKUSecurityException {
        for (SimpleKeyValue kv : this.getMetastoreConfKeys()) {
            if (sec.hasConfKey(kv.key)) {
                logger.info((Object)("Key " + kv.key + " already set by the conf, not overriding"));
                continue;
            }
            sec.conf.add(new ClusterProperty(kv.key, kv.value));
        }
    }

    public static String[] metastoreClientFactoryClassVariants() {
        return HiveEMRUtils.metastoreClientFactoryClassVariants();
    }

    private List<SimpleKeyValue> getMetastoreConfKeys() throws IOException, DKUSecurityException {
        GeneralSettingsDAO.MetastoreCatalogsSettings metastoreCatalogsSettings = this.generalSettingsDAO.getUnsafeAutoTXN().metastoreCatalogsSettings;
        ArrayList toAdd = Lists.newArrayList();
        if (metastoreCatalogsSettings.synchronizeTo.flavor == GeneralSettingsDAO.MetastoreCatalogsSettings.MetastoreCatalogFlavor.AWS_GLUE) {
            for (String c2 : SparkConfigEnricher.metastoreClientFactoryClassVariants()) {
                toAdd.add(new SimpleKeyValue("spark.hadoop." + c2, "com.amazonaws.glue.catalog.metastore.AWSGlueDataCatalogHiveClientFactory"));
            }
        } else if (metastoreCatalogsSettings.synchronizeTo.flavor == GeneralSettingsDAO.MetastoreCatalogsSettings.MetastoreCatalogFlavor.DSS_INTERNAL) {
            for (String c2 : SparkConfigEnricher.metastoreClientFactoryClassVariants()) {
                toAdd.add(new SimpleKeyValue("spark.hadoop." + c2, "com.dataiku.hive.metastore.DSSCatalogHiveMetaStoreClientFactory"));
            }
        }
        boolean couldNeedMetastoreJars = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9);
        couldNeedMetastoreJars = ApplicationConfigurator.getParams().getBoolParam("dku.spark.usesJava9OrMore", couldNeedMetastoreJars);
        if (couldNeedMetastoreJars) {
            String sparkHomeFolder = System.getenv("DKU_SPARK_HOME");
            if (StringUtils.isNotBlank((String)sparkHomeFolder)) {
                File jarsFolder = new File(sparkHomeFolder, "jars");
                if (jarsFolder.exists() && jarsFolder.isDirectory()) {
                    ArrayList jars = Lists.newArrayList();
                    jars.add(String.format("%s/*", jarsFolder.getAbsoluteFile()));
                    File distFolder = ApplicationConfigurator.getInstallFile((String[])new String[]{"dist"});
                    for (String n : SparkJobHelper.JARS_TO_SEND_TO_SPARK) {
                        jars.add(new File(distFolder, n).getAbsolutePath());
                    }
                    String scalaVersion = SparkJobHelper.getScalaVersion(null);
                    for (String n : ImmutableList.of((Object)"dss-spark-public", (Object)"dss-spark-main")) {
                        jars.add(SparkJobHelper.getSparkJar(scalaVersion, n).getAbsolutePath());
                    }
                    File shadelibFolder = ApplicationConfigurator.getInstallFile((String[])new String[]{"lib", "shadelib"});
                    jars.add(String.format("%s/*", shadelibFolder.getAbsoluteFile()));
                    toAdd.add(new SimpleKeyValue("spark.sql.hive.metastore.jars", jars.stream().collect(Collectors.joining(File.pathSeparator))));
                } else {
                    logger.info((Object)"Could not find spark jars");
                }
            } else {
                logger.info((Object)"No DKU_SPARK_HOME variables, spark integration probably incomplete");
            }
        }
        return toAdd;
    }
}

