/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.common;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.exec.distinct.DistinctRecipeMeta;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipeMeta;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeMeta;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeMeta;
import com.dataiku.dip.dataflow.exec.r.RRecipeMeta;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeMeta;
import com.dataiku.dip.dataflow.exec.sort.SortRecipeMeta;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeMeta;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.dataflow.exec.sql.SQLScriptRecipeMeta;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeMeta;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeMeta;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeMeta;
import com.dataiku.dip.dataflow.exec.window.WindowRecipeMeta;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.managedfolder.FilesBasedManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.NoParams;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.code.julia.JuliaRecipeMeta;
import com.dataiku.dip.recipes.code.python.PythonRecipeMeta;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeMeta;
import com.dataiku.dip.recipes.code.shell.ShellScriptRecipeMeta;
import com.dataiku.dip.recipes.code.spark.PySparkRecipeMeta;
import com.dataiku.dip.recipes.code.spark.SparkRRecipeMeta;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.consistency.BasicRecipeConsistencyChecker;
import com.dataiku.dip.recipes.export.ExportRecipeMeta;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.recipes.shaker.ShakerRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetRenameService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class GenericRecipeCreator
implements RecipeCreator {
    public static final List<String> SUPPORTED_INSERT_RECIPE_TYPES = ImmutableList.of((Object)SamplingRecipeMeta.META.getType(), (Object)ShakerRecipeMeta.META.getType(), (Object)ExportRecipeMeta.META.getType(), (Object)WindowRecipeMeta.META.getType(), (Object)SyncRecipeMeta.META.getType(), (Object)DistinctRecipeMeta.META.getType(), (Object)TopNRecipeMeta.META.getType(), (Object)SortRecipeMeta.META.getType(), (Object)SplitRecipeMeta.META.getType(), (Object)JoinRecipeMeta.META.getType(), (Object)FuzzyJoinRecipeMeta.META.getType(), (Object)GeoJoinRecipeMeta.META.getType(), (Object[])new String[]{VStackRecipeMeta.META.getType(), PythonRecipeMeta.META.getType(), RRecipeMeta.META.getType(), JuliaRecipeMeta.META.getType(), ShellScriptRecipeMeta.META.getType(), SQLQueryRecipeMeta.META.getType(), SQLScriptRecipeMeta.META.getType(), PySparkRecipeMeta.META.getType(), SparkSQLQueryRecipeMeta.META.getType(), SparkRRecipeMeta.META.getType(), SparkScalaRecipeMeta.META.getType()});
    @Autowired
    protected DatasetAccessService datasetAccessService;
    @Autowired
    protected StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    protected StreamingEndpointService streamingEndpointService;
    @Autowired
    protected DatasetSaveService datasetSaveService;
    @Autowired
    protected ManagedDatasetsCreationService mdcService;
    @Autowired
    protected RecipeSaveService recipeSaveService;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected GenericRecipesValidationService recipesValidationService;
    @Autowired
    protected FlowGraphService flowGraphService;
    @Autowired
    protected FlowZonesService flowZonesService;
    @Autowired
    protected ManagedFolderDAO managedFolderDAO;
    @Autowired
    protected RecipesDAO recipesDAO;
    @Autowired
    protected DatasetRenameService datasetRenameService;
    protected final AuthCtx authCtx;
    protected final RecipeMeta meta;
    protected final boolean allowPreFilledParams;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.creator");

    public GenericRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        this(authCtx, meta, false);
    }

    public GenericRecipeCreator(AuthCtx authCtx, RecipeMeta meta, boolean allowPreFilledParams) {
        this.authCtx = authCtx;
        this.meta = meta;
        this.allowPreFilledParams = allowPreFilledParams;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public RecipeCreator.CreationResult create_NT(SerializedRecipe sr, JsonObject creationData) throws Exception {
        assert (StringUtils.isNotBlank((String)sr.projectKey));
        assert (this.meta.getType().equals(sr.type));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)sr.name), (Object)"Recipe has no name");
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            logger.info((Object)("Create recipe of type: " + sr.type));
            sr.name = this.recipeSaveService.transmogrifyName(sr.projectKey, sr.name);
            try {
                sr.params = this.makeInitialParams(sr, creationData);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to initialize " + this.meta.getType() + " recipe params"), (Throwable)e);
            }
            String payload = null;
            try {
                payload = this.makeInitialPayload(sr, creationData);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to initialize " + this.meta.getType() + " recipe payload"), (Throwable)e);
            }
            this.checkOutputOwnership_T(sr);
            new PDepsFixuper().fixupInPlace(sr);
            this.assignZone(sr, creationData.has("zone") ? creationData.get("zone").getAsString() : null);
            SerializedRecipe savedRecipe = this.recipeSaveService.create(sr.projectKey, sr, payload);
            savedRecipe.name = sr.name;
            this.updateOriginRecipes(savedRecipe, creationData);
            t.commitV("Created %s recipe: %s", new Object[]{sr.type, sr.getFullId()});
            RecipeCreator.CreationResult creationResult = new RecipeCreator.CreationResult().withId(savedRecipe.name);
            return creationResult;
        }
    }

    protected void updateOriginRecipes(SerializedRecipe serializedRecipe, JsonObject creationData) throws IOException, DKUSecurityException, CodedException {
        if (!creationData.has("originRecipes") || creationData.get("originRecipes") == null || !creationData.has("originDataset") || creationData.get("originDataset") == null) {
            return;
        }
        if (!this.insertRecipeEnabled()) {
            throw ErrorContext.iaef((String)"Cannot insert a recipe of the given recipe type %s", (Object)this.meta.getType(), (Object[])new Object[0]);
        }
        List originRecipeIds = (List)JSON.parse((JsonElement)creationData.get("originRecipes"), (TypeToken)new TypeToken<List<String>>(){});
        String originDatasetId = creationData.get("originDataset").getAsString();
        DatasetLocUtils.DatasetLoc newDatasetLoc = serializedRecipe.getFlatOutputs().get(0).getLoc(serializedRecipe.projectKey).toDatasetLoc();
        for (String originRecipeId : originRecipeIds) {
            SerializedRecipe originRecipe = (SerializedRecipe)this.recipesDAO.getMandatory(serializedRecipe.projectKey, originRecipeId);
            Optional<SerializedRecipe.RecipeInput> originRecipeInput = originRecipe.getFlatInputs().stream().filter(input -> input.ref.equals(originDatasetId)).findFirst();
            if (originRecipeInput.isEmpty()) {
                throw ErrorContext.iaef((String)"Dataset %s is not an input of the downstream recipe %s", (Object)originDatasetId, (Object[])new Object[]{originRecipeId});
            }
            DatasetLocUtils.DatasetLoc oldDatasetLoc = originRecipeInput.get().getLoc(serializedRecipe.projectKey).toDatasetLoc();
            TaggableObjectsDeletionService.ImpactedRecipe impactedRecipe = new TaggableObjectsDeletionService.ImpactedRecipe(serializedRecipe.projectKey, originRecipe.name, originRecipe.type);
            this.datasetRenameService.performRenamingForRecipe(oldDatasetLoc, newDatasetLoc, this.authCtx, impactedRecipe);
            this.datasetRenameService.performRenamingForManualLineage(oldDatasetLoc, newDatasetLoc, impactedRecipe);
        }
    }

    public boolean insertRecipeEnabled() {
        return SUPPORTED_INSERT_RECIPE_TYPES.contains(this.meta.getType());
    }

    public void assignZone(SerializedRecipe sr, String recipeZone) throws IOException {
        if (StringUtils.isNotBlank((String)recipeZone)) {
            this.flowZonesService.attachObjectToZone(recipeZone, sr.projectKey, sr);
        } else {
            recipeZone = this.flowZonesService.retrieveInputZone(sr);
            this.flowZonesService.attachObjectToZone(recipeZone, sr.projectKey, sr);
            List<SerializedRecipe.RecipeOutput> outputs = sr.getOutputsForRole("main");
            if (sr.type.startsWith("CustomCode_") && outputs.size() == 0) {
                outputs = sr.getFlatOutputs();
            }
            for (SerializedRecipe.RecipeOutput output : outputs) {
                String foundZone;
                TaggableObjectsService.TaggableObject outputTo = this.getOutputTaggableObject(output.getLoc(sr.projectKey));
                if (outputTo == null || (foundZone = this.flowZonesService.retrieveZone(sr.projectKey, outputTo)) != null && (Objects.equals(foundZone, recipeZone) || !Objects.equals(foundZone, Zone.DEFAULT_ZONE.getId()))) continue;
                this.flowZonesService.attachObjectToZone(recipeZone, sr.projectKey, outputTo);
            }
        }
    }

    private TaggableObjectsService.TaggableObject getOutputTaggableObject(AnyLoc loc) throws IOException {
        Dataset dataset;
        TaggableObjectsService.TaggableObject to = null;
        if (FilesBasedManagedFolderDAO.looksLikeAManagedFolderId(loc.getId())) {
            to = (TaggableObjectsService.TaggableObject)this.managedFolderDAO.getOrNull(loc);
        }
        if (to == null) {
            to = (TaggableObjectsService.TaggableObject)this.streamingEndpointsDAO.getOrNull(loc);
        }
        if (to == null && (dataset = this.datasetAccessService.getOrNull(loc)) != null) {
            to = dataset.getModel();
        }
        return to;
    }

    @Override
    public RecipeCreator.CreationResult copy_NT(String projectKey, SerializedRecipe.SerializedRecipeAndPayload source, JsonObject copyData) throws Exception {
        Preconditions.checkArgument((boolean)this.meta.getRecipeDesc().copiable, (Object)(this.meta.getType() + " recipes cannot be copied"));
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            SerializedRecipe.SerializedRecipeAndPayload copy = this.copyCore(projectKey, source.recipe, source.payload, copyData);
            this.recipeSaveService.create(projectKey, copy.recipe, copy.payload);
            t.commitV("Created %s recipe %s", new Object[]{copy.recipe.type, copy.recipe.name});
            RecipeCreator.CreationResult creationResult = new RecipeCreator.CreationResult().withId(copy.recipe.name);
            return creationResult;
        }
    }

    @Override
    public void checkReplacements(SerializedRecipe recipe, RecipeCreator.CopySettings settings) throws Exception {
        Map<String, SerializedRecipe.InputRole> inputs = recipe.getInputsUnsafe();
        Map<String, SerializedRecipe.OutputRole> outputs = recipe.getOutputsUnsafe();
        Preconditions.checkArgument((outputs != null ? 1 : 0) != 0, (Object)"Empty outputs");
        assert (outputs != null);
        if (inputs != null && !inputs.isEmpty()) {
            Preconditions.checkArgument((settings.inputs != null ? 1 : 0) != 0, (Object)"Empty replacement inputs");
            for (String role : inputs.keySet()) {
                if (inputs.get(role) == null || settings.inputs.get(role) == null) {
                    throw ErrorContext.iaef((String)"Input role '%s' is not specified", (Object)role, (Object[])new Object[0]);
                }
                List<SerializedRecipe.RecipeInput> oldRoleInputs = inputs.get((Object)role).items;
                List<SerializedRecipe.RecipeInput> newRoleInputs = settings.inputs.get((Object)role).items;
                if (newRoleInputs.size() == oldRoleInputs.size()) continue;
                throw ErrorContext.iaef((String)"Each input should have a replacement: had %s inputs, got %s replacements", (Object)oldRoleInputs.size(), (Object[])new Object[]{newRoleInputs.size()});
            }
        }
        for (String role : outputs.keySet()) {
            List<SerializedRecipe.RecipeOutput> oldRoleOutputs = outputs.get((Object)role).items;
            List<SerializedRecipe.RecipeOutput> newRoleOutputs = settings.outputs.get((Object)role).items;
            if (newRoleOutputs.size() == oldRoleOutputs.size()) continue;
            throw ErrorContext.iaef((String)"Each output should have a replacement: had %s inputs, got %s replacements", (Object)oldRoleOutputs.size(), (Object[])new Object[]{newRoleOutputs.size()});
        }
    }

    public void checkOutputOwnership_NT(SerializedRecipe recipe) throws Exception {
        this.checkOutputOwnership(recipe, new ProjectGraphProvider(){

            @Override
            public FlowGraph getProjectGraph(String projectKey, boolean drawZones) throws IOException {
                try (Transaction t = GenericRecipeCreator.this.transactionService.beginRead();){
                    ProjectFlowGraph projectFlowGraph = GenericRecipeCreator.this.flowGraphService.getProjectGraph(projectKey, drawZones);
                    return projectFlowGraph;
                }
            }
        });
    }

    public void checkOutputOwnership_T(SerializedRecipe recipe) throws Exception {
        this.checkOutputOwnership(recipe, new ProjectGraphProvider(){

            @Override
            public FlowGraph getProjectGraph(String projectKey, boolean drawZones) throws IOException {
                return GenericRecipeCreator.this.flowGraphService.getProjectGraph(projectKey, drawZones);
            }
        });
    }

    private void checkOutputOwnership(SerializedRecipe recipe, ProjectGraphProvider projectGraphProvider) throws Exception {
        FlowGraph projectGraph = this.flowGraphService.getCachedProjectGraph(recipe.getProjectKey(), true);
        if (projectGraph == null) {
            projectGraph = projectGraphProvider.getProjectGraph(recipe.getProjectKey(), true);
        }
        for (SerializedRecipe.RecipeOutput output : recipe.getFlatOutputs()) {
            AnyLoc outputLoc = output.getLoc(recipe.getProjectKey());
            FlowComputable flowComputable = projectGraph.getComputable(outputLoc.getFullName());
            if (flowComputable == null) {
                logger.warn((Object)("Output " + outputLoc.getFullName() + " should have been created, skipping check"));
                continue;
            }
            for (GraphNode graphNode : flowComputable.getPredecessors()) {
                AnyLoc ancestorLoc = AnyLoc.resolveFull(graphNode.getFullId());
                if (projectGraph.getRecipe(ancestorLoc.getProjectKey(), ancestorLoc.getId()) == null) continue;
                throw ErrorContext.iaef((String)"Output %s is already used by %s", (Object)outputLoc.getFullName(), (Object[])new Object[]{ancestorLoc.getFullName()});
            }
        }
    }

    protected RecipeParams makeInitialParams(SerializedRecipe sr, JsonObject creationData) throws Exception {
        if (this.allowPreFilledParams && sr.params != null) {
            return sr.params;
        }
        if (this.meta.paramsClass() != NoParams.class) {
            return this.meta.paramsClass().newInstance();
        }
        return null;
    }

    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data) throws Exception {
        return null;
    }

    protected SerializedRecipe.SerializedRecipeAndPayload copyCore(String projectKey, SerializedRecipe recipe, String payload, JsonObject copyData) throws Exception {
        RecipeCreator.CopySettings settings = (RecipeCreator.CopySettings)JSON.parse((JsonElement)copyData, RecipeCreator.CopySettings.class);
        SerializedRecipe copy = (SerializedRecipe)JSON.deepCopy((Object)recipe);
        this.checkReplacements(copy, settings);
        Map<String, SerializedRecipe.InputRole> recipeInputs = copy.getInputsUnsafe();
        HashSet<String> usedInputRefs = new HashSet<String>();
        for (String role : recipeInputs.keySet()) {
            ArrayList<SerializedRecipe.RecipeInput> newInputs = new ArrayList<SerializedRecipe.RecipeInput>();
            List<SerializedRecipe.RecipeInput> roleReplacements = settings.inputs.get((Object)role).items;
            for (int i = 0; i < roleReplacements.size(); ++i) {
                AnyLoc loc = AnyLoc.resolveSmart(projectKey, roleReplacements.get((int)i).ref);
                String ref = loc.getSmartName(projectKey);
                if (usedInputRefs.contains(ref)) continue;
                SerializedRecipe.RecipeInput prevInput = recipeInputs.get((Object)role).items.get(i);
                SerializedRecipe.RecipeInput input = (SerializedRecipe.RecipeInput)JSON.deepCopy((Object)recipeInputs.get((Object)role).items.get(i));
                input.ref = ref;
                newInputs.add(input);
                usedInputRefs.add(ref);
                DatasetLocUtils.DatasetLoc prevInputDatasetLoc = prevInput.getLoc(projectKey).toDatasetLoc();
                payload = DatasetRenameService.updateDatasetInRecipePayload(copy, projectKey, payload, prevInputDatasetLoc, loc.toDatasetLoc(), true, this.authCtx);
                DatasetRenameService.updateDatasetReferencesInRecipeParams(copy, prevInputDatasetLoc.getSmartName(projectKey), ref);
            }
            recipeInputs.get((Object)role).items = newInputs;
        }
        HashMap<String, String> outputReplacementNames = new HashMap<String, String>();
        Map<String, SerializedRecipe.OutputRole> recipeOutputs = copy.getOutputsUnsafe();
        HashSet<String> usedOutputRefs = new HashSet<String>();
        for (String role : recipeOutputs.keySet()) {
            ArrayList<SerializedRecipe.RecipeOutput> newOutputs = new ArrayList<SerializedRecipe.RecipeOutput>();
            List<SerializedRecipe.RecipeOutput> roleReplacements = settings.outputs.get((Object)role).items;
            for (int i = 0; i < roleReplacements.size(); ++i) {
                AnyLoc loc = roleReplacements.get(i).getLoc(projectKey);
                String ref = loc.getSmartName(projectKey);
                if (usedOutputRefs.contains(ref)) continue;
                SerializedRecipe.RecipeOutput prevOutput = recipeOutputs.get((Object)role).items.get(i);
                SerializedRecipe.RecipeOutput output = (SerializedRecipe.RecipeOutput)JSON.deepCopy((Object)prevOutput);
                output.ref = ref;
                outputReplacementNames.put(prevOutput.getLoc(projectKey).getId(), loc.getId());
                newOutputs.add(output);
                usedOutputRefs.add(ref);
                DatasetLocUtils.DatasetLoc prevOutoutDatasetLoc = prevOutput.getLoc(projectKey).toDatasetLoc();
                payload = DatasetRenameService.updateDatasetInRecipePayload(copy, projectKey, payload, prevOutoutDatasetLoc, loc.toDatasetLoc(), false, this.authCtx);
                DatasetRenameService.updateDatasetReferencesInRecipeParams(copy, prevOutoutDatasetLoc.getSmartName(projectKey), ref);
            }
            recipeOutputs.get((Object)role).items = newOutputs;
        }
        copy.projectKey = projectKey;
        copy.name = this.recipeSaveService.smartRename(projectKey, recipe.name, outputReplacementNames);
        new PDepsFixuper().handleRecipeCopy(recipe, copy);
        this.flowZonesService.attachObjectToZone(settings.zone, projectKey, copy, true);
        return new SerializedRecipe.SerializedRecipeAndPayload(copy, payload);
    }

    @Override
    public GenericRecipesValidationService.RecipeValidationResult testCopy(SerializedRecipe recipe, String payload, RecipeCreator.CopySettings copySettings) throws Exception {
        return this.testIOreplacement(recipe, payload, copySettings.inputs, copySettings.outputs);
    }

    public GenericRecipesValidationService.RecipeValidationResult testIOreplacement(SerializedRecipe recipe, String payload, Map<String, SerializedRecipe.InputRole> newInputs, Map<String, SerializedRecipe.OutputRole> newOutputs) throws Exception {
        try {
            SerializedRecipe copy = (SerializedRecipe)JSON.deepCopy((Object)recipe);
            GenericRecipesValidationService.RecipeValidationResult res = new GenericRecipesValidationService.RecipeValidationResult();
            new BasicRecipeConsistencyChecker(copy).check(res);
            return res;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to test io replacement", (Throwable)e);
            return null;
        }
    }

    private static interface ProjectGraphProvider {
        public FlowGraph getProjectGraph(String var1, boolean var2) throws IOException;
    }

    public static class CreationSettings {
        public String name;
        public String type;
    }
}

