/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.common;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.containers.exec.ContainerExecCodes;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.consistency.BasicRecipeConsistencyChecker;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.consistency.MiscStuffChecker;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.IOException;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class RecipeStatusComputer {
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected DatasetAccessService datasetAccessService;
    @Autowired
    protected GenericRecipesValidationService recipesValidationService;
    @Autowired
    protected CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    protected final SerializedRecipe recipe;
    protected final String payload;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.recipe.status.computer");

    public RecipeStatusComputer(SerializedRecipe recipe, String payload) {
        this.recipe = recipe;
        this.payload = payload;
        SpringUtils.getInstance().autowire((Object)this);
    }

    protected void performBasicStructureChecks(RecipeStatus status, @Nullable AuthCtx authCtx) throws IOException, DKUSecurityException {
        new BasicRecipeConsistencyChecker(this.recipe).check(status.topLevelMessages);
        if (authCtx != null) {
            new MiscStuffChecker(this.recipe).check(status.topLevelMessages, authCtx, this.recipe.projectKey);
        }
        try {
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
        }
        catch (Exception e) {
            status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, ExceptionUtils.getMessageWithCauses((Throwable)e), new Object[0]);
        }
    }

    protected ContainerExecSelection getContainerExecSelectionForCDE() {
        RecipeMeta meta = RecipeRegistry.getMeta(this.recipe);
        if (meta.getCategoryFlags().isVisualRecipe) {
            return meta.getContainerExecSelection(this.recipe, this.payload);
        }
        return null;
    }

    protected void performBasicCDEChecks(RecipeStatus status, @Nullable AuthCtx authCtx) throws IOException, DKUSecurityException {
        for (RecipeEngineStatus engineStatus : status.engines) {
            if (!"DSS".equals(engineStatus.type)) continue;
            this.performBasicCDEChecks(engineStatus, authCtx);
            return;
        }
    }

    protected void performBasicCDEChecks(RecipeEngineStatus status, @Nullable AuthCtx authCtx) throws IOException, DKUSecurityException {
        if (authCtx == null) {
            return;
        }
        if (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.CDE) {
            return;
        }
        this.cdeCompatibilityCheckerService.checkRecipeEngineStatus(authCtx, this.recipe, this.payload, status, this.getContainerExecSelectionForCDE());
    }

    protected void checkContainerConfiguration(AuthCtx authCtx, RecipeStatus status, ParamsWithContainerizable params, @Nullable RecipeEngineStatus engineStatus) throws IOException, DKUSecurityException {
        if (params == null) {
            return;
        }
        try {
            new ContainerExecConfigSelector().selectForRecipeStatus_autoTXN(authCtx, this.recipe.projectKey, params.getContainerSelection(), engineStatus);
        }
        catch (IllegalArgumentException e) {
            status.topLevelMessages.withFatal((InfoMessage.MessageCode)ContainerExecCodes.ERR_CONTAINER_CONF_NOT_FOUND, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        catch (UnauthorizedException e) {
            status.topLevelMessages.withFatal((InfoMessage.MessageCode)ContainerExecCodes.ERR_CONTAINER_CONF_NO_USAGE_PERMISSION, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        catch (ContainerExecConfigSelector.ContainerConfigurationWorkloadTypeException e) {
            status.topLevelMessages.withFatal((InfoMessage.MessageCode)ContainerExecCodes.ERR_CONTAINER_CONF_WRONG_WORKLOAD_TYPE, ExceptionUtils.getMessageWithCauses((Throwable)((Object)e)));
        }
    }

    public abstract RecipeStatus getFullStatus_NT(AuthCtx var1, String var2) throws Exception;

    public abstract RecipeStatus fastStatusIgnorePartitions(AuthCtx var1) throws Exception;
}

