/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.consistency;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.MLFlowUtils;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesMeta;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesMeta;
import com.dataiku.dip.analysis.ml.prediction.flow.StandaloneEvaluationRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.TabularPredictionScoringRecipePayloadParams;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.RedshiftConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.distinct.DistinctRecipeMeta;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipeMeta;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeMeta;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeMeta;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeMeta;
import com.dataiku.dip.dataflow.exec.sort.SortRecipeMeta;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeMeta;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.dataflow.exec.sql.SQLScriptRecipeMeta;
import com.dataiku.dip.dataflow.exec.sync.S3ToRedshift;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeMeta;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeParams;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeMeta;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipeMeta;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeMeta;
import com.dataiku.dip.dataflow.exec.window.WindowRecipeMeta;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.delta.DeltaFormat;
import com.dataiku.dip.hadoop.HadoopFlavorUtils;
import com.dataiku.dip.input.formats.JSONFormatConfig;
import com.dataiku.dip.input.formats.JSONFormatExtractor;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeMeta;
import com.dataiku.dip.recipes.code.spark.PySparkRecipeMeta;
import com.dataiku.dip.recipes.code.spark.SparkRRecipeMeta;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.shaker.ShakerRecipeMeta;
import com.dataiku.dip.recipes.shaker.ShakerRecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.shaker.mrimpl.formats.UniversalFileOutputFormat;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class MiscStuffChecker {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetsAccesService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private ComputableFromRefService cfrService;
    private static final List<String> SQL_BASED_RECIPE_META_TYPES = Arrays.asList(SplitRecipeMeta.META.getType(), GroupingRecipeMeta.META.getType(), DistinctRecipeMeta.META.getType(), TopNRecipeMeta.META.getType(), SortRecipeMeta.META.getType(), PivotRecipeMeta.META.getType(), WindowRecipeMeta.META.getType(), VStackRecipeMeta.META.getType(), JoinRecipeMeta.META.getType(), UpsertRecipeMeta.META.getType());
    private static final String ENGINE_TYPE_SPARK = "SPARK";
    private final SerializedRecipe sr;

    public MiscStuffChecker(SerializedRecipe sr) {
        this.sr = sr;
        SpringUtils.getInstance().autowire((Object)this);
    }

    private void checkS3ToRedshift(InfoMessage.InfoMessages messages) throws IOException {
        FlowComputable target;
        RecipeMeta meta = RecipeRegistry.getMeta(this.sr.type);
        boolean isCandidate = false;
        if (this.sr.getFlatOutputs().size() == 1 && (target = this.cfrService.get(this.sr.projectKey, this.sr.getFlatOutputs().get((int)0).ref)) instanceof FlowDataset) {
            DSSConnection conn;
            String connectionName;
            SerializedDataset sd = ((FlowDataset)target).getSerializedMandatoryUnsafe(this.datasetsDAO);
            if (BuiltinSQLDatasets.REDSHIFT_META.getType().equals(sd.type) && StringUtils.isNotBlank((String)(connectionName = sd.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getConnection())) && (conn = ConnectionsDAO.get().listUnsafe().get(connectionName)) != null && conn instanceof RedshiftConnection && !((RedshiftConnection)conn).params.useAutoFastPath) {
                isCandidate = true;
            }
        }
        if (isCandidate) {
            if (SyncRecipeMeta.META.getType().equals(this.sr.type)) {
                DatasetLocUtils.DatasetLoc sourceLoc = DatasetLocUtils.resolveSmart(this.sr.projectKey, this.sr.getSingleInput((String)"main").ref);
                Dataset sourceDS = this.datasetsAccesService.getMandatory(sourceLoc);
                DatasetLocUtils.DatasetLoc targetLoc = DatasetLocUtils.resolveSmart(this.sr.projectKey, this.sr.getSingleOutput((String)"main").ref);
                Dataset targetDS = this.datasetsAccesService.getMandatory(targetLoc);
                RecipeEngineStatus probe = new RecipeEngineStatus();
                S3ToRedshift.setCompatible(sourceDS, targetDS, probe);
                if (probe.isSelectable) {
                    return;
                }
                messages.withWarning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_SLOW_SYNC_TO_REDSHIFT, "Sync to Redshift does not use S3 fast-path: " + probe.statusMessage);
                return;
            }
            if (SQLQueryRecipeMeta.META.getType().equals(this.sr.type) || SQLScriptRecipeMeta.META.getType().equals(this.sr.type) || meta.getCategoryFlags().isVisualSQL) {
                return;
            }
            if (ShakerRecipeMeta.META.getType().equals(this.sr.type) || meta.getCategoryFlags().isSpark) {
                messages.withWarning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_SLOW_WRITE_TO_REDSHIFT, "Write to Redshift should use S3 fast-path");
                return;
            }
            messages.withInfo((InfoMessage.MessageCode)RecipeCodes.INFO_RECIPE_POSSIBLY_SLOW_WRITE_TO_REDSHIFT, "Write to Redshift may not be using S3 fast-path");
        }
    }

    private void checkSparkToIndirectHDFS(InfoMessage.InfoMessages messages, AuthCtx authCtx) throws IOException, DKUSecurityException {
        DatasetLocUtils.DatasetLoc targetLoc;
        FlowComputable target;
        RecipeMeta meta = RecipeRegistry.getMeta(this.sr.type);
        boolean isSpark = meta.getCategoryFlags().isSpark;
        if (!isSpark) {
            String payload = this.recipesDAO.getPayloadOrNull(this.sr.projectKey, this.sr.name);
            if (this.sr.type.equals(ShakerRecipeMeta.META.getType())) {
                isSpark = this.sr.params != null && this.isSpark(((ShakerRecipeParams)this.sr.params).engineType);
            } else if (this.sr.type.equals(SyncRecipeMeta.META.getType())) {
                isSpark = this.sr.params != null && this.isSpark(((SyncRecipeParams)this.sr.params).engineType);
            } else if (this.sr.type.equals(SamplingRecipeMeta.META.getType())) {
                isSpark = this.sr.params != null && this.isSpark(((SamplingRecipeMeta.SamplingRecipeParams)this.sr.params).engineType);
            } else if (SQL_BASED_RECIPE_META_TYPES.contains(this.sr.type)) {
                RecipeEnginesPreferenceConfig preferenceConfig;
                VisualSQLRecipePayloadParams params = (VisualSQLRecipePayloadParams)JSON.parse((String)payload, VisualSQLRecipePayloadParams.class);
                if (params == null) {
                    return;
                }
                isSpark = StringUtils.isNotBlank((String)params.engineType) ? ENGINE_TYPE_SPARK.equals(params.engineType) : (preferenceConfig = new RecipeConfigUtils().getResolvedPreferenceConfig(this.sr.projectKey, this.sr.type, params.enginesPreferences)) != null && preferenceConfig.preferenceByRecipeType != null && preferenceConfig.preferenceByRecipeType.get(this.sr.type) != null && !preferenceConfig.preferenceByRecipeType.get(this.sr.type).isEmpty() && ENGINE_TYPE_SPARK.equals(preferenceConfig.preferenceByRecipeType.get(this.sr.type).get(0));
            } else if (this.sr.type.equals(PredictionRecipesMeta.EVALUATION_META.getType())) {
                desc = (EvaluationRecipePayloadParams)JSON.parse((String)payload, EvaluationRecipePayloadParams.class);
                isSpark = desc != null && ((EvaluationRecipePayloadParams)desc).backendType.isSparkBased();
            } else if (this.sr.type.equals(PredictionRecipesMeta.STANDALONE_EVALUATION_META.getType())) {
                desc = (StandaloneEvaluationRecipePayloadParams)JSON.parse((String)payload, StandaloneEvaluationRecipePayloadParams.class);
                isSpark = desc != null && this.isSpark(((StandaloneEvaluationRecipePayloadParams)desc).engineType);
            } else if (this.sr.type.equals(PredictionRecipesMeta.SCORING_META.getType())) {
                desc = (TabularPredictionScoringRecipePayloadParams)JSON.parse((String)payload, TabularPredictionScoringRecipePayloadParams.class);
                if (desc != null) {
                    if (ENGINE_TYPE_SPARK.equals(((TabularPredictionScoringRecipePayloadParams)desc).engineType)) {
                        isSpark = true;
                    } else if (((TabularPredictionScoringRecipePayloadParams)desc).backendType.isSparkBased()) {
                        if (((TabularPredictionScoringRecipePayloadParams)desc).forceOriginalEngine || ((TabularPredictionScoringRecipePayloadParams)desc).engineType == null) {
                            isSpark = true;
                        } else {
                            try {
                                MLFlowUtils.PredictionScoringRecipeStatusComputer statusComputer = (MLFlowUtils.PredictionScoringRecipeStatusComputer)meta.buildStatusComputer(this.sr, payload);
                                isSpark = !statusComputer.isJavaCompatible();
                            }
                            catch (Exception e) {
                                throw new IOException("Error computing recipe status for " + this.sr.name, e);
                            }
                        }
                    }
                }
            } else if (this.sr.type.equals(ClusteringRecipesMeta.SCORING_META.getType()) || this.sr.type.equals(ClusteringRecipesMeta.CLUSTER_META.getType())) {
                desc = (ClusteringTrainingRecipePayloadParams)JSON.parse((String)payload, ClusteringTrainingRecipePayloadParams.class);
                isSpark = desc != null && ((ClusteringTrainingRecipePayloadParams)desc).backendType.isSparkBased();
            } else if (this.sr.type.equals(PySparkRecipeMeta.META.getType()) || this.sr.type.equals(SparkRRecipeMeta.META.getType()) || this.sr.type.equals(SparkSQLQueryRecipeMeta.META.getType()) || this.sr.type.equals(SparkScalaRecipeMeta.META.getType())) {
                isSpark = true;
            }
            if (!isSpark) {
                return;
            }
        }
        HashMap<String, Dataset> datasets = new HashMap<String, Dataset>();
        for (SerializedRecipe.RecipeInput input : this.sr.getFlatInputs()) {
            target = this.cfrService.get(this.sr.projectKey, input.ref);
            if (!target.getType().equals((Object)FlowComputable.FCType.DATASET) || datasets.containsKey((targetLoc = DatasetLocUtils.resolveSmart(this.sr.projectKey, input.ref)).getFullName())) continue;
            datasets.put(targetLoc.getFullName(), this.datasetsAccesService.getOrNullUnsafe(targetLoc));
        }
        for (SerializedRecipe.RecipeOutput output : this.sr.getFlatOutputs()) {
            target = this.cfrService.get(this.sr.projectKey, output.ref);
            if (!target.getType().equals((Object)FlowComputable.FCType.DATASET) || datasets.containsKey((targetLoc = DatasetLocUtils.resolveSmart(this.sr.projectKey, output.ref)).getFullName())) continue;
            datasets.put(targetLoc.getFullName(), this.datasetsAccesService.getOrNullUnsafe(targetLoc));
        }
        for (Dataset targetDS : datasets.values()) {
            RecipeCodes messageCode;
            if (BuiltinFSDatasets.S3_META.getType().equals(targetDS.getType())) {
                messageCode = RecipeCodes.WARN_RECIPE_SPARK_INDIRECT_S3;
                connectionName = targetDS.getParamsAs(BuiltinFSDatasets.S3DatasetConfig.class).connection;
                EC2Connection connection = (EC2Connection)ConnectionsDAO.get().getMandatoryConnection(authCtx, connectionName);
                this.checkConnectionReadability(messages, connection, authCtx, messageCode, "S3 credentials");
                S3DatasetHandler.EncryptionMode encryptionMode = connection.params.encryptionMode;
                if (!encryptionMode.sparkDirectWrite && !HadoopFlavorUtils.isAtLeast(2, 9, 0)) {
                    messages.withWarning((InfoMessage.MessageCode)messageCode, "S3 encryption mode is " + String.valueOf((Object)encryptionMode));
                }
            } else {
                if (!BuiltinFSDatasets.HDFS_META.getType().equals(targetDS.getType())) continue;
                messageCode = RecipeCodes.WARN_RECIPE_SPARK_INDIRECT_HDFS;
                connectionName = targetDS.getParamsAs(HDFSDatasetHandler.Config.class).connection;
                this.checkConnectionReadability(messages, ConnectionsDAO.get().getMandatoryConnection(authCtx, connectionName), authCtx, messageCode, "HDFS connection details");
            }
            if (targetDS.getFormatType().equals(CSVFormatExtractor.META.getType())) {
                CSVFormatConfig csvFormat = (CSVFormatConfig)targetDS.getFormatParams();
                if (csvFormat != null && csvFormat.skipRowsBeforeHeader == 0 && !csvFormat.parseHeaderRow && csvFormat.skipRowsAfterHeader == 0) continue;
                messages.withWarning((InfoMessage.MessageCode)messageCode, "Non-empty header in CSV format");
                continue;
            }
            if (targetDS.getFormatType().equals(JSONFormatExtractor.META.getType())) {
                JSONFormatConfig jsonFormat = (JSONFormatConfig)targetDS.getFormatParams();
                if (jsonFormat.extractFromSingleElement) {
                    messages.withWarning((InfoMessage.MessageCode)messageCode, "Can't extract from a single component in json format");
                    continue;
                }
                if (jsonFormat.nestedArraysHandling == JSONFormatExtractor.NestedArraysHandling.PRESERVE) continue;
                messages.withWarning((InfoMessage.MessageCode)messageCode, "Unsupported nested array handling in json format");
                continue;
            }
            if (DeltaFormat.META.getType().equals(targetDS.getFormatType()) || UniversalFileOutputFormat.getFormatAdapter(targetDS.getFormatParams()) != null) continue;
            messages.withWarning((InfoMessage.MessageCode)messageCode, "Unsupported dataset format: " + targetDS.getFormatType());
        }
    }

    private void checkConnectionReadability(InfoMessage.InfoMessages messages, DSSConnection connection, AuthCtx authCtx, RecipeCodes messageCode, String unreadableItem) throws IOException {
        boolean isImpersonationEnabled = ((ImpersonationResolverService)SpringUtils.getBean(ImpersonationResolverService.class)).isEnabled();
        if ((isImpersonationEnabled || ApplicationConfigurator.getProperty((String)"security.hideConnectionsInSingleUserSecurity", (String)"false").equalsIgnoreCase("true")) && !connection.detailsReadableBy(authCtx)) {
            messages.withWarning((InfoMessage.MessageCode)messageCode, unreadableItem + " not readable by " + (isImpersonationEnabled ? "user impersonated by " : "") + "Spark for " + authCtx.getIdentifier());
        }
    }

    private boolean isSpark(String engineType) {
        return !StringUtils.isBlank((String)engineType) && engineType.equals(ENGINE_TYPE_SPARK);
    }

    public void check(InfoMessage.InfoMessages messages, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        this.checkS3ToRedshift(messages);
        SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getSparkSettings();
        if (sparkSettings.sparkEnabled) {
            this.checkSparkToIndirectHDFS(messages, authCtx);
        }
    }
}

