/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.embed_documents;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipeCreator;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipeParams;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipeRunner;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipeSchemaComputer;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipeStatusComputer;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRule;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class EmbedDocumentsRecipeMeta
extends RecipeMeta {
    public static final EmbedDocumentsRecipeMeta META = new EmbedDocumentsRecipeMeta();

    @Override
    public String getType() {
        return "embed_documents";
    }

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return EmbedDocumentsRecipeParams.class;
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new EmbedDocumentsRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) throws Exception {
        return new EmbedDocumentsRecipeRunner(activity);
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new EmbedDocumentsRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) throws Exception {
        return new EmbedDocumentsRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        RecipeDesc desc = new RecipeDesc("embed documents", null);
        desc.inputRoles.add(RecipeDesc.IORoleDef.newUnaryRequiredFolder("main", ""));
        desc.inputRoles.add(RecipeDesc.IORoleDef.newUnaryDataset("metadata_dataset", "Metadata dataset (optional)"));
        desc.outputRoles.add(RecipeDesc.IORoleDef.newUnaryRequiredRetrievableKnowledge("knowledge_bank", ""));
        desc.outputRoles.add(RecipeDesc.IORoleDef.newUnaryFolder("images", "Images Folder"));
        desc.copiable = false;
        return desc;
    }

    @Override
    public Set<String> underlyingConnectionNames(SerializedRecipe serializedRecipe, String payload) {
        HashSet<String> usedConnections = new HashSet<String>();
        EmbedDocumentsRecipeParams params = serializedRecipe.getParamsAs(EmbedDocumentsRecipeParams.class);
        String defaultVLLMId = params.getDefaultVLMSelection();
        EmbedDocumentsRecipeMeta.addToUnderlyingConnections(defaultVLLMId, usedConnections);
        for (EmbedDocumentsRule rule : params.getAllRules()) {
            if (rule.actionToPerform != EmbedDocumentsRule.ActionToPerform.VLM || rule.vlmSettings == null) continue;
            EmbedDocumentsRecipeMeta.addToUnderlyingConnections(rule.vlmSettings.llmId, usedConnections);
        }
        return usedConnections;
    }

    private static void addToUnderlyingConnections(String llmId, Set<String> usedConnections) {
        if (StringUtils.isEmpty((String)llmId) || llmId.equals("DSS_NO_SELECTION")) {
            return;
        }
        LLMStructuredRef ref = LLMStructuredRef.decodeId(llmId);
        if (!Strings.isNullOrEmpty((String)ref.connection)) {
            usedConnections.add(ref.connection);
        }
    }

    @Override
    public RecipePayloadParams remapConnections(SerializedRecipe serializedRecipe, String payload, Map<String, String> replacements) {
        EmbedDocumentsRecipePayloadParams payloadParams = (EmbedDocumentsRecipePayloadParams)JSON.parse((String)payload, EmbedDocumentsRecipePayloadParams.class);
        EmbedDocumentsRecipeParams params = serializedRecipe.getParamsAs(EmbedDocumentsRecipeParams.class);
        String defaultVLLMId = params.getDefaultVLMSelection();
        EmbedDocumentsRecipeMeta.getNewLLMId(serializedRecipe, replacements, defaultVLLMId).ifPresent(params::setDefaultVLMSelection);
        for (EmbedDocumentsRule rule : params.getAllRules()) {
            if (rule.actionToPerform != EmbedDocumentsRule.ActionToPerform.VLM || rule.vlmSettings == null) continue;
            EmbedDocumentsRecipeMeta.getNewLLMId(serializedRecipe, replacements, rule.vlmSettings.llmId).ifPresent(llmId -> {
                rule.vlmSettings.llmId = llmId;
            });
        }
        return payloadParams;
    }

    private static Optional<String> getNewLLMId(SerializedRecipe serializedRecipe, Map<String, String> replacements, String llmId) {
        if (StringUtils.isEmpty((String)llmId)) {
            return Optional.empty();
        }
        LLMStructuredRef ref = LLMStructuredRef.decodeId(llmId);
        if (!Strings.isNullOrEmpty((String)ref.connection) && replacements.containsKey(ref.connection)) {
            String newValue = replacements.get(ref.connection);
            if (newValue == null) {
                throw ErrorContext.iaef((String)"Did not find connection to remap in recipe %s : %s", (Object)serializedRecipe.name, (Object[])new Object[]{ref.connection});
            }
            ref.setConnection(newValue);
            return Optional.of(ref.encodeToId());
        }
        return Optional.empty();
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withNlp();
    }
}

