/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scheduler.ScenarioCodes;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RestartWebAppStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return RestartWebAppStepParams.class;
        }

        @Override
        public String getType() {
            return "restart_webapp";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new RestartWebAppStepRunner(scenario, step, step.getParamsAs(RestartWebAppStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "";
        }

        @Override
        public String buildId(Step step) {
            RestartWebAppStepParams stepParams = step.getParamsAs(RestartWebAppStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("restart_webapp");
            if (stepParams != null) {
                sb.append("_");
                sb.append(stepParams.webAppId);
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final RestartWebAppStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.restartwebapp");

    RestartWebAppStepRunner(Scenario scenario, Step step, RestartWebAppStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        String projectKey = this.scenario.getProjectKey();
        if (StringUtils.isBlank((String)this.params.webAppId)) {
            throw new CodedException((InfoMessage.MessageCode)ScenarioCodes.ERR_SCENARIO_INVALID_STEP_CONFIG, "Restart webapp step: Webapp identifier not specified in step configuration");
        }
        AnyLoc webAppLoc = new AnyLoc(projectKey, this.params.webAppId);
        ReportTargetItem.WebAppItem target = new ReportTargetItem.WebAppItem(projectKey, this.params.webAppId);
        ReportItem.RestartedWebApp reportItem = (ReportItem.RestartedWebApp)new ReportItem.RestartedWebApp(target).withStart(System.currentTimeMillis());
        try {
            WebApp webapp;
            logger.info((Object)("Restarting webapp " + this.params.webAppId));
            try (Transaction t = this.transactionService.beginRead();){
                webapp = this.webAppsService.getMandatoryUnsafe(projectKey, this.params.webAppId);
            }
            reportItem.withRunAs(webapp.params.runAs);
            FutureResponse future = this.webAppsService.restartBackend_NT(DSSAuthCtx.newNone(), webapp);
            logger.info((Object)"Restart in progress, waiting.");
            future = this.futureService.waitForFinalResponse(future);
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
        }
        catch (Exception e) {
            logger.info((Object)"Failed to restart webapp", (Throwable)e);
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED).withThrown(e);
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(webAppLoc, null, null, stepRun.getScenarioRun(), stepRun, reportItem);
        }
        stepReportItem.withOutcome(reportItem.getOutcome());
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class RestartWebAppStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String webAppId;

        public RestartWebAppStepParams withWebAppId(String webAppId) {
            this.webAppId = webAppId;
            return this;
        }
    }
}

