/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.triggers;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.datasets.DatasetConnectionUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.recipes.ParamsWithSelectableConnection;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.triggers.SQLQueryTriggerState;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.scheduler.triggers.TriggerMeta;
import com.dataiku.dip.scheduler.triggers.TriggerParams;
import com.dataiku.dip.scheduler.triggers.TriggerRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class SQLQueryTriggerRunner
implements TriggerRunner {
    public static final TriggerMeta META = new TriggerMeta(){

        @Override
        public Class<? extends TriggerParams> paramsClass() {
            return SQLQueryTriggerParams.class;
        }

        @Override
        public String getType() {
            return "sql_query";
        }

        @Override
        public TriggerRunner buildRunner(Scenario scenario, Trigger trigger) {
            return new SQLQueryTriggerRunner(scenario, trigger, trigger.getParamsAs(SQLQueryTriggerParams.class), new RealQueryExecutionEngines());
        }

        @Override
        public boolean delayIfScenarioAlreadyRuns() {
            return true;
        }

        @Override
        public String getDigest(Trigger trigger) {
            return "When a SQL query's output changes";
        }

        @Override
        public DateTime getExpectedNextRun(Trigger trigger, String stateString) {
            return null;
        }

        @Override
        public int getForcedTriggerLoopDelay(Trigger trigger, String currentState, boolean loopStarting) {
            return trigger.getDelay();
        }
    };
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private VariablesService variablesService;
    private final SQLQueryTriggerParams params;
    private final Trigger trigger;
    private final Scenario scenario;
    private final QueryExecutionEngines executionEngines;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.trigger.sql");

    public SQLQueryTriggerRunner(Scenario scenario, Trigger trigger, SQLQueryTriggerParams params, QueryExecutionEngines executionEngines) {
        this.trigger = trigger;
        this.params = params;
        this.scenario = scenario;
        this.executionEngines = executionEngines;
    }

    @Override
    public TriggerFire run(ScenariosTriggerService triggerService, AuthCtx authCtx) throws Exception {
        DSSConnection connection = this.connectionsDAO.getMandatoryConnection(authCtx, this.params.getConnection());
        if (ConnectionsDAO.parseVirtualConnection(this.params.getConnection()) == null && !connection.isFreelyUsableBy(authCtx)) {
            throw new DKUSecurityException(String.format("(triggerId: %s) User %s is not allowed to use connection %s", this.trigger.id, authCtx, this.params.connection));
        }
        String projectKey = this.scenario.getProjectKey();
        VariablesContext variablesContext = this.variablesService.getForProject(projectKey);
        StrSubstitutor substitutor = new StrSubstitutor(variablesContext.getAllVariables());
        String expandedSql = substitutor.replace(this.params.getSql());
        SQLQueryTriggerState state = null;
        try {
            state = this.executionEngines.getTriggerState(connection, projectKey, expandedSql, this.params, authCtx, this.trigger.id);
        }
        catch (Exception e) {
            logger.error((Object)("Failed SQL trigger: " + String.valueOf(e)));
            throw new RuntimeException(e.getMessage());
        }
        String stateString = triggerService.getTriggerState(this.scenario, this.trigger);
        SQLQueryTriggerState lastState = stateString == null ? null : (SQLQueryTriggerState)JSON.parse((String)stateString, SQLQueryTriggerState.class);
        logger.trace((Object)("Compare: " + String.valueOf(state)));
        logger.trace((Object)("With previous state: " + String.valueOf(lastState)));
        if (lastState == null || !lastState.getParamsHash().equals(state.getParamsHash())) {
            logger.trace((Object)"Params changed.");
            TriggerFire triggerFire = new TriggerFire().withProjectKey(projectKey).withScenarioId(this.scenario.getId()).withTrigger(this.trigger);
            triggerFire = triggerFire.withTriggerState(JSON.json((Object)state));
            triggerService.recordState(triggerFire);
            return null;
        }
        if (lastState.getRowCount() != state.getRowCount() || !lastState.getRowsHash().equals(state.getRowsHash())) {
            logger.infoV("SQL trigger fired due to query result change : %s", new Object[]{lastState.getRowCount() != state.getRowCount() ? "number of rows has changed from " + lastState.getRowCount() + " to " + state.getRowCount() : "one or more rows have changed"});
            TriggerFire triggerFire = new TriggerFire().withProjectKey(projectKey).withScenarioId(this.scenario.getId()).withTrigger(this.trigger);
            triggerFire = triggerFire.withTriggerState(JSON.json((Object)state));
            QueryRunResult result = new QueryRunResult();
            result.totalRows = state.getRowCount();
            result.success = true;
            result.totalRowsClipped = state.getRowCount() == this.params.getLimit();
            result.hasResultset = false;
            triggerFire = triggerFire.withParam("result", JSON.json((Object)result));
            return triggerFire;
        }
        logger.trace((Object)"Everything similar");
        return null;
    }

    public static class SQLQueryTriggerParams
    implements TriggerParams,
    ParamsWithSelectableConnection {
        public String connection;
        public String sql;
        public Boolean hasLimit;
        public Integer limit;

        public String getSql() {
            return this.sql;
        }

        public int getLimit() {
            if (this.hasLimit != null && this.hasLimit.booleanValue() && this.limit != null && this.limit > 0) {
                return this.limit;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public String getConnection() {
            return this.connection;
        }

        public SQLQueryTriggerParams withSql(String sql) {
            this.sql = sql;
            return this;
        }

        public SQLQueryTriggerParams withConnection(String connection) {
            this.connection = connection;
            return this;
        }

        public SQLQueryTriggerParams withHasLimit(boolean hasLimit) {
            this.hasLimit = hasLimit;
            return this;
        }

        public SQLQueryTriggerParams withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public void setConnection(String connection) {
            this.connection = connection;
        }

        @Override
        public DatasetConnectionUtils.UsedConnection collectConnectionUsage(TaggableObjectsService.TaggableObject object) {
            if (StringUtils.isNotBlank((String)this.connection)) {
                return new DatasetConnectionUtils.UsedConnection(this.connection, null);
            }
            return null;
        }
    }

    public static interface QueryExecutionEngines {
        public SQLQueryTriggerState getTriggerState(DSSConnection var1, String var2, String var3, SQLQueryTriggerParams var4, AuthCtx var5, String var6) throws Exception;
    }

    public static class RealQueryExecutionEngines
    implements QueryExecutionEngines {
        /*
         * Exception decompiling
         */
        @Override
        public SQLQueryTriggerState getTriggerState(DSSConnection connection, String projectKey, String sql, SQLQueryTriggerParams params, AuthCtx authCtx, String triggerId) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

