/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.audit.targets;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.audit.IAuditTrailTargetFactory;
import com.dataiku.dip.security.audit.model.AuditTrailTargetSettings;
import com.dataiku.dip.security.audit.model.EventServerTargetSettings;
import com.dataiku.dip.security.audit.model.FsLikeTargetSettings;
import com.dataiku.dip.security.audit.model.KafkaTargetSettings;
import com.dataiku.dip.security.audit.model.Log4JTargetSettings;
import com.dataiku.dip.security.audit.targets.AuditTarget;
import com.dataiku.dip.security.audit.targets.EventServerTarget;
import com.dataiku.dip.security.audit.targets.FsLikeTarget;
import com.dataiku.dip.security.audit.targets.KafkaTarget;
import com.dataiku.dip.security.audit.targets.Log4JTarget;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSAuditTrailTargetFactory
implements IAuditTrailTargetFactory {
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    @Autowired
    private NodesDirectoryService nodesDirectoryService;

    public AuditTarget build(AuditTrailTargetSettings atts) throws IOException, DKUSecurityException, CodedException {
        if (atts instanceof Log4JTargetSettings) {
            return new Log4JTarget((Log4JTargetSettings)atts);
        }
        if (atts instanceof EventServerTargetSettings) {
            EventServerTargetSettings ests = (EventServerTargetSettings)JSON.deepCopy((Object)((EventServerTargetSettings)atts));
            ests.authKey = this.symetricCryptoService.decryptIfEncrypted(ests.authKey);
            NodesDirectory directory = this.nodesDirectoryService.getNodesDirectory_AutoTXN();
            String nodeType = ApplicationConfigurator.getNodeType().toString();
            String instanceName = null;
            try {
                instanceName = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().nodeName;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new EventServerTarget(ests, directory, nodeType, instanceName);
        }
        if (atts instanceof KafkaTargetSettings) {
            return new KafkaTarget((KafkaTargetSettings)atts);
        }
        if (atts instanceof FsLikeTargetSettings) {
            return new FsLikeTarget((FsLikeTargetSettings)atts);
        }
        throw new IllegalArgumentException("Invalid audit target: " + String.valueOf(atts));
    }
}

