/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SessionsDAO;
import com.dataiku.dip.dao.UserSession;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.NotLoggedInException;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.SAASInstanceService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.UpgradeRequest;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UIAuthService {
    @Autowired
    private SessionsDAO sessionsDAO;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private InternalAPIKeysService internalApiKeysService;
    @Autowired
    private AchievementsService achievementsService;
    @Autowired
    private SAASInstanceService saasInstanceService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private GeneralSettingsDAO gsDAO;
    @Autowired
    private LicenseStatusService licenseStatusService;
    public static final String ACCESS_TOKEN_COOKIE_PREFIX = "dss_access_token_";
    public static final String IDENTITY_TOKEN_COOKIE_PREFIX = "dss_identity_token_";
    public static final String SAAS_ACCESS_TOKEN_COOKIE = "dss_saas_access_token";
    public static final String XSRF_TOKEN_HEADER = "X-XSRF-TOKEN";
    public static final String XSRF_TOKEN_COOKIE_PREFIX = "dss_xsrf_token_";
    public static final String PKCE_CODE_VERIFIER_COOKIE_NAME = "pkce_code_verifier";
    private static final String SAME_SITE_ATTRIBUTE = "SameSite";
    private static final String NONE_VALUE = "None";
    private boolean ipBoundSessions;
    private Cache<String, SAASInstanceService.UserAccessSummary> cachedSAASCredentials = CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private static DKULogger logger = DKULogger.getLogger((String)"dip.auth");

    @PostConstruct
    public void readSettings() {
        this.ipBoundSessions = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().security.ipBoundSessions;
        if (this.ipBoundSessions) {
            logger.info((Object)"Enabling IP-bound sessions");
        }
    }

    public static String getAccessCookieName() {
        return ACCESS_TOKEN_COOKIE_PREFIX + DigestUtils.md5Hex((String)ApplicationConfigurator.dipInstanceId());
    }

    public static String getIdentityCookieName() {
        return IDENTITY_TOKEN_COOKIE_PREFIX + DigestUtils.md5Hex((String)ApplicationConfigurator.dipInstanceId());
    }

    public static String getXSRFCookieName() {
        return XSRF_TOKEN_COOKIE_PREFIX + DigestUtils.md5Hex((String)ApplicationConfigurator.dipInstanceId());
    }

    public List<Cookie> createSession(String userLogin) throws IOException {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        UserSession userSession = new UserSession();
        userSession.accessToken = SecretKeyGenerator.generate();
        userSession.identityToken = SecretKeyGenerator.generate();
        userSession.xsrfTokenSalt = SecretKeyGenerator.generate((int)8);
        userSession.granted = System.currentTimeMillis();
        userSession.refreshed = System.currentTimeMillis();
        if (this.ipBoundSessions) {
            AuditContextBase.AuditContextData acd = AuditContextBase.getContextData();
            if (acd == null) {
                logger.error((Object)"No AuditContextData, cannot assign session IP");
                throw new IOException("Unable to create session");
            }
            String userOriginalIP = acd.originalIP;
            if (userOriginalIP == null) {
                logger.error((Object)"No originalIP in AuditContextData, cannot assign session IP");
                throw new IOException("Unable to create session");
            }
            userSession.ip = userOriginalIP;
        }
        if (this.licenseStatusService.getLicensingStatus().ceEntrepriseTrial) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeZone(TimeZone.getDefault());
            cal.add(5, 1);
            cal.set(10, 4);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            logger.info((Object)("Will expire session at " + String.valueOf(cal.getTime())));
            userSession.forcedExpire = cal.getTimeInMillis();
        }
        this.sessionsDAO.addSession(userLogin, userSession);
        Cookie ic = new Cookie(UIAuthService.getIdentityCookieName(), userSession.identityToken);
        ic.setHttpOnly(true);
        ic.setSecure(ApplicationConfigurator.secureCookies());
        if (ApplicationConfigurator.sameSiteNoneCookies()) {
            ic.setAttribute(SAME_SITE_ATTRIBUTE, NONE_VALUE);
        }
        ic.setPath("/");
        ret.add(ic);
        Cookie c2 = new Cookie(UIAuthService.getAccessCookieName(), userSession.accessToken);
        c2.setHttpOnly(true);
        c2.setSecure(ApplicationConfigurator.secureCookies());
        if (ApplicationConfigurator.sameSiteNoneCookies()) {
            c2.setAttribute(SAME_SITE_ATTRIBUTE, NONE_VALUE);
        }
        c2.setPath("/");
        ret.add(c2);
        return ret;
    }

    public void createSession(HttpServletResponse resp, String userLogin) throws IOException {
        List<Cookie> cookies = this.createSession(userLogin);
        for (Cookie c2 : cookies) {
            resp.addCookie(c2);
        }
    }

    public void createPKCECodeVerifierCookie(HttpServletResponse resp, String codeVerifier) {
        if (codeVerifier != null) {
            Cookie ic = new Cookie(PKCE_CODE_VERIFIER_COOKIE_NAME, codeVerifier);
            ic.setHttpOnly(true);
            ic.setSecure(ApplicationConfigurator.secureCookies());
            if (ApplicationConfigurator.sameSiteNoneCookies()) {
                ic.setAttribute(SAME_SITE_ATTRIBUTE, NONE_VALUE);
            }
            ic.setPath("/");
            resp.addCookie(ic);
        } else {
            this.deletePKCECodeVerifierCookie(resp);
        }
    }

    public void deletePKCECodeVerifierCookie(HttpServletResponse resp) {
        Cookie ic = new Cookie(PKCE_CODE_VERIFIER_COOKIE_NAME, "");
        ic.setPath("/");
        ic.setMaxAge(0);
        ic.setHttpOnly(true);
        resp.addCookie(ic);
    }

    public Optional<String> getCodeVerifierFromCookie(HttpServletRequest req) {
        if (req.getCookies() == null) {
            return Optional.empty();
        }
        return Arrays.asList(req.getCookies()).stream().filter(c2 -> c2.getName().equals(PKCE_CODE_VERIFIER_COOKIE_NAME)).map(Cookie::getValue).findAny();
    }

    public void destroyCurrentSession(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map cookies = ServletUtils.parseCookies((HttpServletRequest)req);
        assert (!ApplicationConfigurator.isSAASAuth());
        String cookieAT = (String)cookies.get(UIAuthService.getAccessCookieName());
        if (cookieAT == null) {
            return;
        }
        this.sessionsDAO.removeSession(cookieAT);
        Cookie ic = new Cookie(UIAuthService.getIdentityCookieName(), "");
        ic.setPath("/");
        ic.setMaxAge(0);
        ic.setHttpOnly(true);
        resp.addCookie(ic);
        Cookie c2 = new Cookie(UIAuthService.getAccessCookieName(), "");
        c2.setPath("/");
        c2.setMaxAge(0);
        c2.setHttpOnly(true);
        resp.addCookie(c2);
    }

    private static String computeXSRFToken(String accessToken, String xsrfTokenSalt) {
        return DigestUtils.sha256Hex((String)(xsrfTokenSalt + ":" + accessToken));
    }

    private static void checkXSRF(String accessToken, String xsrfTokenSalt, String xsrfHeaderValue) {
        String expectedXSRFToken;
        if (System.getenv("DKU_NO_XSRF") == null && !(expectedXSRFToken = UIAuthService.computeXSRFToken(accessToken, xsrfTokenSalt)).equals(xsrfHeaderValue)) {
            throw new SecurityException("XSRF validation failed, please refresh the page.");
        }
    }

    private AuthCtx getAuthCtx(String login, String accessToken) throws IOException {
        UsersDAO.User u = this.usersDAO.getOrNullUnsafe(login);
        if (u == null) {
            return null;
        }
        DSSAuthCtx liu = DSSAuthCtx.forUserFromUI(this.usersService, login, accessToken);
        this.achievementsService.resetSessionTimer(liu, accessToken);
        return liu;
    }

    private AuthCtx getFromInternalAPIKey(String apiKeyHeader) throws IOException {
        if (apiKeyHeader == null) {
            return null;
        }
        InternalAPIKeysService.APIKey apiKey = this.internalApiKeysService.get(apiKeyHeader);
        if (apiKey == null) {
            return null;
        }
        return this.getAuthCtx(apiKey.associatedUser, apiKey.key);
    }

    private SAASInstanceService.UserAccessSummary getSAASAccess(Map<String, String> cookies) throws IOException {
        assert (ApplicationConfigurator.isSAASAuth());
        String saasAccessToken = cookies.get(SAAS_ACCESS_TOKEN_COOKIE);
        if (saasAccessToken == null) {
            return new SAASInstanceService.UserAccessSummary();
        }
        SAASInstanceService.UserAccessSummary cached = (SAASInstanceService.UserAccessSummary)this.cachedSAASCredentials.getIfPresent((Object)saasAccessToken);
        if (cached != null) {
            logger.info((Object)"SAAS instance, using cached details");
            return cached;
        }
        logger.info((Object)("SAAS instance, authenticating remotely with :" + cookies.get(SAAS_ACCESS_TOKEN_COOKIE)));
        SAASInstanceService.UserAccessSummary uia = this.saasInstanceService.getAccess(saasAccessToken);
        this.cachedSAASCredentials.put((Object)saasAccessToken, (Object)uia);
        if (uia.hasAccess) {
            logger.info((Object)"SAAS instance,syncing users list");
            try {
                this.saasInstanceService.syncUsersList();
            }
            catch (CodedException e) {
                throw new IOException("Failed to sync SaaS users list", e);
            }
        }
        return uia;
    }

    private UserSession getLocalSession(Map<String, String> cookies, boolean checkSessionIP) throws IOException {
        assert (!ApplicationConfigurator.isSAASAuth());
        String cookieAT = cookies.get(UIAuthService.getAccessCookieName());
        if (cookieAT == null) {
            logger.trace((Object)"No access_token cookie received");
            return null;
        }
        UserSession session = this.sessionsDAO.getUserLoginWithSession(cookieAT);
        if (session == null) {
            logger.warn((Object)"Received access token does not correspond to any valid session");
            return null;
        }
        if (this.ipBoundSessions && checkSessionIP) {
            AuditContextBase.AuditContextData acd = AuditContextBase.getContextData();
            if (acd == null) {
                logger.error((Object)"No AuditContextData, cannot validate session IP");
                throw new IOException("Unable to process query");
            }
            String userOriginalIP = acd.originalIP;
            if (userOriginalIP == null) {
                logger.error((Object)"No originalIP in AuditContextData, cannot validate session IP");
                throw new IOException("Unable to process query");
            }
            if (session.ip == null) {
                logger.error((Object)"Session does not have an IP bound to it, rejecting it");
                return null;
            }
            if (!session.ip.equals(userOriginalIP)) {
                logger.errorV("Session IP mismatch (user:%s, session:%s), rejecting it", new Object[]{userOriginalIP, session.ip});
                return null;
            }
            logger.trace(() -> String.format("IP-bound sessions: OK (clientIP: %s, originalIP: %s, xff: %s)", acd.clientIP, userOriginalIP, acd.xForwardedFor));
        }
        return session;
    }

    private UserSession getLocalIdentity(Map<String, String> cookies) throws IOException {
        assert (!ApplicationConfigurator.isSAASAuth());
        String cookieIT = cookies.get(UIAuthService.getIdentityCookieName());
        if (cookieIT == null) {
            logger.trace((Object)"No identity_token cookie received");
            return null;
        }
        UserSession session = this.sessionsDAO.getUserLoginWithIdentity(cookieIT);
        if (session == null) {
            logger.warn((Object)"Received identity token does not correspond to any valid session");
        }
        return session;
    }

    public AuthCtx getUserInternal(Map<String, String> cookies, String apiKeyHeader, String xsrfTokenHeader, boolean checkXSRF, boolean checkSessionIP) throws IOException {
        if (ApplicationConfigurator.isSAASAuth()) {
            SAASInstanceService.UserAccessSummary saasAccess = this.getSAASAccess(cookies);
            if (saasAccess != null && saasAccess.hasAccess) {
                if (checkXSRF) {
                    UIAuthService.checkXSRF(saasAccess.accessToken, saasAccess.xsrfTokenSalt, xsrfTokenHeader);
                }
                return this.getAuthCtx(saasAccess.login, saasAccess.accessToken);
            }
        } else {
            UserSession session = this.getLocalSession(cookies, checkSessionIP);
            if (session != null) {
                if (checkXSRF) {
                    UIAuthService.checkXSRF(session.accessToken, session.xsrfTokenSalt, xsrfTokenHeader);
                }
                return this.getAuthCtx(session.user, session.accessToken);
            }
        }
        return this.getFromInternalAPIKey(apiKeyHeader);
    }

    public AuthCtx getUserFromIdentityInternal(Map<String, String> cookies, String xsrfTokenHeader, boolean checkXSRF) throws IOException, UnauthorizedException {
        if (ApplicationConfigurator.isSAASAuth()) {
            return null;
        }
        UserSession session = this.getLocalIdentity(cookies);
        if (session != null) {
            if (checkXSRF) {
                UIAuthService.checkXSRF(session.accessToken, session.xsrfTokenSalt, xsrfTokenHeader);
            }
            return this.getAuthCtx(session.user, session.accessToken);
        }
        return null;
    }

    public AuthCtx getUser(HttpServletRequest req) throws IOException {
        Map cookies = ServletUtils.parseCookies((HttpServletRequest)req);
        String apiKeyHeader = req.getHeader("X-DKU-APIKey");
        String xsrfTokenHeader = req.getHeader(XSRF_TOKEN_HEADER);
        return this.getUserInternal(cookies, apiKeyHeader, xsrfTokenHeader, true, true);
    }

    public AuthCtx getUserNoXSRF(HttpServletRequest req) throws IOException {
        Map cookies = ServletUtils.parseCookies((HttpServletRequest)req);
        String apiKeyHeader = req.getHeader("X-DKU-APIKey");
        return this.getUserInternal(cookies, apiKeyHeader, null, false, true);
    }

    public AuthCtx getMandatoryUser(UpgradeRequest req) throws IOException {
        Map cookies = ServletUtils.parseCookies((UpgradeRequest)req);
        boolean checkXSRF = true;
        String xsrfToken = null;
        block0 : switch (WebSocketXsrfStrategy.valueOf(ApplicationConfigurator.getProperty((String)"dku.security.websocket.xsrfStrategy", (String)WebSocketXsrfStrategy.SUBPROTOCOL.name()))) {
            case NONE: {
                checkXSRF = false;
                break;
            }
            case SUBPROTOCOL: {
                if (req.getSubProtocols() == null) break;
                for (String protocol : req.getSubProtocols()) {
                    if (protocol == null || !protocol.startsWith("xsrf-")) continue;
                    xsrfToken = protocol.substring(5);
                    break block0;
                }
                break;
            }
        }
        AuthCtx u = this.getUserInternal(cookies, null, xsrfToken, checkXSRF, true);
        if (u == null) {
            throw new NotLoggedInException("Not logged-in");
        }
        return u;
    }

    public AuthCtx getMandatoryUser(HttpServletRequest req) throws IOException {
        AuthCtx u = this.getUser(req);
        if (u == null) {
            throw new NotLoggedInException("Not logged-in");
        }
        return u;
    }

    public AuthCtx getMandatoryUserNoXSRF(HttpServletRequest req) throws IOException {
        AuthCtx u = this.getUserNoXSRF(req);
        if (u == null) {
            throw new NotLoggedInException("Not logged-in");
        }
        return u;
    }

    public SAASInstanceService.UserAccessSummary getSAASAccess(HttpServletRequest req) throws IOException {
        return this.getSAASAccess(ServletUtils.parseCookies((HttpServletRequest)req));
    }

    public void setXSRFCookie(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String xsrfValue;
        Map cookies = ServletUtils.parseCookies((HttpServletRequest)req);
        if (ApplicationConfigurator.isSAASAuth()) {
            SAASInstanceService.UserAccessSummary saasAccess = this.getSAASAccess(cookies);
            assert (saasAccess != null);
            xsrfValue = UIAuthService.computeXSRFToken(saasAccess.accessToken, saasAccess.xsrfTokenSalt);
        } else {
            UserSession session = this.getLocalSession(cookies, true);
            assert (session != null);
            xsrfValue = UIAuthService.computeXSRFToken(session.accessToken, session.xsrfTokenSalt);
        }
        Cookie c2 = new Cookie(UIAuthService.getXSRFCookieName(), xsrfValue);
        c2.setPath("/");
        c2.setSecure(ApplicationConfigurator.secureCookies());
        if (ApplicationConfigurator.sameSiteNoneCookies()) {
            c2.setAttribute(SAME_SITE_ATTRIBUTE, NONE_VALUE);
        }
        resp.addCookie(c2);
    }

    public void failIfNotAdmin(HttpServletRequest req) throws IOException, DKUSecurityException {
        this.failIfNotAdmin(this.getMandatoryUser(req));
    }

    public void failIfNotAdmin(AuthCtx u) throws IOException, DKUSecurityException {
        if (!((DSSAuthCtx)u).getPermissions().isAdmin()) {
            throw new UnauthorizedException("You are not admin of this DSS instance", "not-admin");
        }
    }

    public void failIfNotAdminNoXSRF(HttpServletRequest req) throws IOException, DKUSecurityException {
        if (!((DSSAuthCtx)this.getMandatoryUserNoXSRF(req)).getPermissions().isAdmin()) {
            throw new UnauthorizedException("You are not admin of this DSS instance", "not-admin");
        }
    }

    public static enum WebSocketXsrfStrategy {
        NONE,
        SUBPROTOCOL;

    }
}

