/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.apideployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.projects.importexport.AutomationBundlesService;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.TestBundleInfoDTO;
import com.dataiku.dip.projects.importexport.model.BundleContainerSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class AutomationBundlesController
extends DIPInternalControllerBase {
    private static Logger logger = Logger.getLogger((String)"dip.controllers.projects");
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private AutomationBundlesService automationBundlesService;
    @Autowired
    private AuditTrailService auditTrailService;

    @AuditedCall(value={"msgType", "automation-bundles-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/automation/list-bundles"})
    public void listBundles(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        AutomationBundlesController.writeJSON((HttpServletResponse)resp, (Object)this.automationBundlesService.listImported(projectKey));
    }

    @AuditedCall(value={"msgType", "automation-bundle-read-meta", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/projects/automation/get-bundle-details"})
    public void getBundleDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        AutomationBundlesController.writeJSON((HttpServletResponse)resp, (Object)this.automationBundlesService.getBundleDetails(projectKey, bundleId));
    }

    @AuditInline
    @RequestMapping(value={"/api/projects/automation/create-with-initial-bundle"}, method={RequestMethod.POST})
    public void createWithInitialBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart, @RequestParam(required=false) String projectFolderId, @RequestParam(required=false) String projectKey, @RequestParam(required=false, defaultValue="NONE") AbstractProjectDeploymentInfra.PermissionsPropagationPolicy permissionsPropagationPolicy) throws Exception {
        DSSAuthCtx user;
        logger.info((Object)("Creating a new project using initial bundle upload" + filePart.getOriginalFilename()));
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!user.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
        }
        String newProjectKey = null;
        try {
            newProjectKey = this.automationBundlesService.createProjectUsingInitialBundleZipStream(user, filePart.getInputStream(), projectFolderId, projectKey, permissionsPropagationPolicy);
            AutomationBundlesController.writeJSON((HttpServletResponse)resp, (Object)JF.obj().with("projectKey", newProjectKey).get());
        }
        catch (Exception e) {
            this.auditTrailService.failure("automation-project-create", (Throwable)e).with("fileName", filePart.getOriginalFilename()).with("projectKey", newProjectKey).emit();
            throw e;
        }
        this.auditTrailService.generic("automation-project-create").with("fileName", filePart.getOriginalFilename()).with("projectKey", newProjectKey).emit();
    }

    @AuditedCall(value={"msgType", "automation-bundle-import", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/automation/import-bundle"}, method={RequestMethod.POST})
    public void importBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        logger.info((Object)("Importing bundle using bundle import for project " + projectKey));
        AuthCtx user = null;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        this.automationBundlesService.importBundleZipStream(user, projectKey, filePart.getInputStream(), false);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/projects/automation/check-bundle-activation"})
    public void checkBundleActivation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        logger.info((Object)("Checking activation of bundle " + projectKey + " / " + bundleId));
        AuthCtx user = null;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        AutomationBundlesController.writeJSON((HttpServletResponse)resp, (Object)((Object)this.automationBundlesService.checkBundleActivation(user, projectKey, bundleId, false)));
    }

    @AuditedCall(value={"msgType", "automation-bundle-activate", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/projects/automation/activate-bundle"}, method={RequestMethod.POST})
    public void activateBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        logger.info((Object)("Activating bundle " + projectKey + " / " + bundleId));
        AuthCtx user = null;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        AutomationBundlesController.writeJSON((HttpServletResponse)resp, this.automationBundlesService.startActivateBundle_NT(user, projectKey, bundleId));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/projects/automation/get-activation-settings-ext"})
    public void getActivationSettingsExtended(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(liu, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            AutomationBundlesController.writeJSON((HttpServletResponse)resp, (Object)this.automationBundlesService.getBundleContainerSettingsExt(liu, projectKey));
        }
    }

    @AuditedCall(value={"msgType", "automation-bundle-preload", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/projects/automation/preload-bundle"}, method={RequestMethod.POST})
    public void startPreloadBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        AutomationBundlesController.writeJSON((HttpServletResponse)resp, this.automationBundlesService.startPreloadBundle_NT(authCtx, projectKey, bundleId));
    }

    @AuditedCall(value={"msgType", "automation-bundle-set-settings", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/automation/save-activation-settings"}, method={RequestMethod.POST})
    public void saveActivationSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String settings) throws Exception {
        BundleContainerSettings bcs = (BundleContainerSettings)JSON.parse((String)settings, BundleContainerSettings.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            this.automationBundlesService.saveBundleContainerSettings(projectKey, bcs);
            t.commit("Updated bundle activation settings");
        }
    }

    @AuditedCall(value={"msgType", "automation-bundle-delete", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/projects/automation/delete-bundle"}, method={RequestMethod.POST})
    public void deleteBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        logger.info((Object)("Deleting bundle " + projectKey + " / " + bundleId));
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        this.automationBundlesService.deleteBundle(projectKey, bundleId);
    }

    @AuditedCall(value={"msgType", "automation-test-bundles-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/automation/list-test-bundles"})
    @ResponseBody
    public List<TestBundleInfoDTO> listTestBundles(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        String activeBundleId;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            try {
                activeBundleId = CommonBundleUtils.getActiveBundleId(projectKey);
            }
            catch (IllegalArgumentException cannotRetrieveActiveBundle) {
                throw new IllegalArgumentException(String.format("There is no active bundle on the project %s", projectKey));
            }
        }
        return this.automationBundlesService.listTestBundleInfoDTO(projectKey, activeBundleId);
    }
}

