/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.mec.ModelComparison;
import com.dataiku.dip.mec.ModelComparisonsCRUDService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ModelComparisonsCRUDController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ModelComparisonsCRUDService modelComparisonsCRUDService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private TimelinesService timelinesService;

    @AuditedCall(value={"msgType", "modelcomparisons-get", "projectKey", "${projectKey}", "modelComparisonId", "${modelComparisonId}"})
    @RequestMapping(value={"/api/modelcomparisons/get"}, method={RequestMethod.GET})
    @ResponseBody
    public ModelComparison getModelEvaluationComparator(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String modelComparisonId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ModelComparison modelComparison = this.modelComparisonsCRUDService.getMandatoryUnsafe(projectKey, modelComparisonId);
            return modelComparison;
        }
    }

    @AuditedCall(value={"msgType", "modelcomparisons-full-info-get", "projectKey", "${projectKey}", "modelComparisonId", "${modelComparisonId}"})
    @RequestMapping(value={"/api/modelcomparisons/get-full-info"}, method={RequestMethod.GET})
    @ResponseBody
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelComparisonId) throws Exception {
        NavigatorService.ModelComparisonFullInfo info;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            info = this.navigatorService.getModelEvaluationComparatorFullInfo(projectKey, modelComparisonId);
        }
        this.navigatorService.addInfo_NT(info, authCtx);
        ModelComparisonsCRUDController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "modelcomparisons-get", "projectKey", "${projectKey}", "id", "${modelComparisonId}"})
    @RequestMapping(value={"/api/modelcomparisons/delete"}, method={RequestMethod.POST})
    public void deleteModelEvaluationComparator(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String modelComparisonId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.modelComparisonsCRUDService.delete(authCtx, projectKey, modelComparisonId);
            t.commit("Deleted model comparator " + modelComparisonId);
        }
    }

    @AuditedCall(value={"msgType", "modelcomparisons-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/modelcomparisons/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ModelComparison> listModelEvaluationComparators(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List<ModelComparison> list = this.modelComparisonsCRUDService.list(projectKey);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "modelcomparisons-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/modelcomparisons/list-heads"}, method={RequestMethod.GET})
    public void listModelEvaluationComparatorsHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        ArrayList<ModelComparison.ModelComparisonListItem> heads = new ArrayList<ModelComparison.ModelComparisonListItem>();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List<ModelComparison> list = this.modelComparisonsCRUDService.list(projectKey);
            for (ModelComparison modelComparison : list) {
                ModelComparison.ModelComparisonListItem item = new ModelComparison.ModelComparisonListItem(modelComparison);
                this.taggableObjectsService.setEditionInfoFromTags(modelComparison, item);
                heads.add(item);
            }
        }
        this.interestsService.enrichListItems(authCtx.getAssociatedDSSUser(), projectKey, heads);
        ModelComparisonsCRUDController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditInline
    @RequestMapping(value={"/api/modelcomparisons/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ModelComparison saveModelEvaluationComparator(HttpServletRequest req, @RequestParam ModelComparison data, @RequestParam(required=false, defaultValue="{}") TaggableObjectsService.TaggableObjectSaveInfo saveInfo) throws Exception {
        ModelComparison modelComparison;
        block8: {
            RWTransaction t = this.transactionService.beginWriteForUI(req);
            try {
                AuthCtx authCtx = this.authService.getMandatoryUser(req);
                this.permissionsService.checkProjectPrivileges(authCtx, data.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                ModelComparison savedModelComparison = this.modelComparisonsCRUDService.save(authCtx, data, false, saveInfo.summaryOnly);
                t.commit("Save MEC " + savedModelComparison.getFullId(), 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
                this.auditTrailService.generic("modelcomparisons-save").with("projectKey", data.projectKey).with("modelComparisonId", data.id).emit();
                modelComparison = savedModelComparison;
                if (t == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.auditTrailService.failure("modelcomparisons-save", (Throwable)e).with("projectKey", data.projectKey).with("modelComparisonId", data.id).emit();
                    throw e;
                }
            }
            t.close();
        }
        return modelComparison;
    }

    @AuditInline
    @RequestMapping(value={"/api/modelcomparisons/create"}, method={RequestMethod.POST})
    @ResponseBody
    public ModelComparison create(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String displayName, @RequestParam ModelComparison.ModelTaskType modelTaskType) throws Exception {
        ModelComparison modelComparison;
        block8: {
            RWTransaction t = this.transactionService.beginWriteForUI(req);
            try {
                AuthCtx authCtx = this.authService.getMandatoryUser(req);
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                ModelComparison createdComparator = this.modelComparisonsCRUDService.create(authCtx, projectKey, displayName, modelTaskType);
                t.commit("Create MEC " + createdComparator.getFullId() + " with name " + createdComparator.displayName, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
                this.auditTrailService.generic("modelcomparisons-create").with("projectKey", createdComparator.projectKey).with("modelComparisonId", createdComparator.id).emit();
                modelComparison = createdComparator;
                if (t == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.auditTrailService.failure("modelcomparisons-create", (Throwable)e).with("projectKey", projectKey).emit();
                    throw e;
                }
            }
            t.close();
        }
        return modelComparison;
    }

    @AuditedCall(value={"msgType", "modelcomparisons-get", "projectKey", "${projectKey}", "modelComparisonId", "${modelComparisonId}"})
    @RequestMapping(value={"/api/modelcomparisons/get-summary"}, method={RequestMethod.GET})
    @ResponseBody
    public TaggableObjectsService.TaggableObjectSummary getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelComparisonId) throws Exception {
        AuthCtx authCtx;
        TaggableObjectsService.TaggableObjectSummary summ = new TaggableObjectsService.TaggableObjectSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            summ.object = this.modelComparisonsCRUDService.getMandatoryUnsafe(projectKey, modelComparisonId);
        }
        summ.timeline = this.timelinesService.getObjectTimeline_NT(summ.object.getTaggableType(), projectKey, modelComparisonId, summ.object.creationTag, summ.object.versionTag, 0, 100);
        summ.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summ.object.getTaggableType(), projectKey, modelComparisonId);
        return summ;
    }
}

