/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSProviderConnectionFactory;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.FSTestProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSPathWithSelected;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.variables.VariablesUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FSDatasetBrowseService {
    @Autowired
    private VariablesService variablesService;
    private static Logger logger = Logger.getLogger((String)"dku.fs.browse");

    public FSBrowsePath browse(AuthCtx authCtx, Dataset dataset, String path) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        FSBrowsePath ret;
        block8: {
            if (!DatasetHandlerFactory.getMeta(dataset).isFS()) {
                throw new DSSInternalErrorException("Dataset is not fs-like: " + dataset.getName() + " (" + dataset.getType() + ")");
            }
            path = path.length() == 0 ? "/" : VariablesUtils.expand(dataset.getProjectKey(), path);
            try (AbstractFSDatasetHandler handler = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                if (handler instanceof BrowsableHandler) {
                    ret = ((BrowsableHandler)((Object)handler)).browse(path);
                    break block8;
                }
                throw new DSSInternalErrorException("Dataset doesn't provide native browse");
            }
        }
        logger.info((Object)("Browse done, have " + ret.children.size() + " items"));
        Collections.sort(ret.children, new Comparator<FSBrowsePath>(){

            @Override
            public int compare(FSBrowsePath o1, FSBrowsePath o2) {
                if (o1.directory && !o2.directory) {
                    return -1;
                }
                if (o2.directory && !o1.directory) {
                    return 1;
                }
                return o1.name.toLowerCase().compareTo(o2.name.toLowerCase());
            }
        });
        return ret;
    }

    public FSListFilesResult listFiles(AuthCtx authCtx, String type, AbstractFSDatasetHandler.AbstractFSConfig config, String projectKey, Map<String, String> contextVars, FilesSelectionRules rules, VariablesExpansionLoopConfig veLoopConfig, boolean selectedOnly) throws Exception {
        FSListFilesResult ret = new FSListFilesResult();
        if (StringUtils.isNotBlank((String)config.path)) {
            VariablesContext variablesContext = this.variablesService.getForProjectAndUserLogin(projectKey, authCtx);
            for (Map.Entry<String, String> e : contextVars.entrySet()) {
                variablesContext.add(e.getKey(), e.getValue());
            }
            config.path = variablesContext.expand(config.path);
        }
        FSProviderConnectionFactory connectionFactory = new FSProviderConnectionFactory();
        DSSConnection connection = connectionFactory.getConnectionForProvider(type, authCtx, config, "provider of type " + type);
        final String providerRoot = config.path;
        logger.info((Object)("Use providerRoot '" + config.path + "'"));
        this.expandSelectionRulesInPlaceInternal(authCtx, projectKey, rules, veLoopConfig, "cannot list files");
        try (FSProvider provider = FSProviderFactory.getProvider(type, authCtx, projectKey, config, providerRoot, connection);){
            FSEnumerationSettings enumerationSettings = new FSEnumerationSettings();
            if (selectedOnly) {
                enumerationSettings.selectionRules = rules;
            }
            FSEnumerationResult enumerationResult = null;
            try (DSSMetrics.TimeCtx timeCtx = DSSMetrics.timeCtx((String)("dku.services.fsproviders.listFiles." + provider.getClass().getSimpleName() + ".enumerate"));){
                final FSPathOrDirectory rootStatus = provider.stat("");
                enumerationResult = rootStatus != null && !rootStatus.isDirectory ? new FSEnumerationResult(){

                    public boolean isSuccessful() {
                        return true;
                    }

                    public Iterable<FSPath> getPaths() {
                        String fileName = "/" + (String)PathUtils.splitBasename((String)providerRoot).second;
                        return Lists.newArrayList((Object[])new FSPath[]{new FSPath(fileName, rootStatus.getSize(), rootStatus.getLastModified())});
                    }

                    public Throwable getError() {
                        return null;
                    }

                    public boolean enumerationPrefixExists() {
                        return true;
                    }
                } : provider.enumerateRecursive("", enumerationSettings);
            }
            if (!enumerationResult.isSuccessful()) {
                throw new IOException("Listing files failed", enumerationResult.getError());
            }
            timeCtx = DSSMetrics.timeCtx((String)("dku.services.fsproviders.listFiles." + provider.getClass().getSimpleName() + ".filter"));
            try {
                if (selectedOnly) {
                    for (FSPath path : enumerationResult.getPaths()) {
                        FSPathWithSelected pw = new FSPathWithSelected(path.path(), path.getSize(), path.getLastModified(), true);
                        ++ret.totalFiles;
                        ++ret.selectedFiles;
                        ret.totalSize += pw.getSize();
                        ret.selectedSize += pw.getSize();
                        ret.paths.add(pw);
                    }
                } else if (enumerationResult.enumerationPrefixExists()) {
                    for (FSPath path : enumerationResult.getPaths()) {
                        String pathToEvaluate = PathUtils.slashes((String)path.path(), (Boolean)false, (Boolean)false, (boolean)true, null);
                        FSPathWithSelected pw = new FSPathWithSelected(path.path(), path.getSize(), path.getLastModified(), pathToEvaluate != null && rules.includes(pathToEvaluate));
                        ++ret.totalFiles;
                        if (pw.selected) {
                            ++ret.selectedFiles;
                        }
                        ret.totalSize += pw.getSize();
                        if (pw.selected) {
                            ret.selectedSize += pw.getSize();
                        }
                        ret.paths.add(pw);
                    }
                }
            }
            finally {
                if (timeCtx != null) {
                    timeCtx.close();
                }
            }
        }
        Collections.sort(ret.paths, new Comparator<FSPathWithSelected>(){

            @Override
            public int compare(FSPathWithSelected a, FSPathWithSelected b) {
                return StringUtils.defaultIfBlank((String)a.path(), (String)"").compareTo(StringUtils.defaultIfBlank((String)b.path(), (String)""));
            }
        });
        return ret;
    }

    public void expandSelectionRulesInPlace(AuthCtx authCtx, AbstractFSDatasetHandler.AbstractFSConfig config, String projectKey) throws Exception {
        this.expandSelectionRulesInPlaceInternal(authCtx, projectKey, config.filesSelectionRules, config.variablesExpansionLoopConfig, "cannot expand file selection rules");
    }

    private void expandSelectionRulesInPlaceInternal(AuthCtx authCtx, String projectKey, FilesSelectionRules rules, VariablesExpansionLoopConfig veLoopConfig, String errorMessage) throws Exception {
        JsonObject jo = VariablesExpansionLoopItemsIterable.firstIterationOnlyFailIfNone(authCtx, projectKey, veLoopConfig, String.format("Driving dataset is empty, %s", errorMessage));
        try (AutoCloseable ignored = DynamicLevelsStack.withLevel(jo);){
            VariablesContext variablesContext = this.variablesService.getForProjectAndUser(authCtx, projectKey);
            FSEnumerationSettings.expandSelectionRulesInPlace((FilesSelectionRules)rules, (VariablesContext)variablesContext);
            logger.trace((Object)("Variable-expanded selection rules: " + JSON.json((Object)rules)));
        }
    }

    public FSBrowsePath browse(AuthCtx authCtx, String type, AbstractFSDatasetHandler.AbstractFSConfig config, String rawPath, String projectKey, Map<String, String> contextVars, FSProvider.FSBrowseStrategy strategy) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        FSBrowsePath ret;
        String path = rawPath;
        if (StringUtils.isBlank((String)path)) {
            path = "/";
        } else {
            VariablesContext variablesContext = this.variablesService.getForProjectAndUserLogin(projectKey, authCtx);
            for (Map.Entry<String, String> e : contextVars.entrySet()) {
                variablesContext.add(e.getKey(), e.getValue());
            }
            path = variablesContext.expand(path);
        }
        logger.info((Object)("Browse path prepared : " + path));
        FSProviderConnectionFactory connectionFactory = new FSProviderConnectionFactory();
        DSSConnection connection = connectionFactory.getConnectionForProvider(type, authCtx, config, "provider of type " + type);
        String providerRoot = path.startsWith("/") ? "/" : "";
        logger.info((Object)("Use providerRoot '" + providerRoot + "'"));
        try (FSProvider provider = FSProviderFactory.getProvider(type, authCtx, projectKey, config, providerRoot, connection);){
            ret = provider.browse(path, strategy);
        }
        logger.info((Object)("Browse done, have " + ret.children.size() + " items"));
        Collections.sort(ret.children, new Comparator<FSBrowsePath>(){

            @Override
            public int compare(FSBrowsePath o1, FSBrowsePath o2) {
                if (o1.directory && !o2.directory) {
                    return -1;
                }
                if (o2.directory && !o1.directory) {
                    return 1;
                }
                return o1.name.toLowerCase().compareTo(o2.name.toLowerCase());
            }
        });
        return ret;
    }

    public Map<String, String> testConnection(AuthCtx authCtx, String type, AbstractFSDatasetHandler.AbstractFSConfig config, boolean listBuckets) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (StringUtils.isBlank((String)config.connection)) {
            throw new IllegalArgumentException("No connection set");
        }
        FSProviderConnectionFactory connectionFactory = new FSProviderConnectionFactory();
        DSSConnection connection = connectionFactory.getConnectionForProvider(type, authCtx, config, "provider of type " + type);
        try (FSTestProvider testProvider = FSProviderFactory.getTestProvider(authCtx, type, config, connection);){
            Map<String, String> map = testProvider.test(listBuckets);
            return map;
        }
    }

    public static interface BrowsableHandler {
        public FSBrowsePath browse(String var1) throws IOException, InterruptedException, DKUSecurityException, CodedException;
    }

    public static class FSListFilesResult {
        public int totalFiles;
        public int selectedFiles;
        public long totalSize;
        public long selectedSize;
        public List<FSPathWithSelected> paths = new ArrayList<FSPathWithSelected>();
    }
}

