/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;

public class CommitMentionEvent
extends BackendEvent
implements UserEvent,
ProjectEvent,
EnrichmentService.Enrichable,
EventWithHumanReadableString {
    public static final String NAME = "commit-mention";
    public final String message;
    public final String author;
    public final String projectKey;
    public final ITaggingService.TaggableType objectType;
    public final String objectId;
    public final String mentionedUser;
    public JsonObject details;

    public CommitMentionEvent(String message, String author, String projectKey, String mentionedUser) {
        this.message = message;
        this.author = author;
        this.projectKey = projectKey;
        this.objectType = StringUtils.isNotBlank((String)projectKey) ? ITaggingService.TaggableType.PROJECT : null;
        this.objectId = StringUtils.isNotBlank((String)projectKey) ? projectKey : null;
        this.mentionedUser = mentionedUser;
        this.details = new JsonObject();
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getUserLogin() {
        return this.mentionedUser;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return this.objectType;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public String getWorkspaceKey() {
        return null;
    }

    @Override
    public JsonObject getDetails() {
        if (this.details == null) {
            this.details = new JsonObject();
        }
        return this.details;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        return this.getSummaryString(markup) + markup.text(": " + this.message);
    }

    public String getSummaryString(MarkupFormatter markup) {
        String authorDisplayName = this.details.has("authorDisplayName") ? this.details.get("authorDisplayName").getAsString() : this.author;
        String ret = markup.user(this.author, authorDisplayName) + markup.text(" mentioned you in a commit message");
        if (this.projectKey != null) {
            ret = ret + markup.text("(project: " + this.projectKey + ")");
        }
        return ret;
    }
}

