/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.digest;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.EmailNotificationsGatherer;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesInternalDB;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationsDigestsService {
    private static final long TIME_DELTA = 86400000L;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TimelinesInternalDB timelinesDB;
    @Autowired
    private InterestsInternalDB interestsDB;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private EnrichmentService enrichmentService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.notifications.digest");

    public void sendAll() throws Exception {
        long since = System.currentTimeMillis() - 86400000L;
        Map<String, List<TimelineItem>> data = this.getDigestData(since);
        if (data.keySet().isEmpty()) {
            logger.info((Object)"Nothing to send in the digest");
        }
        for (String user : data.keySet()) {
            try {
                this.sendToUser(user, data.get(user));
            }
            catch (Exception e) {
                logger.info((Object)"Failed to send digest e-mail", (Throwable)e);
            }
        }
    }

    private Map<String, List<TimelineItem>> getDigestData(long since) throws Exception {
        List<String> projects;
        HashMap<String, List<TimelineItem>> ret = new HashMap<String, List<TimelineItem>>();
        try (Transaction t = this.transactionService.beginRead();){
            projects = this.projectsService.listKeys();
        }
        Map<String, Set<TaggableObjectsService.TaggableObjectRef>> watches = this.interestsDB.getAllWatchesByUser();
        Map<String, List<String>> deepWatches = this.interestsDB.getAllDeepWatches();
        Set<String> users = watches.keySet();
        Map<TaggableObjectsService.TaggableObjectRef, List<TimelineItem>> items = this.timelinesDB.getRecentTimelineItems(projects, since);
        for (Map.Entry<TaggableObjectsService.TaggableObjectRef, List<TimelineItem>> e : items.entrySet()) {
            TaggableObjectsService.TaggableObjectRef tor = e.getKey();
            for (String user : users) {
                if (!watches.get(user).contains(tor) && !deepWatches.containsKey(tor.projectKey)) continue;
                if (!ret.containsKey(user)) {
                    ret.put(user, new ArrayList());
                }
                ((List)ret.get(user)).addAll((Collection)e.getValue());
            }
        }
        return ret;
    }

    private void sendToUser(String user, List<TimelineItem> tis) throws Exception {
        PublicUser pu;
        UserSettingsService.DigestSettings params = this.getUserSettings(user);
        if (!params.enabled) {
            logger.info((Object)("Daily digests are disabled for user " + user + ", not sending"));
            return;
        }
        try (Transaction t = this.transactionService.beginRead();){
            pu = this.usersService.getPublicUser(user);
        }
        if (pu.email == null) {
            return;
        }
        String body = this.makeBody(pu, tis);
        logger.info((Object)("Send daily digest to " + user));
        EmailNotificationsSender sender = new EmailNotificationsSender();
        sender.sendToUser(pu.email, (UserSettingsService.EmailNotificationsSettings)params, body);
    }

    private String makeBody(PublicUser publicUser, List<TimelineItem> items) throws Exception {
        File templateFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"notifications", "notifications-email.ftl"});
        TemplatedContent templatedContent = new TemplatedContent();
        VariableLookup lookup = new VariableLookup();
        lookup.addVariable("username", publicUser.displayName);
        EmailNotificationsGatherer notificationsGatherer = new EmailNotificationsGatherer();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authCtxCreationService.create(publicUser.login);
            GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsService.read();
            lookup.addVariable("studioExternalUrl", settings.studioExternalUrl);
            lookup.addVariable("dssInstanceName", settings.nodeName);
            for (TimelineItem ti : items) {
                SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ti.getTaggableType(), ti.getObjectId());
                if (!this.projectsService.hasDashboardPermission(authCtx, smartObjectRef, ti.getProjectKey(), SerializedProject.ReaderAuthorization.Mode.READ)) continue;
                this.enrichmentService.enrich(ti);
                notificationsGatherer.add(ti);
            }
        }
        EmailNotificationsGatherer.GroupedNotifications groupedItems = notificationsGatherer.gather();
        logger.info((Object)"GroupedNotifications");
        logger.info((Object)JSON.pretty((Object)groupedItems));
        logger.info((Object)"-- end GroupedNotifications");
        lookup.addVariable("title", "Activity yesterday");
        lookup.addVariable("intro", "Here is a summary of the instance activity in the past 24 hours");
        lookup.addVariable("items", groupedItems);
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(lookup).buildMessage(templatedContent, templateFile);
        return expandedTemplate.message;
    }

    private UserSettingsService.DigestSettings getUserSettings(String login) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            UserSettingsService.UserSettings settings = this.userSettingsService.getForUser(login);
            if (settings != null) {
                UserSettingsService.DigestSettings digestSettings = settings.digests;
                return digestSettings;
            }
            UserSettingsService.DigestSettings digestSettings = new UserSettingsService.DigestSettings();
            return digestSettings;
        }
    }
}

