/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.server.notifications.emails.PluginRequestEmailBuilder;
import com.dataiku.dip.server.notifications.emails.PluginRequestGrantedEmailBuilder;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PluginRequestEmailSendService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private RequestsService requestsService;
    @Autowired
    private UsersService usersService;
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.plugin.request.granted");

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init plugin request grants mail service");
        this.pubSubService.subscribe("plugin-request-granted", evt -> {
            UserSettingsService.UserSettings userSettings;
            String toUser = evt.getUserLogin();
            try (Transaction tx = this.transactionService.beginRead();){
                UsersService.UIUser user = this.usersService.getUserOrNull_NoLeak(toUser);
                if (user == null || !user.enabled.booleanValue()) {
                    return;
                }
                userSettings = this.userSettingsService.getForUser(toUser);
            }
            PluginRequestGrantedEmailBuilder emailBuilder = new PluginRequestGrantedEmailBuilder();
            if (userSettings.grantedPluginRequestEmails.enabled) {
                try {
                    emailBuilder.sendToUser(evt, toUser);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to send email to " + toUser + " for granted plugin request on " + evt.getObjectId()), (Throwable)e);
                }
            }
        });
        this.pubSubService.subscribe("plugin-request", evt -> {
            List<String> targetUsers = this.requestsService.getRequestTargets_NT(Request.RequestType.INSTALL_PLUGIN, Request.RequestObjectType.PLUGIN, evt.getObjectId());
            PluginRequestEmailBuilder emailBuilder = new PluginRequestEmailBuilder();
            for (String toUser : targetUsers) {
                UserSettingsService.UserSettings userSettings;
                try (Transaction ignored = this.transactionService.beginRead();){
                    userSettings = this.userSettingsService.getForUser(toUser);
                }
                if (!userSettings.pluginRequestEmails.enabled) continue;
                try {
                    emailBuilder.sendToUser(evt, toUser);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to send email to " + toUser + " for plugin request on " + evt.getObjectId()), (Throwable)e);
                }
            }
        });
        logger.debug((Object)"Done init plugin request grants mail service");
    }
}

