/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeMeta;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeMeta;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeMeta;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeMeta;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetSelectionToMemTable;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.SingleThreadPusherToMemTable;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.llm.evaluation.CustomMetricsService;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.hive.HiveQLQueryRecipeUtils;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeStatusComputer;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeStatusComputer;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.BasicRecipeConsistencyChecker;
import com.dataiku.dip.recipes.consistency.MiscStuffChecker;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.nlp.llm_evaluation.LLMEvaluationRecipePayloadParams;
import com.dataiku.dip.recipes.services.RecipeIOChangeService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.crecipes.sync.CSyncRecipeMeta;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RecipesTestController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private GenericRecipesValidationService genericService;
    @Autowired
    private ExecutionPlanService executionPlanService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private RecipeIOChangeService ioChangeService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private StreamingEndpointService streamingEndpointService;
    @Autowired
    private CustomMetricsService customMetricsService;
    static Logger logger = Logger.getLogger((String)"dku.flow.recipes");

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/basic-resync-schema"})
    public void resyncSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeData) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            Schema copySchemaFrom;
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
            if (sr.overrideTable != null) {
                sr = (SerializedRecipe)sr.overrideTable.overrideObject(this.variablesService.getForProject(projectKey), sr, sr.getClass());
            }
            if (!(SyncRecipeMeta.META.getType().equals(sr.type) || SamplingRecipeMeta.META.getType().equals(sr.type) || SplitRecipeMeta.META.getType().equals(sr.type) || CSyncRecipeMeta.META.getType().equals(sr.type))) {
                throw ErrorContext.iaef((String)"Recipe %s does not support basic schema resync.", (Object)sr.name, (Object[])new Object[0]);
            }
            SerializedRecipe.RecipeInput i0 = sr.getSingleInput("main");
            DatasetLocUtils.DatasetLoc iloc = DatasetLocUtils.resolveSmart(projectKey, i0.ref);
            StreamingEndpoint se = this.streamingEndpointService.getOrNull(iloc);
            Dataset ds = this.datasetAccessService.getOrNull(iloc);
            if (se != null) {
                copySchemaFrom = se.schema;
            } else if (ds != null) {
                copySchemaFrom = ds.getSchema();
            } else {
                throw new IllegalArgumentException("Unable to find input " + iloc.getFullName() + " : not a streaming endpoint nor a dataset");
            }
            ArrayList<DatasetLocUtils.DatasetLoc> locs = new ArrayList<DatasetLocUtils.DatasetLoc>();
            ArrayList<TaggableObjectsService.TaggableObject> result = new ArrayList<TaggableObjectsService.TaggableObject>();
            for (SerializedRecipe.RecipeOutput recipeOutput : sr.getOutputsForRole("main")) {
                DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, recipeOutput.ref);
                locs.add(loc);
                StreamingEndpoint streamingEndpoint = this.streamingEndpointService.getOrNull(loc);
                Dataset copySchemaTo = this.datasetAccessService.getOrNull(loc);
                if (streamingEndpoint != null) {
                    streamingEndpoint.schema = copySchemaFrom;
                    this.streamingEndpointService.save(streamingEndpoint, false);
                    result.add(streamingEndpoint);
                    continue;
                }
                if (copySchemaTo != null) {
                    this.projectsService.checkPerm(req, copySchemaTo.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                    ManagedDatasetsHelper.copySchema(t.getUser(), copySchemaFrom, copySchemaTo);
                    this.datasetSaveService.save(copySchemaTo.getProjectKey(), copySchemaTo.getName(), copySchemaTo.serialize(), t.getUser());
                    result.add(copySchemaTo.serialize());
                    continue;
                }
                logger.warn((Object)"Output is not a dataset nor a streaming endpoint");
            }
            RecipesTestController.writeJSON((HttpServletResponse)resp, result);
            t.commit("Auto-Resync of schema for recipe" + sr.projectKey + "." + sr.name + " (type " + sr.type + ")");
            for (AnyLoc anyLoc : locs) {
                this.auditTrailService.generic("dataset-save-schema").with("projectKey", anyLoc.getProjectKey()).with("datasetName", anyLoc.getId()).emit();
            }
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/basic-drop-schema"})
    public void dropSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeData) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
            if (sr.overrideTable != null) {
                sr = (SerializedRecipe)sr.overrideTable.overrideObject(this.variablesService.getForProject(projectKey), sr, sr.getClass());
            }
            if (!sr.type.equals(PivotRecipeMeta.META.getType())) {
                throw ErrorContext.iaef((String)"Recipe %s does not support basic schema drop.", (Object)sr.name, (Object[])new Object[0]);
            }
            ArrayList<DatasetLocUtils.DatasetLoc> locs = new ArrayList<DatasetLocUtils.DatasetLoc>();
            ArrayList<SerializedDataset> result = new ArrayList<SerializedDataset>();
            for (SerializedRecipe.RecipeOutput recipeOutput : sr.getOutputsForRole("main")) {
                DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, recipeOutput.ref);
                locs.add(loc);
                Dataset copySchemaTo = this.datasetAccessService.getMandatory(loc);
                this.projectsService.checkPerm(req, copySchemaTo.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                copySchemaTo.setSchema(new Schema());
                this.datasetSaveService.save(copySchemaTo.getProjectKey(), copySchemaTo.getName(), copySchemaTo.serialize(), t.getUser());
                result.add(copySchemaTo.serialize());
            }
            RecipesTestController.writeJSON((HttpServletResponse)resp, result);
            t.commit("Drop output schema for recipe" + sr.projectKey + "." + sr.name + " (type " + sr.type + ")");
            for (AnyLoc anyLoc : locs) {
                this.auditTrailService.generic("dataset-save-schema").with("projectKey", anyLoc.getProjectKey()).with("datasetName", anyLoc.getId()).emit();
            }
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/pivot/get-dataset-modalities"})
    public void getPivotModalitiesFromDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetSmartName, @RequestParam(value="pivot") String pivotData) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetSmartName);
        }
        PivotElement pivot = (PivotElement)JSON.parse((String)pivotData, PivotElement.class);
        DatasetSelectionToMemTable selection = new DatasetSelectionToMemTable();
        selection.samplingMethod = SamplingParam.SamplingMethod.HEAD_SEQUENTIAL;
        selection.maxRecords = 100000L;
        MemTable table = new MemTable();
        try {
            SingleThreadPusherToMemTable pusher = new SingleThreadPusherToMemTable(authCtx, dataset, table);
            pusher.setDatasetSelection(selection);
            pusher.push();
        }
        catch (MemTableAppendingOutput.MemTableSizeLimitReachedException e) {
            logger.warn((Object)("Dataset is too large, more than " + selection.maxRecords + " rows"), (Throwable)e);
        }
        logger.info((Object)("Done extracting sample, got " + table.nrows() + " rows"));
        HashSet modalities = Sets.newHashSet();
        for (MemRow row : table.rows) {
            ArrayList keyValues = Lists.newArrayList();
            for (String key : pivot.keyColumns) {
                keyValues.add(row.get(table.column(key)));
            }
            modalities.add(keyValues);
        }
        pivot.explicitValues = Lists.newArrayList((Iterable)modalities);
        RecipesTestController.writeJSON((HttpServletResponse)resp, (Object)pivot);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/generic/validate"})
    public void validateGeneric(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipe) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            SerializedRecipe sa = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
            this.projectsService.checkPerm(req, sa.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            new BasicRecipeConsistencyChecker(sa).check(ret);
            new MiscStuffChecker(sa).check(ret, this.authService.getMandatoryUser(req), sa.projectKey);
            RecipesTestController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/sql-query/get-execution-plan"})
    public void executionPlan(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipe, @RequestParam String script, @RequestParam(required=false) String targetPartition) throws Exception {
        SQLQueryRecipeStatusComputer.SQLQueryRecipeStatus status;
        AuthCtx authCtx;
        SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, sr.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        RecipeStatusComputer computer = RecipeRegistry.getMeta(sr).buildStatusComputer(sr, script);
        if (computer == null) {
            throw new IllegalArgumentException("Recipes of type " + sr.type + " do not have a computable status");
        }
        logger.info((Object)("Computing status of recipe " + sr.name + " on computer " + String.valueOf(computer)));
        try {
            SQLQueryRecipeStatusComputer.SQLQueryRecipeStatusRequest request = new SQLQueryRecipeStatusComputer.SQLQueryRecipeStatusRequest();
            request.targetPartitionSpec = (String)StringUtils.defaultIfBlank((CharSequence)targetPartition, null);
            status = (SQLQueryRecipeStatusComputer.SQLQueryRecipeStatus)computer.getFullStatus_NT(authCtx, JSON.json((Object)request));
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to compute recipe status", e);
            status = new SQLQueryRecipeStatusComputer.SQLQueryRecipeStatus();
            status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to validate recipe: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        SQLQueryRecipeExecutionPlanResults results = new SQLQueryRecipeExecutionPlanResults();
        results.validationResult = status;
        if (!status.gatherAllMessages().anyFatal()) {
            Callable<ExecutionPlanService.ExecutionPlan> executionPlanCallable = this.executionPlanService.getSqlExecutionPlan(sr, status.substitutedCode != null ? status.substitutedCode : script, authCtx);
            results.executionPlan = executionPlanCallable.call();
        }
        RecipesTestController.writeJSON((HttpServletResponse)resp, (Object)results);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/sql-query/run"})
    public void run(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipe, @RequestParam String script, @RequestParam(required=false) String targetPartition) throws Exception {
        AuthCtx liu = null;
        SerializedRecipe sa = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, sa.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SQLQueryValidateAndRunThread ft = new SQLQueryValidateAndRunThread(liu, sa, script, targetPartition);
        RecipesTestController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 200L, new TypeToken<FutureResponse<SQLQueryRecipeStatusComputer.SQLQueryRecipeStatus>>(){}));
    }

    public static FuturePayload buildRunFuturePayload(SerializedRecipe recipe) {
        FuturePayload fp = new FuturePayload();
        fp.action = "validate_and_run_sql";
        fp.targets.add(DSSFuturePayloadUtils.forTaggableObject(recipe));
        fp.displayName = "Validate and run query of recipe " + recipe.name;
        return fp;
    }

    public static FuturePayload buildExplainFuturePayload(SerializedRecipe recipe) {
        FuturePayload fp = new FuturePayload();
        fp.action = "explain_sql";
        fp.targets.add(DSSFuturePayloadUtils.forTaggableObject(recipe));
        fp.displayName = "Explain query of recipe " + recipe.name;
        return fp;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/impala/get-execution-plan"})
    public void executionPlanImpala(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipe, @RequestParam String script, @RequestParam(required=false) String targetPartition) throws Exception {
        AuthCtx liu = null;
        SerializedRecipe sa = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, sa.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ImpalaQueryExplainPlanThread ft = new ImpalaQueryExplainPlanThread(liu, sa, script);
        RecipesTestController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 200L, new TypeToken<FutureResponse<ImpalaRecipeExecutionPlanResults>>(){}));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/impala/run"})
    public void runImpala(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipe, @RequestParam String script, @RequestParam(required=false) String targetPartition) throws Exception {
        AuthCtx liu = null;
        SerializedRecipe sa = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, sa.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        ImpalaQueryValidationAndRunThread ft = new ImpalaQueryValidationAndRunThread(liu, sa, script, targetPartition);
        RecipesTestController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 200L, new TypeToken<FutureResponse<ImpalaRecipeStatusComputer.ImpalaRecipeStatus>>(){}));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/hive/check-impala-convertibility"})
    public void checkImpalaConvertibility(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeData, @RequestParam String scriptData, @RequestParam(required=false) String targetPartition) throws Exception {
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            liu = this.authService.getMandatoryUser(req);
        }
        SerializedRecipe sa = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
        sa.projectKey = projectKey;
        ImpalaConvertibility results = new ImpalaConvertibility();
        results.sql = scriptData;
        sa.type = "impala";
        try {
            results.executionPlan = this.executionPlanService.getImpalaExecutionPlan(sa, scriptData, liu);
            results.runsOnImpala = true;
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to check Impala convertibility", (Throwable)ex);
            results.runsOnImpala = false;
            results.impalaImpossibilityReason = ex.getMessage();
        }
        RecipesTestController.writeJSON((HttpServletResponse)resp, (Object)results);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/impala/check-full-sql-availability"})
    public void checkImpalaFullSqlAvailability(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedRecipe sa = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
            sa.projectKey = projectKey;
            FullSqlAvailability ret = new FullSqlAvailability();
            try {
                String sourceConnection = HiveQLQueryRecipeUtils.getMainConnection(authCtx, sa);
                SerializedRecipe.RecipeOutput output = sa.getSingleOutput("main");
                if (output != null) {
                    Dataset outputDataset = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveSmart(sa.projectKey, output.ref));
                    ret.applicable = true;
                    ret.reason = HiveQLQueryRecipeUtils.runsInSQLMode(authCtx, sourceConnection, outputDataset, "select * from some_table");
                    ret.available = ret.reason == null;
                } else {
                    ret.reason = "no output configured";
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to check full SQL availability", (Throwable)ex);
                ret.reason = ex.getMessage();
            }
            RecipesTestController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/pdep-test"})
    public void testPdep(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipeData, @RequestParam String pdepInputRef, @RequestParam String pdepData, @RequestParam(required=false) String targetPartition) throws Exception {
        List<GenericRecipesValidationService.PdepTestEntry> entries;
        GenericRecipesValidationService.PdepTestResult ret = new GenericRecipesValidationService.PdepTestResult();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            SerializedRecipe sa = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
            this.projectsService.checkPerm(req, sa.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedRecipe.SDep dep = (SerializedRecipe.SDep)JSON.parse((String)pdepData, SerializedRecipe.SDep.class);
            if ("custom_python".equals(dep.func)) {
                AuthCtx liu = this.authService.getMandatoryUser(req);
                liu.failIfNoUnsafeCode("test a custom dependency");
            }
            ret.validationResult = new GenericRecipesValidationService.RecipeValidationResult();
            new BasicRecipeConsistencyChecker(sa).check(ret.validationResult);
            if (ret.validationResult.messages.size() > 0) {
                RecipesTestController.writeJSON((HttpServletResponse)resp, (Object)ret);
                return;
            }
            entries = this.genericService.prepareTestPdep(authCtx, sa, pdepInputRef, dep, ret);
        }
        if (entries != null) {
            this.genericService.testPdep_NT(ret, entries);
        }
        RecipesTestController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/get-io-change-result"})
    public void getIOChangeResult(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeAndPayloadBefore, @RequestParam String recipeAndPayloadAfter) throws Exception {
        SerializedRecipe.SerializedRecipeAndPayload before = (SerializedRecipe.SerializedRecipeAndPayload)JSON.parse((String)recipeAndPayloadBefore, SerializedRecipe.SerializedRecipeAndPayload.class);
        SerializedRecipe.SerializedRecipeAndPayload after = (SerializedRecipe.SerializedRecipeAndPayload)JSON.parse((String)recipeAndPayloadAfter, SerializedRecipe.SerializedRecipeAndPayload.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(liu, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        RecipesTestController.writeJSON((HttpServletResponse)resp, (Object)this.ioChangeService.getChangeResponse_NT(before, after, projectKey));
    }

    @RequestMapping(value={"/api/flow/recipes/run-from-recipe-ui"})
    @ResponseBody
    public GenericRecipesValidationService.RunRecipeFromUIResult runFromRecipeUI(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeName, @RequestParam String mode, @RequestParam String buildPartitions) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.genericService.runRecipeFromUI_NT(authCtx, projectKey, recipeName, GenericRecipesValidationService.RunRecipeFromUIMode.valueOf(mode), (JsonObject)JSON.parse((String)buildPartitions, JsonObject.class));
    }

    @AuditedCall(value={"msgType", "test-custom-metric", "projectKey", "${projectKey}", "referenceId", "${referenceId}", "currentId", "${currentId}"})
    @RequestMapping(value={"/api/flow/recipes/test-custom-metric"})
    public void testCustomMetric(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipe, @RequestParam String recipeDesc, @RequestParam int metricIndex, @RequestParam SerializedDataset serializedInputDataset) throws Exception {
        SerializedRecipe serializedRecipe = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
        LLMEvaluationRecipePayloadParams recipeParams = (LLMEvaluationRecipePayloadParams)JSON.parse((String)recipeDesc, LLMEvaluationRecipePayloadParams.class);
        DSSAuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        RecipesTestController.writeJSON((HttpServletResponse)resp, this.customMetricsService.startTest(authCtx, projectKey, serializedRecipe, recipeParams, metricIndex, serializedInputDataset));
    }

    static class SQLQueryRecipeExecutionPlanResults {
        ExecutionPlanService.ExecutionPlan executionPlan;
        SQLQueryRecipeStatusComputer.SQLQueryRecipeStatus validationResult;

        SQLQueryRecipeExecutionPlanResults() {
        }
    }

    public class SQLQueryValidateAndRunThread
    extends SimpleFutureThread<SQLQueryRecipeStatusComputer.SQLQueryRecipeStatus> {
        private final SerializedRecipe recipe;
        private final String payload;
        private final String targetPartition;
        private final FuturePayload futurePayload;

        public SQLQueryValidateAndRunThread(AuthCtx owner, SerializedRecipe recipe, String payload, String targetPartition) {
            super(owner);
            this.recipe = recipe;
            this.payload = payload;
            this.targetPartition = targetPartition;
            this.futurePayload = RecipesTestController.buildRunFuturePayload(recipe);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        protected SQLQueryRecipeStatusComputer.SQLQueryRecipeStatus compute() throws Exception {
            try {
                SQLQueryRecipeStatusComputer.SQLQueryRecipeStatus status;
                SQLQueryRecipeStatusComputer.SQLQueryRecipeStatusRequest req = new SQLQueryRecipeStatusComputer.SQLQueryRecipeStatusRequest();
                req.run = true;
                req.targetPartitionSpec = this.targetPartition;
                RecipeStatusComputer computer = RecipeRegistry.getMeta(this.recipe).buildStatusComputer(this.recipe, this.payload);
                try {
                    status = (SQLQueryRecipeStatusComputer.SQLQueryRecipeStatus)computer.getFullStatus_NT(this.owner, JSON.json((Object)req));
                }
                catch (Throwable e) {
                    logger.error((Object)"Failed to compute recipe status", e);
                    status = new SQLQueryRecipeStatusComputer.SQLQueryRecipeStatus();
                    status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Run failed: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
                RecipesTestController.this.auditTrailService.generic("sql-recipe-test-run").with("projectKey", this.recipe.projectKey).with("recipeName", this.recipe.name).with("sql", this.payload).emit();
                return status;
            }
            catch (Exception e) {
                RecipesTestController.this.auditTrailService.failure("sql-recipe-test-run", (Throwable)e).with("projectKey", this.recipe.projectKey).with("recipeName", this.recipe.name).emit();
                throw e;
            }
        }
    }

    public class ImpalaQueryExplainPlanThread
    extends SimpleFutureThread<ImpalaRecipeExecutionPlanResults> {
        private final SerializedRecipe recipe;
        private final String payload;
        private final FuturePayload futurePayload;

        ImpalaQueryExplainPlanThread(AuthCtx user, SerializedRecipe recipe, String payload) {
            super(user);
            this.recipe = recipe;
            this.payload = payload;
            this.futurePayload = RecipesTestController.buildExplainFuturePayload(recipe);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public ImpalaRecipeExecutionPlanResults compute() throws Exception {
            ImpalaRecipeStatusComputer.ImpalaRecipeStatus status;
            ImpalaRecipeExecutionPlanResults results = new ImpalaRecipeExecutionPlanResults();
            ImpalaRecipeStatusComputer computer = new ImpalaRecipeStatusComputer(this.recipe, this.payload);
            try {
                status = (ImpalaRecipeStatusComputer.ImpalaRecipeStatus)computer.getFullStatus_NT(this.owner, null);
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to compute recipe status", e);
                status = new ImpalaRecipeStatusComputer.ImpalaRecipeStatus();
                status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to validate recipe: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
            results.validationResult = status;
            results.executionPlan = RecipesTestController.this.executionPlanService.getImpalaExecutionPlan(this.recipe, this.payload, this.owner);
            return results;
        }
    }

    public class ImpalaQueryValidationAndRunThread
    extends SimpleFutureThread<ImpalaRecipeStatusComputer.ImpalaRecipeStatus> {
        private final SerializedRecipe recipe;
        private final String payload;
        private final String targetPartition;
        private final FuturePayload futurePayload;

        ImpalaQueryValidationAndRunThread(AuthCtx user, SerializedRecipe recipe, String payload, String targetPartition) {
            super(user);
            this.recipe = recipe;
            this.payload = payload;
            this.targetPartition = targetPartition;
            this.futurePayload = RecipesTestController.buildRunFuturePayload(recipe);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public ImpalaRecipeStatusComputer.ImpalaRecipeStatus compute() {
            ImpalaRecipeStatusComputer.ImpalaRecipeStatusRequest req = new ImpalaRecipeStatusComputer.ImpalaRecipeStatusRequest();
            req.run = true;
            req.targetPartitionSpec = this.targetPartition;
            ImpalaRecipeStatusComputer computer = new ImpalaRecipeStatusComputer(this.recipe, this.payload);
            try {
                ImpalaRecipeStatusComputer.ImpalaRecipeStatus status = (ImpalaRecipeStatusComputer.ImpalaRecipeStatus)computer.getFullStatus_NT(this.owner, JSON.json((Object)req));
                RecipesTestController.this.auditTrailService.generic("impala-recipe-test-run").with("projectKey", this.recipe.projectKey).with("recipeName", this.recipe.name).with("sql", this.payload).emit();
                return status;
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to compute recipe status", e);
                ImpalaRecipeStatusComputer.ImpalaRecipeStatus status = new ImpalaRecipeStatusComputer.ImpalaRecipeStatus();
                status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Run failed: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                RecipesTestController.this.auditTrailService.failure("impala-recipe-test-run", e).with("projectKey", this.recipe.projectKey).with("recipeName", this.recipe.name).emit();
                return status;
            }
        }
    }

    public static class ImpalaConvertibility {
        public boolean runsOnImpala;
        public String impalaImpossibilityReason;
        public String sql;
        public ExecutionPlanService.ExecutionPlan executionPlan;
    }

    public static class FullSqlAvailability {
        boolean available;
        boolean applicable;
        String reason;
    }

    static class ImpalaRecipeExecutionPlanResults {
        ExecutionPlanService.ExecutionPlan executionPlan;
        ImpalaRecipeStatusComputer.ImpalaRecipeStatus validationResult;

        ImpalaRecipeExecutionPlanResults() {
        }
    }
}

