/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.Params;
import java.io.IOException;

public class ProjectsUtils {
    public static SerializedProject getMandatoryUnsafe_AutoTXN(String projectKey) throws IOException {
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead();){
            SerializedProject serializedProject = ((ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class)).getMandatoryUnsafe(projectKey);
            return serializedProject;
        }
    }

    public static Params getProjectDKUPropertiesAsParamsWithSystemOverrideEvenIfProjectDoesNotExist_AutoTXN(String projectKey) {
        try {
            SerializedProject sp = ProjectsUtils.getMandatoryUnsafe_AutoTXN(projectKey);
            return sp.getDkuPropertiesAsParams(true);
        }
        catch (Exception e) {
            return DKUApp.getParams();
        }
    }
}

