/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.TransactionDebugInfo;
import com.dataiku.dip.transactions.exceptions.TransactionBadlyFailedError;
import com.dataiku.dip.transactions.exceptions.TransactionFailedException;
import com.dataiku.dip.transactions.fs.InMemoryFS;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.ProxiedReadWriteFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipReadFS;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.TransactionGitException;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.transactions.ifaces.UserEditable;
import com.dataiku.dip.utils.NotImplementedException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.intellij.lang.annotations.PrintFormat;

public class SingleWriteTransactionTransactionService
implements TransactionService {
    private final FakeTransaction theSingleTransaction = new FakeTransaction();
    private InMemoryFS imfs;
    private ZipReadFS localConfigArchiveFs;
    private AuthCtx user;
    private NativeFS localConfigFolderFs;
    private File zipArchive;
    private static Logger logger = Logger.getLogger((String)"dku.transactions.single");

    public SingleWriteTransactionTransactionService() throws IOException {
        File configFolder = new File(ApplicationConfigurator.getBaseFolderF(), "config");
        RWTransaction t = this.beginTheSingleTransactionOnDirectory(configFolder, null);
        TransactionContext.detach((TransactionRef)t);
    }

    public synchronized RWTransaction beginTheSingleTransactionOnArchive(File zipArchive, String rootDirectoryInArchive, AuthCtx usr) throws IOException {
        logger.info((Object)("New config root archive: " + String.valueOf(zipArchive)));
        TransactionContext.assertNoAttachedTransaction();
        this.closeResources();
        this.localConfigArchiveFs = new ZipReadFS(zipArchive);
        this.zipArchive = zipArchive;
        this.imfs = new InMemoryFS(this.localConfigArchiveFs.directoryView(rootDirectoryInArchive), false);
        this.user = usr;
        TransactionContext.attach((TransactionRef)this.theSingleTransaction);
        return this.theSingleTransaction;
    }

    public synchronized RWTransaction beginTheSingleTransactionOnDirectory(File rootDirectory, AuthCtx usr) throws IOException {
        logger.info((Object)("New config root directory: " + String.valueOf(rootDirectory)));
        TransactionContext.assertNoAttachedTransaction();
        this.closeResources();
        this.localConfigFolderFs = NativeFS.from((File)rootDirectory).build();
        this.imfs = new InMemoryFS((ReadOnlyFS)this.localConfigFolderFs, true);
        this.user = usr;
        TransactionContext.attach((TransactionRef)this.theSingleTransaction);
        return this.theSingleTransaction;
    }

    private synchronized void closeResources() throws IOException {
        this.localConfigFolderFs = null;
        this.imfs = null;
        this.user = null;
        this.zipArchive = null;
        if (this.localConfigArchiveFs != null) {
            this.localConfigArchiveFs.close();
            this.localConfigArchiveFs = null;
        }
    }

    public void stashTheSingleTransaction() {
        TransactionContext.assertAttachedTransaction();
        TransactionContext.detach((TransactionRef)this.theSingleTransaction);
    }

    public void unstashTheSingleTransaction() {
        TransactionContext.assertNoAttachedTransaction();
        TransactionContext.attach((TransactionRef)this.theSingleTransaction);
    }

    public RWTransaction beginWriteForUI(HttpServletRequest req, boolean checkXSRF) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteForUI(HttpServletRequest req) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteAsLoggedInUser(AuthCtx usr, boolean commitable) {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteForAPI(HttpServletRequest req) throws IOException, DKUSecurityException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteForTicket(HttpServletRequest req) throws IOException, DKUSecurityException {
        throw new NotImplementedException();
    }

    public void clearCache() {
        this.invalidateCache(RelFile.root());
    }

    public void invalidateCache(RelFile file) {
    }

    public CachedReadFS getCache() {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteAsDSS(boolean committable) {
        TransactionContext.assertNoAttachedTransaction();
        TransactionContext.attach((TransactionRef)this.theSingleTransaction);
        return this.theSingleTransaction;
    }

    public synchronized Transaction beginRead(IsolationLevel isolationLevel, @Nullable String fakeStack) {
        TransactionContext.assertNoAttachedTransaction();
        TransactionContext.attach((TransactionRef)this.theSingleTransaction);
        return this.theSingleTransaction;
    }

    public synchronized File resolve(RelFile file) {
        if (this.zipArchive != null) {
            return new File(this.zipArchive, file.getFullPath());
        }
        if (this.localConfigFolderFs != null) {
            return this.localConfigFolderFs.resolve(file);
        }
        throw new RuntimeException("No folder nor archive");
    }

    public JGitManager getGitManager() {
        throw new NotImplementedException();
    }

    public void performDirectCommit(DSSCommitDef def) {
        throw new NotImplementedException();
    }

    public void flushPendingCommits(String projectKey) {
        throw new NotImplementedException();
    }

    private class FakeTransaction
    extends ProxiedReadWriteFS
    implements RWTransaction,
    UserEditable {
        private FakeTransaction() {
        }

        public boolean isAlive() {
            return true;
        }

        public void onPostCommit(Runnable callback) {
        }

        public void commit(String message, long gitCommitDelay, MinimalRWTransaction.TransactionGitCommitPolicy gitCommitPolicy) throws TransactionBadlyFailedError, TransactionFailedException, TransactionGitException {
            throw new NotImplementedException();
        }

        public void commit(String message) throws TransactionBadlyFailedError, TransactionFailedException, TransactionGitException {
            throw new NotImplementedException();
        }

        public void commitV(@PrintFormat String message, Object ... args) throws TransactionBadlyFailedError, TransactionFailedException, TransactionGitException {
            throw new NotImplementedException();
        }

        public void rollback() {
            throw new NotImplementedException();
        }

        public File resolve(RelFile file) {
            return SingleWriteTransactionTransactionService.this.resolve(file);
        }

        public AuthCtx getUser() {
            return SingleWriteTransactionTransactionService.this.user;
        }

        public void setUser(AuthCtx user) {
            throw new NotImplementedException();
        }

        protected ReadWriteFS getDelegateFS() {
            return SingleWriteTransactionTransactionService.this.imfs;
        }

        public void close() {
            if (TransactionContext.hasAttachedTransaction()) {
                TransactionContext.detach((TransactionRef)this);
            }
        }

        public TransactionDebugInfo getDebugInfo() {
            return new TransactionDebugInfo(null);
        }
    }

    public static interface DetransactionalizedCallable<T> {
        public T call_NT() throws Exception;
    }
}

