/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.coremodel.Checklist;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaggableObjectDiffService {
    public static final String ADDED_TAGS_PROPERTY = "addedTags";
    public static final String REMOVED_TAGS_PROPERTY = "removedTags";
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private AchievementsService achievementService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.collaboration.diff");

    public TaggableObjectsDiff diff(TaggableObjectsService.TaggableObject before, TaggableObjectsService.TaggableObject after, String user) {
        TaggableObjectsDiff diff = new TaggableObjectsDiff();
        try {
            if (after == null) {
                logger.errorV("Cannot compute diff to a null object", new Object[0]);
                return diff;
            }
            diff.objectType = after.getTaggableType();
            diff.projectKey = after.getProjectKey();
            diff.objectId = after.getId();
            diff.user = user;
            if (before == null) {
                diff.creation = true;
                return diff;
            }
            diff.oldName = before.getDisplayName();
            diff.newName = after.getDisplayName();
            diff.renamed = !StringUtils.equals((String)diff.oldName, (String)diff.newName);
            diff.descriptionEdited = !StringUtils.equals((String)before.description, (String)after.description);
            boolean bl = diff.shortDescEdited = !StringUtils.equals((String)before.shortDesc, (String)after.shortDesc);
            if (diff.shortDescEdited) {
                diff.newShortDesc = after.shortDesc;
            }
            diff.customFieldsEdited = !Objects.equals(before.customFields, after.customFields);
            diff.addedTags = TaggableObjectDiffService.computeAddedTags(before, after);
            diff.removedTags = TaggableObjectDiffService.computeRemovedTags(before, after);
            HashMap<String, Checklist> checklistIndexBefore = new HashMap<String, Checklist>();
            for (Checklist checklist : before.checklists.checklists) {
                checklistIndexBefore.put(checklist.id, checklist);
            }
            HashMap<String, Checklist> checklistIndexAfter = new HashMap<String, Checklist>();
            for (Checklist checklist : after.checklists.checklists) {
                checklistIndexAfter.put(checklist.id, checklist);
            }
            for (String id : Sets.union(checklistIndexBefore.keySet(), checklistIndexAfter.keySet())) {
                if (!checklistIndexBefore.containsKey(id)) {
                    Checklist cl = (Checklist)checklistIndexAfter.get(id);
                    diff.addedChecklists.add(cl.title);
                    for (Checklist.ChecklistItem task : cl.items) {
                        ++diff.totalTasks;
                        if (!task.done) continue;
                        ++diff.totalCompletedTasks;
                    }
                    continue;
                }
                if (!checklistIndexAfter.containsKey(id)) {
                    diff.removedChecklists.add(((Checklist)checklistIndexBefore.get((Object)id)).title);
                    continue;
                }
                Checklist b = (Checklist)checklistIndexBefore.get(id);
                Checklist a = (Checklist)checklistIndexAfter.get(id);
                assert (a != null);
                assert (b != null);
                HashMap<Long, Checklist.ChecklistItem> tasksIndexBefore = new HashMap<Long, Checklist.ChecklistItem>(b.items.size());
                HashMap<Long, Checklist.ChecklistItem> tasksIndexAfter = new HashMap<Long, Checklist.ChecklistItem>(a.items.size());
                for (Checklist.ChecklistItem task : b.items) {
                    tasksIndexBefore.put(task.createdOn, task);
                }
                for (Checklist.ChecklistItem task : a.items) {
                    tasksIndexAfter.put(task.createdOn, task);
                    ++diff.totalTasks;
                    if (!task.done) continue;
                    ++diff.totalCompletedTasks;
                }
                for (Long taskId : Sets.union(tasksIndexBefore.keySet(), tasksIndexAfter.keySet())) {
                    if (!tasksIndexBefore.containsKey(taskId)) {
                        diff.addedTasks.add(((Checklist.ChecklistItem)tasksIndexAfter.get((Object)taskId)).text);
                        continue;
                    }
                    if (!tasksIndexAfter.containsKey(taskId)) {
                        diff.removedTasks.add(((Checklist.ChecklistItem)tasksIndexBefore.get((Object)taskId)).text);
                        continue;
                    }
                    if (!((Checklist.ChecklistItem)tasksIndexBefore.get((Object)taskId)).done && ((Checklist.ChecklistItem)tasksIndexAfter.get((Object)taskId)).done) {
                        diff.justCompletedTasks.add(((Checklist.ChecklistItem)tasksIndexAfter.get((Object)taskId)).text);
                        continue;
                    }
                    if (!((Checklist.ChecklistItem)tasksIndexBefore.get((Object)taskId)).done || ((Checklist.ChecklistItem)tasksIndexAfter.get((Object)taskId)).done) continue;
                    diff.undoneTasks.add(((Checklist.ChecklistItem)tasksIndexBefore.get((Object)taskId)).text);
                }
            }
            boolean bl2 = diff.totalCompletedTasks == diff.totalTasks;
            diff.justCompletedAllObjectTasks = bl2 && diff.justCompletedTasks.size() > 0;
        }
        catch (Throwable t) {
            logger.errorV("Failed to compute object metadata diff %s (%s): %s", new Object[]{after.getFullId(), after.getTaggableType(), ExceptionUtils.getMessageWithCauses((Throwable)t)});
        }
        if (logger.isTraceEnabled()) {
            logger.traceV("Metadata diff on %s (%s): %s", new Object[]{after.getFullId(), after.getTaggableType(), JSON.pretty((Object)diff)});
        }
        return diff;
    }

    private static List<String> computeAddedTags(@Nonnull TaggableObjectsService.TaggableObject before, @Nonnull TaggableObjectsService.TaggableObject after) {
        List<Object> beforeTags = before.getTags() == null ? new ArrayList() : before.getTags();
        List<Object> afterTags = after.getTags() == null ? new ArrayList() : after.getTags();
        return afterTags.stream().filter(tag -> !beforeTags.contains(tag)).toList();
    }

    private static List<String> computeRemovedTags(@Nonnull TaggableObjectsService.TaggableObject before, @Nonnull TaggableObjectsService.TaggableObject after) {
        List<Object> beforeTags = before.getTags() == null ? new ArrayList() : before.getTags();
        List<Object> afterTags = after.getTags() == null ? new ArrayList() : after.getTags();
        return beforeTags.stream().filter(tag -> !afterTags.contains(tag)).toList();
    }

    public static void addTagEditInfoIfNeeded(TaggableObjectsService.TaggableObject before, TaggableObjectsService.TaggableObject after, JsonObject details) {
        List<String> removedTags;
        List<String> addedTags = TaggableObjectDiffService.computeAddedTags(before, after);
        if (!addedTags.isEmpty()) {
            details.add(ADDED_TAGS_PROPERTY, (JsonElement)JSON.gson().toJsonTree(addedTags).getAsJsonArray());
        }
        if (!(removedTags = TaggableObjectDiffService.computeRemovedTags(before, after)).isEmpty()) {
            details.add(REMOVED_TAGS_PROPERTY, (JsonElement)JSON.gson().toJsonTree(removedTags).getAsJsonArray());
        }
    }

    public void publishAfterTransaction(TaggableObjectsDiff diff) {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        logger.info((Object)("Publish diff" + JSON.pretty((Object)diff)));
        this.pubSub.publishAfterTransaction(TaggableObjectDiffService.buildTaggableObjectChangedEvent(diff));
        if (diff.metadataOtherThanTasksChanged()) {
            this.achievementService.win(t.getUser(), AchievementsService.AchievementId.TEAM_PLAYER);
        }
        if (diff.justCompletedAllObjectTasks) {
            this.achievementService.win(t.getUser(), AchievementsService.AchievementId.IT_HAD_TO_BE_DONE);
        }
    }

    public void publish(TaggableObjectsDiff diff, AuthCtx authCtx) {
        logger.info((Object)("Publish diff" + JSON.pretty((Object)diff)));
        this.pubSub.publish(TaggableObjectDiffService.buildTaggableObjectChangedEvent(diff));
        if (diff.metadataOtherThanTasksChanged()) {
            this.achievementService.win(authCtx, AchievementsService.AchievementId.TEAM_PLAYER);
        }
        if (diff.justCompletedAllObjectTasks) {
            this.achievementService.win(authCtx, AchievementsService.AchievementId.IT_HAD_TO_BE_DONE);
        }
    }

    private static TaggableObjectChangedEvent buildTaggableObjectChangedEvent(TaggableObjectsDiff diff) {
        TaggableObjectChangedEvent toce = new TaggableObjectChangedEvent(diff.objectType, diff.projectKey, diff.objectId, diff.user, TaggableObjectChangedEvent.ActionType.EDIT_COLLABORATIVE_METADATA);
        toce.details = diff.toEventDetails();
        toce.metadataDiff = diff;
        return toce;
    }

    public static List<String> getAddedTags(TaggableObjectChangedEvent event) {
        return TaggableObjectDiffService.getAsListOfString(JsonUtils.getArrayDefault(event.details, ADDED_TAGS_PROPERTY));
    }

    public static List<String> getRemovedTags(TaggableObjectChangedEvent event) {
        return TaggableObjectDiffService.getAsListOfString(JsonUtils.getArrayDefault(event.details, REMOVED_TAGS_PROPERTY));
    }

    private static List<String> getAsListOfString(JsonArray jsonArray) {
        return StreamSupport.stream(jsonArray.spliterator(), false).map(JsonElement::getAsString).toList();
    }

    public static class TaggableObjectsDiff {
        public ITaggingService.TaggableType objectType;
        public String projectKey;
        public String objectId;
        public String user;
        public boolean creation;
        public boolean renamed;
        public String oldName;
        public String newName;
        public boolean descriptionEdited;
        public boolean shortDescEdited;
        public String newShortDesc;
        public List<String> addedTags = new ArrayList<String>();
        public List<String> removedTags = new ArrayList<String>();
        public List<String> addedTasks = new ArrayList<String>();
        public List<String> removedTasks = new ArrayList<String>();
        public List<String> justCompletedTasks = new ArrayList<String>();
        public List<String> undoneTasks = new ArrayList<String>();
        public List<String> addedChecklists = new ArrayList<String>();
        public List<String> removedChecklists = new ArrayList<String>();
        boolean justCompletedAllObjectTasks;
        int totalTasks;
        int totalCompletedTasks;
        public boolean customFieldsEdited;

        public static boolean isAboutTags(JsonObject elt) {
            return elt.has(TaggableObjectDiffService.ADDED_TAGS_PROPERTY) || elt.has(TaggableObjectDiffService.REMOVED_TAGS_PROPERTY);
        }

        public static boolean isAboutTasks(JsonObject elt) {
            return elt.has("totalTasks");
        }

        public static boolean isAboutDescriptions(JsonObject elt) {
            return elt.has("descriptionEdited") || elt.has("shortDescEdited");
        }

        public static boolean isAboutTagsOnly(JsonObject elt) {
            return TaggableObjectsDiff.isAboutTags(elt) && !TaggableObjectsDiff.isAboutTasks(elt) && !TaggableObjectsDiff.isAboutDescriptions(elt);
        }

        public static boolean isAboutTasksOnly(JsonObject elt) {
            return !TaggableObjectsDiff.isAboutTags(elt) && TaggableObjectsDiff.isAboutTasks(elt) && !TaggableObjectsDiff.isAboutDescriptions(elt);
        }

        public static boolean isMoreComplex(JsonObject elt) {
            return !TaggableObjectsDiff.isAboutTasksOnly(elt) && !TaggableObjectsDiff.isAboutTagsOnly(elt);
        }

        public JsonObject toEventDetails() {
            JsonObject elt = new JsonObject();
            if (this.addedChecklists.size() > 0) {
                elt.add("addedChecklists", (JsonElement)JSON.gson().toJsonTree(this.addedChecklists).getAsJsonArray());
            }
            if (this.removedChecklists.size() > 0) {
                elt.add("removedChecklists", (JsonElement)JSON.gson().toJsonTree(this.removedChecklists).getAsJsonArray());
            }
            if (this.addedTasks.size() > 0) {
                elt.add("addedTasks", (JsonElement)JSON.gson().toJsonTree(this.addedTasks).getAsJsonArray());
            }
            if (this.removedTasks.size() > 0) {
                elt.add("removedTasks", (JsonElement)JSON.gson().toJsonTree(this.removedTasks).getAsJsonArray());
            }
            if (this.justCompletedTasks.size() > 0) {
                elt.add("doneTasks", (JsonElement)JSON.gson().toJsonTree(this.justCompletedTasks).getAsJsonArray());
            }
            if (this.undoneTasks.size() > 0) {
                elt.add("undoneTasks", (JsonElement)JSON.gson().toJsonTree(this.undoneTasks).getAsJsonArray());
            }
            if (this.addedTasks.size() + this.removedTasks.size() + this.justCompletedTasks.size() + this.undoneTasks.size() > 0) {
                elt.addProperty("totalDoneTasks", (Number)this.totalCompletedTasks);
                elt.addProperty("totalTasks", (Number)this.totalTasks);
            }
            if (this.justCompletedAllObjectTasks) {
                elt.addProperty("doneAllTasks", Boolean.valueOf(true));
            }
            if (this.descriptionEdited) {
                elt.addProperty("descriptionEdited", Boolean.valueOf(true));
            }
            if (this.shortDescEdited) {
                elt.addProperty("shortDescEdited", Boolean.valueOf(true));
                elt.addProperty("newShortDesc", this.newShortDesc);
            }
            if (this.addedTags.size() > 0) {
                elt.add(TaggableObjectDiffService.ADDED_TAGS_PROPERTY, (JsonElement)JSON.gson().toJsonTree(this.addedTags).getAsJsonArray());
            }
            if (this.removedTags.size() > 0) {
                elt.add(TaggableObjectDiffService.REMOVED_TAGS_PROPERTY, (JsonElement)JSON.gson().toJsonTree(this.removedTags).getAsJsonArray());
            }
            return elt;
        }

        public boolean metadataChanged() {
            if (this.creation) {
                return false;
            }
            return this.metadataOtherThanTasksChanged() || this.tasksChanged();
        }

        public boolean tasksChanged() {
            return !this.addedChecklists.isEmpty() || !this.removedChecklists.isEmpty() || !this.justCompletedTasks.isEmpty() || !this.addedTasks.isEmpty() || !this.removedTasks.isEmpty() || !this.undoneTasks.isEmpty();
        }

        public boolean metadataOtherThanTasksChanged() {
            return this.renamed || this.descriptionEdited || this.shortDescEdited || this.customFieldsEdited || !this.addedTags.isEmpty() || !this.removedTags.isEmpty();
        }
    }
}

