/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.numbers;

import com.dataiku.dip.datalayer.CellData;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.util.ParamDesc;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import java.util.Set;

public class RoundProcessor
extends AppliesToProcessor
implements Processor {
    private static final String SIGNIFICANT_DIGITS_NOT_TRANSLATABLE_REASON = "Only translatable with 0 significant digits";
    private static final String DECIMAL_PLACES_NOT_TRANSLATABLE_REASON = "A non-zero value for decimal places is only supported in 'Round' mode";
    public static final ProcessorMeta<RoundProcessor, Parameter> META = new ProcessorMeta<RoundProcessor, Parameter>(){

        @Override
        public String getName() {
            return "RoundProcessor";
        }

        @Override
        public String getDocPage() {
            return "round";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MATH});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.RoundProcessor.HELP", "Round decimal numbers in one or several columns using round, floor, or ceil. \n\n# Options\n\n**Column**\n\nApply rounding to numbers in the following: \n\n* A single column\n\n* An explicit list of columns\n\n* All columns matching a regex pattern\n\n* All columns\n\n**Rounding mode**\n\nSelect how to round numbers: \n\n* Round: Round the number to the specified significant digit.\n\n* Floor: Round the number down, or toward zero.\n\n* Ceil: Round the number up, or away from zero.\n\n**Significant digits**\n\nControl the *precision* of the number. ``1234.5`` with 2 significant digits is ``1200``. Using 0 means the number is unbounded and keeps all significant digits. \n\n**Decimal places**\n\nHow many numbers to show after the decimal point. ``1.234`` with 1 decimal place is ``1.2``. Using 0 rounds to the integer; -2 rounds to the hundreds. \n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.RoundProcessor.DESCRIPTION", 1.actionVerb("Round") + " numbers")).withParam(ParamDesc.advancedSelect("mode", this.translate(language, "SHAKER.PROCESSOR.RoundProcessor.DESCRIPTION.MODE", "Rounding mode"), "Rounding mode", new String[]{"ROUND", "FLOOR", "CEIL"}, new String[]{this.translate(language, "SHAKER.PROCESSOR.RoundProcessor.DESCRIPTION.MODE.ROUND", "Round"), this.translate(language, "SHAKER.PROCESSOR.RoundProcessor.DESCRIPTION.MODE.FLOOR", "Floor (round below)"), this.translate(language, "SHAKER.PROCESSOR.RoundProcessor.DESCRIPTION.MODE.CEIL", "Ceil (round above)")})).withParam(ParamDesc.intP("precision", this.translate(language, "SHAKER.PROCESSOR.RoundProcessor.DESCRIPTION.PRECISION", "Significant digits"), "0 means unbounded", 0)).withParam(ParamDesc.intP("places", this.translate(language, "SHAKER.PROCESSOR.RoundProcessor.DESCRIPTION.PLACES", "Decimal places"), "-2 means round to hundreds", 0));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            Parameter roundProcessorParams = (Parameter)params;
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (roundProcessorParams.precision != 0) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, RoundProcessor.SIGNIFICANT_DIGITS_NOT_TRANSLATABLE_REASON);
                ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, RoundProcessor.SIGNIFICANT_DIGITS_NOT_TRANSLATABLE_REASON);
            } else if (roundProcessorParams.places != 0 && roundProcessorParams.mode != Mode.ROUND) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, RoundProcessor.DECIMAL_PLACES_NOT_TRANSLATABLE_REASON);
                ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, RoundProcessor.DECIMAL_PLACES_NOT_TRANSLATABLE_REASON);
            } else {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE, ProcessorCapabilities.NATIVE_SPARK_IMPL);
            }
            return ret;
        }

        @Override
        public Object selfReport(Parameter parameter) {
            return AppliesToProcessor.selfReport(parameter);
        }

        @Override
        public RoundProcessor build(Parameter parameter) {
            return new RoundProcessor(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.numbers.RoundProcessorNS";
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            return previousRecipeLineage;
        }
    };
    private final Parameter parameter;
    private DoubleMeaning dm = new DoubleMeaning();
    private boolean simple;
    CellData buf = new CellData();
    RoundingMode roundingMode;
    MathContext mathContext;

    public RoundProcessor(Parameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public AppliesToProcessor.AppliesToParams getParams() {
        return this.parameter;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.simple = this.parameter.places == 0 && this.parameter.precision == 0;
        switch (this.parameter.mode) {
            case CEIL: {
                this.roundingMode = RoundingMode.CEILING;
                break;
            }
            case FLOOR: {
                this.roundingMode = RoundingMode.FLOOR;
                break;
            }
            case ROUND: {
                this.roundingMode = RoundingMode.HALF_UP;
            }
        }
        if (this.parameter.precision != 0) {
            this.mathContext = new MathContext(this.parameter.precision, this.roundingMode);
        }
    }

    @Override
    public void processRowForColumns(Row row, Iterable<Column> cds) {
        for (Column col : cds) {
            row.get(col, this.buf);
            if (!this.buf.hasData()) continue;
            try {
                double d = this.dm.doubleValue(this.buf.toString());
                if (Double.isInfinite(d) || Double.isNaN(d)) continue;
                if (this.simple) {
                    switch (this.parameter.mode) {
                        case CEIL: {
                            row.put(col, (long)Math.ceil(d));
                            break;
                        }
                        case FLOOR: {
                            row.put(col, (long)Math.floor(d));
                            break;
                        }
                        case ROUND: {
                            row.put(col, Math.round(d));
                        }
                    }
                    continue;
                }
                BigDecimal bd = BigDecimal.valueOf(d);
                if (this.mathContext != null) {
                    bd = bd.round(this.mathContext);
                }
                bd = bd.setScale(this.parameter.places, this.roundingMode);
                row.put(col, bd.toPlainString());
            }
            catch (Exception exception) {}
        }
    }

    public void postProcess() {
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = -1L;
        public Mode mode = Mode.ROUND;
        public int places = 0;
        public int precision = 0;
    }

    public static enum Mode {
        ROUND,
        CEIL,
        FLOOR;

    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            List<String> affectedColumns = chain.getAppliesToColumns(this.parameter);
            if (chain.isAnyCreatedOrModifiedByCurrentQuery(affectedColumns)) {
                chain = chain.makeSubquery();
            }
            for (String column : affectedColumns) {
                chain.replaceSelect(column, switch (this.parameter.mode) {
                    case Mode.ROUND -> chain.col(column).round(this.parameter.places);
                    case Mode.CEIL -> chain.col(column).ceil();
                    case Mode.FLOOR -> chain.col(column).floor();
                    default -> throw new IllegalArgumentException("Cannot handle mode '" + String.valueOf((Object)this.parameter.mode) + "'");
                }, column);
                chain.markColumnModified(column);
            }
            return chain;
        }
    }
}

