/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.time.DateProcessor;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.ReadablePartial;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.expr.functions.date.DateTrunc;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DateTruncate
extends DateProcessor {
    public static final ProcessorMeta<DateTruncate, Parameter> META = new DateProcessor.DateProcessorMeta<DateTruncate, Parameter>(){

        @Override
        public String getName() {
            return "DateTruncate";
        }

        @Override
        public String getDocPage() {
            return "date-truncate";
        }

        @Override
        public Category getCategory() {
            return Category.DATE;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.DATE});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.DateTruncate.HELP", "This processor takes a column containing a date in standard ISO8601 format (ie, detected with meaning 'Date') and truncate it at a specified point");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public DateTruncate build(Parameter parameter) {
            return new DateTruncate(parameter);
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.DateTruncate.DESCRIPTION", 1.actionVerb("Truncate") + " date at a specified value"), false).withMNEColParam("inCol", this.translate(language, "SHAKER.PROCESSOR.DateTruncate.DESCRIPTION.IN_COL", "Column")).withParam(ParamDesc.advancedSelect("datePart", this.translate(language, "SHAKER.PROCESSOR.DateTruncate.DESCRIPTION.DATE_PART", "Date part"), "", DatePart.class).withDefaultValue(DatePart.DAY)).withParam("outCol", "string", false, true, this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN_EMPTY_FOR_INPLACE", "Output column (empty for in-place)"));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE).withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.time.DateTruncateNS";
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = super.getUpdatedDatasetPairLineage(pss.params, (DatasetPairLineage)previousDatasetPairLineage, false);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private Column inCD;
    private Column outCD;
    private Parameter params;
    private DKUFormulaUtils formulaUtils = new DKUFormulaUtils();

    public DateTruncate(Parameter params) {
        this.params = params;
    }

    public void init() throws Exception {
        this.inCD = this.getColumnFactory().column(this.params.inCol, Processor.ProcessorRole.INPUT_COLUMN);
        this.outCD = StringUtils.isNotBlank((String)this.params.outCol) ? this.getColumnFactory().columnAfter(this.params.inCol, this.params.outCol, Processor.ProcessorRole.OUTPUT_COLUMN) : this.getColumnFactory().column(this.params.inCol, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        String rowVal = row.get(this.inCD);
        if (StringUtils.isNotBlank((String)rowVal)) {
            Object temporalRowVal;
            try {
                temporalRowVal = this.formulaUtils.asTemporal(rowVal);
            }
            catch (RuntimeException e) {
                return;
            }
            if (temporalRowVal instanceof DateTime) {
                DateTime result = DateTrunc.truncate((ReadableInstant)((DateTime)temporalRowVal), DateTruncate.toDateUnit(this.params.datePart));
                row.put(this.outCD, result.toString());
            } else if (temporalRowVal instanceof LocalDateTime) {
                DateTime converted = ((LocalDateTime)temporalRowVal).toDateTime(DateTimeZone.UTC);
                DateTime result = DateTrunc.truncate((ReadableInstant)converted, DateTruncate.toDateUnit(this.params.datePart));
                row.put(this.outCD, DatetimeNoTz.CANONICAL_FORMATTER.print((ReadablePartial)result.toLocalDateTime()));
            } else if (temporalRowVal instanceof LocalDate) {
                if (this.params.datePart == DatePart.HOUR || this.params.datePart == DatePart.MINUTE || this.params.datePart == DatePart.SECOND) {
                    throw new IllegalStateException("Unexpected date part: " + String.valueOf(this.params.datePart));
                }
                DateTime converted = ((LocalDate)temporalRowVal).toDateTimeAtStartOfDay(DateTimeZone.UTC);
                DateTime result = DateTrunc.truncate((ReadableInstant)converted, DateTruncate.toDateUnit(this.params.datePart));
                row.put(this.outCD, result.toLocalDate().toString());
            } else {
                throw new IllegalStateException("Unexpected date type: " + temporalRowVal.getClass().getCanonicalName());
            }
        }
    }

    public void postProcess() throws Exception {
    }

    private static DateTrunc.DateUnit toDateUnit(DatePart datePart) {
        switch (datePart) {
            case YEAR: {
                return DateTrunc.DateUnit.YEARS;
            }
            case MONTH: {
                return DateTrunc.DateUnit.MONTHS;
            }
            case DAY: {
                return DateTrunc.DateUnit.DAYS;
            }
            case HOUR: {
                return DateTrunc.DateUnit.HOURS;
            }
            case MINUTE: {
                return DateTrunc.DateUnit.MINUTES;
            }
            case SECOND: {
                return DateTrunc.DateUnit.SECONDS;
            }
        }
        throw new IllegalStateException("Unexpected date part: " + String.valueOf(datePart));
    }

    public static class Parameter
    extends DateProcessor.DateParameter {
        private static final long serialVersionUID = -1L;
        DatePart datePart = DatePart.YEAR;

        @Override
        public void validate() throws IllegalArgumentException {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DatePart implements Labelled
    {
        YEAR{

            @Override
            public String getLabel() {
                return "Year";
            }
        }
        ,
        MONTH{

            @Override
            public String getLabel() {
                return "Month";
            }
        }
        ,
        DAY{

            @Override
            public String getLabel() {
                return "Day";
            }
        }
        ,
        HOUR{

            @Override
            public String getLabel() {
                return "Hour";
            }
        }
        ,
        MINUTE{

            @Override
            public String getLabel() {
                return "Minute";
            }
        }
        ,
        SECOND{

            @Override
            public String getLabel() {
                return "Second";
            }
        };

    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(ProcessorSQLTranslator.ProcessorSQLTranslateParams translateParams) {
            SQLQueryWithSchema input = translateParams.input;
            if (StringUtils.equals((String)this.parameter.inCol, (String)this.parameter.outCol)) {
                this.parameter.outCol = null;
            }
            ArrayList affectedColumns = Lists.newArrayList((Object[])new String[]{this.parameter.inCol});
            boolean needsSubquery = input.isAnyCreatedOrModifiedByCurrentQuery(affectedColumns);
            if (StringUtils.isNotBlank((String)this.parameter.outCol)) {
                needsSubquery |= input.isCreatedOrModifiedByCurrentQuery(this.parameter.outCol);
            }
            if (needsSubquery) {
                input = input.makeSubquery();
            }
            for (String column : affectedColumns) {
                SchemaColumn inputSchemaColumn = input.getCurrentColumn(column);
                ExpressionBuilder col = input.col(inputSchemaColumn, translateParams.typeSystemVersion, translateParams.isDatasetManaged);
                Type columnType = inputSchemaColumn.getType();
                ExpressionBuilder e = columnType == Type.DATEONLY ? col.dateonlyTrunc(this.parameter.datePart.name()) : (columnType == Type.DATETIMENOTZ ? col.datetimenotzTrunc(this.parameter.datePart.name()) : col.dateTrunc(this.parameter.datePart.name()));
                input.addAfterOrReplaceColumn(inputSchemaColumn, e, Type.DATE, this.parameter.outCol, false);
            }
            return input;
        }
    }
}

