/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.util.ShortTimezoneList;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.geoip.fastgeo.FastGeoIP2;
import com.dataiku.geoip.fastgeo.GeoIPService;
import com.google.common.net.InetAddresses;
import java.io.File;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;

public abstract class TimezonableProcessor
extends SingleRowProcessor
implements Processor,
ProcessorWithResourceFiles {
    private TZSourceType srcType;
    private DateTimeZone staticTimezone;
    private Column inferCol;
    private FastGeoIP2 geoIP;
    private File geoIPDBFile;
    public static final String[] friendlyTimezoneIds = ShortTimezoneList.concatTo("UTC", "extract_from_column", "extract_from_ip");

    @Override
    public Map<String, File> gatherRequirements() {
        HashMap<String, File> ret = new HashMap<String, File>();
        ret.put("dku.geoip.db", new File(ApplicationConfigurator.getInstallFolder(), "resources/GeoLite2City.fgdb.gz"));
        return ret;
    }

    @Override
    public void setRequiredFiles(Map<String, File> requiredFiles) {
        this.geoIPDBFile = requiredFiles.get("dku.geoip.db");
    }

    public static ProcessorDesc appendTimezoneParams(String language, ProcessorDesc desc) {
        return desc.withParam(ParamDesc.advancedSelect("timezone_id", TimezonableProcessor.translate(language, "SHAKER.PROCESSOR.TimezonableProcessor.DESCRIPTION.TIMEZONE_ID", "Timezone"), "Timezone", friendlyTimezoneIds, TimezonableProcessor.friendlyTimezoneNames(language)).withDefaultValue("UTC").withCanBeEmpty(false)).withParam("timezone_src", "generic", true, true, TimezonableProcessor.translate(language, "SHAKER.PROCESSOR.TimezonableProcessor.DESCRIPTION.TIMEZONE_SRC", "Timezone source column"));
    }

    public void initTimezonableWithParams(String timezoneId, String timezoneSrc) throws Exception {
        if ("extract_from_column".equals(timezoneId)) {
            this.inferCol = this.getColumnFactory().column(timezoneSrc, Processor.ProcessorRole.INPUT_COLUMN);
            this.srcType = TZSourceType.TZ_FROM_VALUE_COL;
        } else if ("extract_from_ip".equals(timezoneId)) {
            this.geoIP = GeoIPService.getInstance((File)this.geoIPDBFile);
            this.inferCol = this.getColumnFactory().column(timezoneSrc, Processor.ProcessorRole.INPUT_COLUMN);
            this.srcType = TZSourceType.TZ_FROM_IP_COL;
        } else {
            this.staticTimezone = this.parseTimezone(timezoneId);
            this.srcType = TZSourceType.TZ_FROM_VALUE;
        }
    }

    private DateTimeZone parseTimezone(String timeZoneID) throws IllegalArgumentException {
        if (timeZoneID == null || timeZoneID.isEmpty()) {
            throw new IllegalArgumentException("Invalid timezone");
        }
        return DateTimeZone.forID((String)timeZoneID);
    }

    protected final DateTimeZone getTimezone(Row row) {
        switch (this.srcType) {
            case TZ_FROM_IP_COL: {
                String ipSource = row.get(this.inferCol);
                InetAddress addr = null;
                try {
                    if (ipSource != null && ipSource.length() > 2) {
                        addr = InetAddresses.forString((String)ipSource);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (addr != null) {
                    try {
                        String tz;
                        FastGeoIP2.Result details = this.geoIP.find(addr);
                        if (details != null && (tz = details.getTimezone()) != null) {
                            return this.parseTimezone(tz);
                        }
                    }
                    catch (Exception details) {
                        // empty catch block
                    }
                }
                return null;
            }
            case TZ_FROM_VALUE: {
                return this.staticTimezone;
            }
            case TZ_FROM_VALUE_COL: {
                String tzSource = row.get(this.inferCol);
                if (tzSource == null) {
                    return null;
                }
                try {
                    return this.parseTimezone(tzSource);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        throw new Error("unreachable");
    }

    protected static String translate(String language, String translationID, String defaultValue) {
        TranslationService sts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        return sts.translate(language, translationID, defaultValue, new Object[0]);
    }

    public static final String[] friendlyTimezoneNames(String language) {
        return ShortTimezoneList.concatTo("UTC", TimezonableProcessor.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.USE_TZ_COLUMN", "Use TZ column"), TimezonableProcessor.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.USE_IP_COLUMN", "Use IP column"));
    }

    public static enum TZSourceType {
        TZ_FROM_VALUE_COL,
        TZ_FROM_IP_COL,
        TZ_FROM_VALUE;

    }
}

