/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.util.ParamDesc;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class LongTailGrouper
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<LongTailGrouper, Parameter> META = new ProcessorMeta<LongTailGrouper, Parameter>(){

        @Override
        public String getName() {
            return "LongTailGrouper";
        }

        @Override
        public String getDocPage() {
            return "long-tail";
        }

        @Override
        public Category getCategory() {
            return Category.CLEANSING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CLEANSING});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.LongTailGrouper.HELP", "This processor merges together all values of a column that are not part of a  white-list of values that should not be merged.\n\n#Use case\n\nThe main use case of this processor is to merge all values of a column except the most frequent ones. The merged values are replaced by a generic 'Others' value.\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.LongTailGrouper.DESCRIPTION", 1.actionVerb("Group") + " long-tail values")).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column")).withParam(new ParamDesc("toKeep", "list").withDefaultValue(new ArrayList()).withMandatory(true).withLabel(this.translate(language, "SHAKER.PROCESSOR.LongTailGrouper.DESCRIPTION.LIST_OF_VALUES_TO_KEEP", "List of values to keep"))).withParam(new ParamDesc("replace", "generic").withLabel(this.translate(language, "SHAKER.PROCESSOR.LongTailGrouper.DESCRIPTION.REPLACE_OTHER_VALUES_BY", "Replace other values by")).withCanBeEmpty(true).withMandatory(false));
        }

        @Override
        public LongTailGrouper build(Parameter parameter) throws Exception {
            return new LongTailGrouper(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            return previousRecipeLineage;
        }
    };
    private final Parameter parameter;
    private Column colD;

    public LongTailGrouper(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        this.colD = this.getColumnFactory().column(this.parameter.column, Processor.ProcessorRole.INPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        String before = row.get(this.colD);
        if (before == null) {
            before = "";
        }
        if (!this.parameter.toKeep.contains(before)) {
            if (this.parameter.replace == null) {
                row.delete(this.colD);
            } else {
                row.put(this.colD, this.parameter.replace);
            }
        }
    }

    public void postProcess() {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        String column;
        String replace;
        Set<String> toKeep = new HashSet<String>();

        public void validate() throws IllegalArgumentException {
        }
    }
}

