/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform.visualif;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.ColumnRelation;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.ExpressionError;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.model.StepParamsWithVariablesContext;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.expr.PreviousRowsBuffer;
import com.dataiku.dip.shaker.processors.transform.visualif.VisualIfDesc;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualIfRule {
    public static final Logger logger = LoggerFactory.getLogger(VisualIfRule.class);
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "VisualIfRule";
        }

        @Override
        public String getDocPage() {
            return "create-if-then-else-statement";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.ENRICH});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.VisualIfRule.HELP", "This processor performs actions or calculations based on conditional statements defined using an if, then, else syntax.\nThe statements have three parts:\n\nIF [Condition(s)] THEN [Action] ELSE [Action]\n\n- IF:   defines the condition(s) to fulfill in order for the actions or calculations to take place.\n- THEN: actions to perform if the condition(s) evaluate to True.\n- ELSE: actions to take when the condition(s) evaluate to False. This is optional.\n\n# Conditions\n\nA condition is defined with a field, an operator, and a value.\n* Field: choose any column from the dataset\n* Operator: choose an operator from the dropdown menu. The operator must match the column type.\nFor example, string operators refer to operators that apply to string columns, like \u201ccontains\u201d, \u201cequals\u201d, \u201cmatches the regex\u201d; while numerical operators  like \u201c>\u201d, \u201c==\u201c, apply to numerical columns. If you are not sure of what is the column type, refer to the storage type in the input dataset of the recipe, given under the name of the column.\n* Value: use an existing column or enter a value\n\nTo add a condition, click on +ADD > Add condition.\n\nAdditional condition clauses (Else If) can be created by clicking on the '+Add an Else If' button.\n\nDefine more complex conditional logic (i.e, \"A AND B\") with the conjunctions AND and OR.\n\nYou can delete, duplicate and turn a condition into a group to create advanced conditions.\n## Groups\nCreate advanced logic for conditional statements using groups.\nGroups can be either nested to create sub-conditions ``(y AND z AND (t OR u)))`` or defined at the same level ``(y OR z) AND (t OR u)``\nTo add a group of conditions, click on +ADD > Add group.\nYou can delete, duplicate, and ungroup a group.\n# Actions (THEN/ELSE)\n\nAn action is composed of:\n* Output column: use an existing column or create a new one\n* A type of output: value, column, formula\n* The item that is assigned: a value, an existing column or a formula\n\nYou can define multiple actions by adding multiple statements to the THEN block.\n\n# Editor usage\n\nTo hide the rule editor, simply click on the CLOSE button. The CLOSE button will discard all changes not applied, click on APPLY first to keep your changes. \nTo see your changes in the dataset below, click on the top-right button APPLY. It will also update the rules summary in the processor step.\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.VisualIfRule.DESCRIPTION", 1.actionVerb("Create ") + "if, then, else statements"), null, false);
        }

        @Override
        public StepParams expandParams(StepParams params, VariablesContext vc) {
            Parameter grelParams = (Parameter)params;
            for (VisualIfDesc.Action action : grelParams.visualIfDesc.ifThen.actions) {
                action.formula = vc.expand(action.formula);
                action.value = vc.expand(action.value);
            }
            for (VisualIfDesc.Action action : grelParams.visualIfDesc.elseActions) {
                action.formula = vc.expand(action.formula);
                action.value = vc.expand(action.value);
            }
            for (VisualIfDesc.IfThen ifThenIterator : grelParams.visualIfDesc.elseIfThens) {
                for (VisualIfDesc.Action action : ifThenIterator.actions) {
                    action.formula = vc.expand(action.formula);
                    action.value = vc.expand(action.value);
                }
            }
            grelParams.variablesContext = vc;
            return grelParams;
        }

        @Override
        public Object selfReport(Parameter parameter) {
            JsonObject report = new JsonObject();
            report.add("visualIfDesc", (JsonElement)(parameter.visualIfDesc != null ? parameter.visualIfDesc.selfReport() : new JsonObject()));
            return report;
        }

        @Override
        public StreamImpl build(Parameter parameter) {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            Parameter param = (Parameter)sp;
            try {
                FilterDescUtils.getSQLExpression(param.visualIfDesc.ifThen.filter, dialect, null, true);
                for (VisualIfDesc.IfThen elseIfThen : param.visualIfDesc.elseIfThens) {
                    FilterDescUtils.getSQLExpression(elseIfThen.filter, dialect, null, true);
                }
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            catch (Exception e) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine because: " + e.getMessage());
            }
            return ret;
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) throws IOException {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                Parameter ifRuleParams = (Parameter)pss.params;
                ArrayList<VisualIfDesc.Action> allActions = new ArrayList<VisualIfDesc.Action>();
                allActions.addAll(ifRuleParams.visualIfDesc.ifThen.actions);
                for (VisualIfDesc.IfThen elseIfThen : ifRuleParams.visualIfDesc.elseIfThens) {
                    allActions.addAll(elseIfThen.actions);
                }
                allActions.addAll(ifRuleParams.visualIfDesc.elseActions);
                Set<String> outputColumnsToCleanup = allActions.stream().map(a -> a.outputColumnName).collect(Collectors.toSet());
                try {
                    HashSet<String> filtersInputColumns = new HashSet<String>();
                    String ifExpr = FilterDescUtils.translateAstToGrel(ifRuleParams.visualIfDesc.ifThen.filter);
                    filtersInputColumns.addAll(new Expression(ifExpr).getVariables());
                    this.updateDatasetPairLineageForBlock(ifRuleParams.visualIfDesc.ifThen.actions, updatedDatasetPairLineage, filtersInputColumns, outputColumnsToCleanup);
                    for (VisualIfDesc.IfThen ifThenIterator : ifRuleParams.visualIfDesc.elseIfThens) {
                        Expression tmpExpr = new Expression(FilterDescUtils.translateAstToGrel(ifThenIterator.filter));
                        filtersInputColumns.addAll(tmpExpr.getVariables());
                        this.updateDatasetPairLineageForBlock(ifThenIterator.actions, updatedDatasetPairLineage, filtersInputColumns, outputColumnsToCleanup);
                    }
                    this.updateDatasetPairLineageForBlock(ifRuleParams.visualIfDesc.elseActions, updatedDatasetPairLineage, filtersInputColumns, outputColumnsToCleanup);
                    if (!ifRuleParams.visualIfDesc.elseActions.isEmpty()) {
                        for (String outputColumnToCleanup : outputColumnsToCleanup) {
                            boolean updatedLineageHasOutputColumn = updatedDatasetPairLineage.hasOutputColumn(outputColumnToCleanup);
                            if (!updatedLineageHasOutputColumn) continue;
                            for (ColumnRelation previousRelation : previousDatasetPairLineage.getRelationsOnOutputColumn(outputColumnToCleanup)) {
                                updatedDatasetPairLineage.removeRelation(previousRelation);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Failed to build column relations for VisualIf step", (Throwable)e);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }

        private void updateOutputColumnsToCleanup(List<VisualIfDesc.Action> actions, Set<String> outputColumnsToCleanup) {
            HashSet<String> foundOutputColumns = new HashSet<String>();
            HashSet<String> columnsToRemoveFromCleanup = new HashSet<String>();
            for (VisualIfDesc.Action action : actions) {
                if (!outputColumnsToCleanup.contains(action.outputColumnName) || foundOutputColumns.contains(action.outputColumnName)) continue;
                foundOutputColumns.add(action.outputColumnName);
                if (VisualIfDesc.ActionOperator.ASSIGN_FORMULA.equals((Object)action.operator)) {
                    Expression expr = new Expression(action.formula);
                    List<String> inputColumns = expr.getVariables();
                    if (!inputColumns.contains(action.outputColumnName)) continue;
                    columnsToRemoveFromCleanup.add(action.outputColumnName);
                    continue;
                }
                if (!VisualIfDesc.ActionOperator.ASSIGN_COLUMN.equals((Object)action.operator) || action.column == null || !action.column.equals(action.outputColumnName)) continue;
                columnsToRemoveFromCleanup.add(action.outputColumnName);
            }
            columnsToRemoveFromCleanup.addAll((Collection<String>)Sets.difference(outputColumnsToCleanup, foundOutputColumns));
            outputColumnsToCleanup.removeAll(columnsToRemoveFromCleanup);
        }

        private void updateDatasetPairLineageForBlock(List<VisualIfDesc.Action> actions, DatasetPairLineage previousDatasetPairLineage, Set<String> inputColumns, Set<String> outputColumnsToCleanup) {
            HashSet<String> outputColumnsForBlock = new HashSet<String>();
            for (VisualIfDesc.Action action : actions) {
                if (!outputColumnsForBlock.add(action.outputColumnName)) continue;
                String outputColumn = action.outputColumnName;
                for (String inputColumn : inputColumns) {
                    previousDatasetPairLineage.addFactorizedColumnRelations(inputColumn, outputColumn);
                }
                this.updateDatasetPairLineageForAction(action, previousDatasetPairLineage);
            }
            this.updateOutputColumnsToCleanup(actions, outputColumnsToCleanup);
        }

        private void updateDatasetPairLineageForAction(VisualIfDesc.Action action, DatasetPairLineage previousDatasetPairLineage) {
            HashSet<String> actionInputColumns = new HashSet<String>();
            String actionOutputColumn = action.outputColumnName;
            switch (action.operator) {
                case ASSIGN_COLUMN: {
                    actionInputColumns.add(action.column);
                    break;
                }
                case ASSIGN_FORMULA: {
                    Expression expr = new Expression(action.formula);
                    actionInputColumns.addAll(expr.getVariables());
                    break;
                }
                case ASSIGN_VALUE: {
                    return;
                }
            }
            for (String actionInputColumn : actionInputColumns) {
                previousDatasetPairLineage.addFactorizedColumnRelations(actionInputColumn, actionOutputColumn);
            }
        }
    };

    private static void addActionInputColumns(List<String> inputCols, VisualIfDesc.Action action) {
        if (action.operator == VisualIfDesc.ActionOperator.ASSIGN_COLUMN) {
            inputCols.add(action.column);
        } else if (action.operator == VisualIfDesc.ActionOperator.ASSIGN_FORMULA) {
            Expression expr = new Expression(action.formula);
            inputCols.addAll(expr.getVariables());
        }
    }

    private static Set<String> getOrderedOutputColumns(Parameter params) {
        LinkedHashSet<String> orderedOutputCols = new LinkedHashSet<String>();
        for (VisualIfDesc.Action action : params.visualIfDesc.ifThen.actions) {
            orderedOutputCols.add(action.outputColumnName);
        }
        for (VisualIfDesc.IfThen ifThenIterator : params.visualIfDesc.elseIfThens) {
            for (VisualIfDesc.Action action : ifThenIterator.actions) {
                orderedOutputCols.add(action.outputColumnName);
            }
        }
        for (VisualIfDesc.Action action : params.visualIfDesc.elseActions) {
            orderedOutputCols.add(action.outputColumnName);
        }
        return orderedOutputCols;
    }

    private static List<String> getInputColumns(Parameter params) {
        ArrayList<String> inputCols = new ArrayList<String>();
        for (VisualIfDesc.Action action : params.visualIfDesc.ifThen.actions) {
            VisualIfRule.addActionInputColumns(inputCols, action);
        }
        for (VisualIfDesc.IfThen ifThenIterator : params.visualIfDesc.elseIfThens) {
            for (VisualIfDesc.Action action : ifThenIterator.actions) {
                VisualIfRule.addActionInputColumns(inputCols, action);
            }
        }
        for (VisualIfDesc.Action action : params.visualIfDesc.elseActions) {
            VisualIfRule.addActionInputColumns(inputCols, action);
        }
        try {
            String ifExpr = FilterDescUtils.translateAstToGrel(params.visualIfDesc.ifThen.filter);
            inputCols.addAll(new Expression(ifExpr).getVariables());
            for (VisualIfDesc.IfThen ifThenIterator : params.visualIfDesc.elseIfThens) {
                Expression tmpExpr = new Expression(FilterDescUtils.translateAstToGrel(ifThenIterator.filter));
                inputCols.addAll(tmpExpr.getVariables());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid filter, unable to translate it to GREL", e);
        }
        return inputCols;
    }

    public static class Parameter
    implements StepParams,
    StepParamsWithVariablesContext {
        public VisualIfDesc visualIfDesc = new VisualIfDesc();
        transient VariablesContext variablesContext;
        public Boolean legacyPositioning = false;

        public void validate() throws IllegalArgumentException {
            if (this.visualIfDesc != null) {
                Streams.concat((Stream[])new Stream[]{this.visualIfDesc.ifThen.actions.stream(), this.visualIfDesc.elseActions.stream(), this.visualIfDesc.elseIfThens.stream().flatMap(elseIfThen -> elseIfThen.actions.stream())}).forEach(this::checkColumnValidity);
            }
        }

        private void checkColumnValidity(VisualIfDesc.Action action) throws IllegalArgumentException {
            if (StringUtils.isBlank((CharSequence)action.outputColumnName)) {
                throw new IllegalArgumentException("Output column can't be empty");
            }
            if (action.operator == VisualIfDesc.ActionOperator.ASSIGN_COLUMN && StringUtils.isBlank((CharSequence)action.column)) {
                throw new IllegalArgumentException("Reference column can't be empty");
            }
        }

        @Override
        public void setVariablesContext(VariablesContext vc) {
            this.variablesContext = vc;
        }
    }

    private static class StreamImpl
    extends SingleRowProcessor
    implements Processor {
        private final Parameter param;
        private VisualIfDesc.IfThen ifThen;
        private List<VisualIfDesc.IfThen> elseIfThens = new ArrayList<VisualIfDesc.IfThen>();
        private List<VisualIfDesc.Action> elseActions = new ArrayList<VisualIfDesc.Action>();
        private final List<Expression> ifFiltersExpressions = new ArrayList<Expression>();
        private final List<String> inputColumns;
        private Set<String> orderedOutputColumns;
        private PreviousRowsBuffer previousRowsBuffer;

        private StreamImpl(Parameter param) {
            this.param = param;
            this.inputColumns = VisualIfRule.getInputColumns(param);
            this.orderedOutputColumns = VisualIfRule.getOrderedOutputColumns(param);
        }

        public void postProcess() {
        }

        private void initializeAction(VisualIfDesc.Action action, List<Expression> actionExpressions) {
            action.outputColumn = this.getColumnFactory().column(action.outputColumnName, Processor.ProcessorRole.OUTPUT_COLUMN);
            if (action.operator == VisualIfDesc.ActionOperator.ASSIGN_COLUMN) {
                action.inputColumn = this.getColumnFactory().column(action.column, Processor.ProcessorRole.INPUT_COLUMN);
            } else if (action.operator == VisualIfDesc.ActionOperator.ASSIGN_FORMULA) {
                action.expression = new Expression(action.formula);
                action.expression.setColumnFactory(this.cf);
                if (this.param.variablesContext != null) {
                    action.expression.setVariablesContext(this.param.variablesContext);
                }
                actionExpressions.add(action.expression);
            }
        }

        public Column getLastKnownColumn() {
            Column lastKnown = null;
            for (Column col : this.getColumnFactory().columns()) {
                if (!this.inputColumns.contains(col.getName())) continue;
                lastKnown = col;
            }
            return lastKnown;
        }

        private void initializeColumnsInOrder(Column lastKnown) {
            ArrayList<String> orderedColumnsList = new ArrayList<String>(this.orderedOutputColumns);
            Collections.reverse(orderedColumnsList);
            for (String colName : orderedColumnsList) {
                this.getColumnFactory().columnAfter(lastKnown.getName(), colName, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
        }

        public void init() throws Exception {
            this.ifThen = this.param.visualIfDesc.ifThen;
            this.elseIfThens = this.param.visualIfDesc.elseIfThens;
            this.elseActions = this.param.visualIfDesc.elseActions;
            String ifExpr = FilterDescUtils.translateAstToGrel(this.ifThen.filter);
            Expression expr = new Expression(ifExpr);
            expr.setColumnFactory(this.cf);
            if (this.param.variablesContext != null) {
                expr.setVariablesContext(this.param.variablesContext);
            }
            this.ifFiltersExpressions.add(expr);
            for (VisualIfDesc.IfThen ifThenIterator : this.elseIfThens) {
                try {
                    Expression tmpExpr = new Expression(FilterDescUtils.translateAstToGrel(ifThenIterator.filter));
                    tmpExpr.setColumnFactory(this.cf);
                    if (this.param.variablesContext != null) {
                        tmpExpr.setVariablesContext(this.param.variablesContext);
                    }
                    this.ifFiltersExpressions.add(tmpExpr);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid filter, unable to translate it to GREL", e);
                }
            }
            Column lastKnown = this.getLastKnownColumn();
            if (!(lastKnown == null || this.param.legacyPositioning != null && this.param.legacyPositioning.booleanValue())) {
                this.initializeColumnsInOrder(lastKnown);
            }
            ArrayList<Expression> actionExpressions = new ArrayList<Expression>();
            for (VisualIfDesc.Action action : this.ifThen.actions) {
                this.initializeAction(action, actionExpressions);
            }
            for (VisualIfDesc.IfThen ifThenIterator : this.elseIfThens) {
                for (VisualIfDesc.Action action : ifThenIterator.actions) {
                    this.initializeAction(action, actionExpressions);
                }
            }
            for (VisualIfDesc.Action action : this.elseActions) {
                this.initializeAction(action, actionExpressions);
            }
            this.previousRowsBuffer = new PreviousRowsBuffer(actionExpressions);
        }

        public void applyAction(VisualIfDesc.Action action, Row row) {
            switch (action.operator) {
                case ASSIGN_VALUE: {
                    row.put(action.outputColumn, action.value);
                    break;
                }
                case ASSIGN_COLUMN: {
                    row.put(action.outputColumn, row.get(action.inputColumn));
                    break;
                }
                case ASSIGN_FORMULA: {
                    Object out;
                    if (action.expression == null || (out = action.expression.evaluate(row, this.previousRowsBuffer.getPreviousRows())) == null || out instanceof ExpressionError) break;
                    String outValue = out instanceof LocalDateTime ? out.toString().replace('T', ' ') : out.toString();
                    row.put(action.outputColumn, outValue);
                }
            }
        }

        public void processRow(Row row) {
            boolean foundMatch = false;
            for (int i = 0; !foundMatch && i < this.ifFiltersExpressions.size(); ++i) {
                Object matchesIf = this.ifFiltersExpressions.get(i).evaluate(row);
                if (!(matchesIf instanceof Boolean) || !Boolean.TRUE.equals(matchesIf)) continue;
                if (i == 0) {
                    HashSet<String> ifThenAffectedColumns = new HashSet<String>();
                    for (VisualIfDesc.Action action : this.ifThen.actions) {
                        if (ifThenAffectedColumns.contains(action.outputColumnName)) continue;
                        this.applyAction(action, row);
                        ifThenAffectedColumns.add(action.outputColumnName);
                    }
                } else {
                    HashSet<String> elseIfThenAffectedColumns = new HashSet<String>();
                    for (VisualIfDesc.Action action : this.elseIfThens.get((int)(i - 1)).actions) {
                        if (elseIfThenAffectedColumns.contains(action.outputColumnName)) continue;
                        this.applyAction(action, row);
                        elseIfThenAffectedColumns.add(action.outputColumnName);
                    }
                }
                foundMatch = true;
            }
            if (!foundMatch) {
                HashSet<String> elseAffectedColumns = new HashSet<String>();
                for (VisualIfDesc.Action action : this.elseActions) {
                    if (elseAffectedColumns.contains(action.outputColumnName)) continue;
                    this.applyAction(action, row);
                    elseAffectedColumns.add(action.outputColumnName);
                }
            }
            if (this.previousRowsBuffer.needBuffering()) {
                this.previousRowsBuffer.addRow(row, this.getColumnFactory());
            }
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter params;
        private final List<VisualIfDesc.Action> ifThenActions;
        private final List<VisualIfDesc.Action> elseActions;
        private final ExpressionBuilder.ExpressionBuilderFactory expressionBuilderFactory = new ExpressionBuilder.ExpressionBuilderFactory();
        private LinkedHashMap<String, List<ExpressionBuilder>> columnsAndActions = new LinkedHashMap();
        private final List<String> inputColumns;

        private SQLTranslator(Parameter params) {
            this.params = params;
            this.ifThenActions = params.visualIfDesc.ifThen.actions;
            this.elseActions = params.visualIfDesc.elseActions;
            this.inputColumns = VisualIfRule.getInputColumns(params);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema queryChain) {
            void var5_10;
            queryChain = queryChain.makeSubquery();
            ExpressionBuilder expressionBuilder = FilterDescUtils.translateAstToSql(this.params.visualIfDesc.ifThen.filter, null, true, queryChain.getCurrentSchema(), queryChain.getDialect());
            SchemaColumn lastKnown = null;
            Iterator<Object> iterator = queryChain.getCurrentColumns(this.inputColumns).iterator();
            while (iterator.hasNext()) {
                SchemaColumn schemaColumn;
                lastKnown = schemaColumn = iterator.next();
            }
            for (VisualIfDesc.Action action : this.ifThenActions) {
                this.addAction(queryChain, action, expressionBuilder);
            }
            ArrayList<ExpressionBuilder> elseIfThensExpressions = new ArrayList<ExpressionBuilder>();
            for (VisualIfDesc.IfThen elseIfThen : this.params.visualIfDesc.elseIfThens) {
                elseIfThensExpressions.add(FilterDescUtils.translateAstToSql(elseIfThen.filter, null, true, queryChain.getCurrentSchema(), queryChain.getDialect()));
            }
            boolean bl = false;
            while (var5_10 < this.params.visualIfDesc.elseIfThens.size()) {
                VisualIfDesc.IfThen currentElseIfThen = this.params.visualIfDesc.elseIfThens.get((int)var5_10);
                ExpressionBuilder elseIfExpr = (ExpressionBuilder)elseIfThensExpressions.get((int)var5_10);
                if (var5_10 > 0) {
                    expressionBuilder = expressionBuilder.or((ExpressionBuilder)elseIfThensExpressions.get((int)(var5_10 - true)));
                }
                for (VisualIfDesc.Action currentElseIfThenAction : currentElseIfThen.actions) {
                    this.addAction(queryChain, currentElseIfThenAction, expressionBuilder.not().and(elseIfExpr));
                }
                ++var5_10;
            }
            if (!this.params.visualIfDesc.elseIfThens.isEmpty()) {
                ExpressionBuilder expressionBuilder2 = expressionBuilder.or((ExpressionBuilder)elseIfThensExpressions.get(this.params.visualIfDesc.elseIfThens.size() - 1)).not();
            } else {
                ExpressionBuilder expressionBuilder3 = expressionBuilder.not();
            }
            for (VisualIfDesc.Action elseAction : this.elseActions) {
                void var5_13;
                this.addAction(queryChain, elseAction, (ExpressionBuilder)var5_13);
            }
            this.applyRulesToColumns(queryChain, lastKnown);
            return queryChain;
        }

        public void addAction(SQLQueryWithSchema queryChain, VisualIfDesc.Action action, ExpressionBuilder condition) {
            String outputColumn = action.outputColumnName;
            SchemaColumn schemaColumn = queryChain.getCurrentColumn(outputColumn);
            List caseWhenArguments = this.columnsAndActions.getOrDefault(outputColumn, new ArrayList());
            caseWhenArguments.add(condition);
            switch (action.operator) {
                case ASSIGN_VALUE: {
                    ExpressionBuilder valueExpression = this.expressionBuilderFactory.cst(action.value);
                    if (schemaColumn != null) {
                        valueExpression = valueExpression.cast(schemaColumn.getType(), schemaColumn.getMaxLength());
                    }
                    caseWhenArguments.add(valueExpression);
                    break;
                }
                case ASSIGN_COLUMN: {
                    caseWhenArguments.add(queryChain.col(action.column));
                    break;
                }
                case ASSIGN_FORMULA: {
                    Expression actionExpression = new Expression(action.formula, queryChain);
                    actionExpression.setVariablesContext(this.params.variablesContext);
                    GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping(queryChain.getDialect()), queryChain.getCurrentSchema());
                    GrelTranslator.TranslationResult<ExpressionBuilder> tr = translator.translateToQuery(actionExpression, true);
                    ExpressionBuilder exprResult = (ExpressionBuilder)tr.result;
                    if (schemaColumn != null) {
                        exprResult = exprResult.cast(schemaColumn.getType(), schemaColumn.getMaxLength());
                    }
                    caseWhenArguments.add(exprResult);
                }
            }
            this.columnsAndActions.put(outputColumn, caseWhenArguments);
        }

        public void applyRulesToColumns(SQLQueryWithSchema queryChain, SchemaColumn lastKnown) {
            ArrayList<Map.Entry<String, List<ExpressionBuilder>>> entries = new ArrayList<Map.Entry<String, List<ExpressionBuilder>>>(this.columnsAndActions.entrySet());
            if (this.params.legacyPositioning != null && this.params.legacyPositioning.booleanValue()) {
                for (Map.Entry entry : entries) {
                    SchemaColumn schemaColumn = new SchemaColumn();
                    schemaColumn.setName((String)entry.getKey());
                    schemaColumn.setType(Type.STRING);
                    queryChain.addLastOrReplaceColumn(schemaColumn, this.expressionBuilderFactory.caseWhen(((List)entry.getValue()).toArray(new Object[0])), Type.STRING, (String)entry.getKey());
                    queryChain.markColumnModified((String)entry.getKey());
                }
            } else {
                for (int i = entries.size() - 1; i >= 0; --i) {
                    Map.Entry entry = (Map.Entry)entries.get(i);
                    if (lastKnown == null) {
                        SchemaColumn schemaColumn = new SchemaColumn();
                        schemaColumn.setName((String)entry.getKey());
                        schemaColumn.setType(Type.STRING);
                        queryChain.addLastOrReplaceColumn(schemaColumn, this.expressionBuilderFactory.caseWhen(((List)entry.getValue()).toArray(new Object[0])), Type.STRING, (String)entry.getKey());
                    } else {
                        SchemaColumn outputColumn = queryChain.getCurrentColumn((String)entry.getKey());
                        Type outputType = outputColumn != null ? outputColumn.getType() : Type.STRING;
                        queryChain.addAfterOrReplaceColumn(lastKnown, this.expressionBuilderFactory.caseWhen(((List)entry.getValue()).toArray(new Object[0])), outputType, (String)entry.getKey(), true);
                    }
                    queryChain.markColumnModified((String)entry.getKey());
                }
            }
        }
    }
}

