/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.shaker.sql.AbstractSqlQueryWithSchemaBuilder;
import com.dataiku.dip.sql.PrestoSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import java.io.IOException;
import java.sql.SQLException;

public class SqlQueryWithSchemaBuilder
extends AbstractSqlQueryWithSchemaBuilder {
    public SqlQueryWithSchemaBuilder(JobActivity activity) {
        super(activity);
    }

    @Override
    public SQLDialect computeDialect() throws IOException, SQLException, DKUSecurityException {
        this.dialect = DatasetInspector.getDSSConnectionForSQLAbleDatasetOrHive(this.authCtxService.getAuthCtx(), this.inputDataset).getDialect();
        return this.dialect;
    }

    @Override
    public AbstractSQLConnection getDSSConnection() throws IOException, SQLException, DKUSecurityException {
        return DatasetInspector.getDSSConnectionForSQLAbleDatasetOrHive(this.authCtxService.getAuthCtx(), this.inputDataset);
    }

    @Override
    protected void computeTargetPartitionVariables() throws IOException {
        Partition part;
        if (this.dialect instanceof PrestoSQLDialect) {
            return;
        }
        Dataset outputDS = this.activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO);
        if (DatasetInspector.arePartitioningColumnsMandatoryInSchema(outputDS) && (part = this.activity.getSubgraph().getTargetPartition(this.activity.getSubgraph().getSingleTargetDataset())) != null && !part.isNP() && !part.isAll() && outputDS.getPartitioningSchema().isPartitioned()) {
            this.targetPartition = part;
            this.targetPartitionScheme = outputDS.getPartitioningSchema();
        }
    }
}

