/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DB2SQLDialect
extends GenericSQLDialect {
    @Override
    public boolean needSubQueryForConstantInWhereClause() {
        return true;
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, 5, "smallint", new Integer[0]);
            }
            case BOOLEAN: {
                return new DSSTypeSQLMapping(Type.BOOLEAN, 5, "smallint", new Integer[0]);
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        String ret = expr;
        if (requestedType == Type.DATE && exprType == Type.STRING) {
            return "CAST(TRANSLATE(" + ret + ", ' ', 'TZ') AS TIMESTAMP)";
        }
        return super.cast(expr, exprType, requestedType, maxLength);
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return "CAST(" + this.quoteString(str) + " AS TIMESTAMP)";
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        return this.temporalPartExpression(inputDateExpression, part, false);
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        return this.temporalPartExpression(inputDateExpression, part, true);
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        return this.temporalPartExpression(inputDateExpression, part, false);
    }

    private String temporalPartExpression(String inputDateExpression, DatePart part, boolean isDateOnly) {
        String timezoneFix = isDateOnly ? "" : " - CURRENT TIMEZONE";
        switch (part) {
            case DAY_OF_MONTH: {
                return "DAY(" + inputDateExpression + ")";
            }
            case HOUR_OF_DAY: {
                return "HOUR(" + inputDateExpression + ")";
            }
            case MINUTE_OF_HOUR: {
                return "MINUTE(" + inputDateExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                return "SECOND(" + inputDateExpression + ")";
            }
            case MILLISECOND_OF_SECOND: {
                return "FLOOR(MOD(EXTRACT(SECOND FROM " + inputDateExpression + ") * 1000, 1000))";
            }
            case MONTH_OF_YEAR: {
                return "MONTH(" + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "WEEK_ISO(" + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "QUARTER(" + inputDateExpression + ")";
            }
            case YEAR: {
                return "YEAR(" + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "DAYOFWEEK_ISO(" + inputDateExpression + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "cast(86400 as bigint) * cast((DAYS(" + inputDateExpression + timezoneFix + ") - DAYS('1970-01-01')) as bigint) + cast(MIDNIGHT_SECONDS(" + inputDateExpression + timezoneFix + ") as bigint)";
            }
            case MILLIS_FROM_EPOCH: {
                return "(cast(1000 as bigint) * (" + this.temporalPartExpression(inputDateExpression, DatePart.SECOND_FROM_EPOCH, isDateOnly) + ")) + cast((MICROSECOND(" + inputDateExpression + timezoneFix + ")) as bigint) / cast(1000 as bigint)";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on DB2", part));
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding);
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding);
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding);
    }

    private String temporalTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "truncate(" + inputDateExpression + ", 'DD')";
            }
            case HOUR: {
                return "truncate(" + inputDateExpression + ", 'HH')";
            }
            case WEEK: {
                return "truncate(" + inputDateExpression + ", 'WW')";
            }
            case MONTH: {
                return "truncate(" + inputDateExpression + ", 'MM')";
            }
            case YEAR: {
                return "truncate(" + inputDateExpression + ", 'YY')";
            }
            case QUARTER: {
                return "truncate(" + inputDateExpression + ", 'QUARTER')";
            }
            case MINUTE: {
                return "truncate(" + inputDateExpression + ", 'MI')";
            }
            case SECOND: {
                return "truncate(" + inputDateExpression + ", 'SS')";
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        if ((query = query.trim()).toLowerCase().contains("fetch first") && query.toLowerCase().contains("rows only")) {
            return query;
        }
        if (query.toLowerCase().startsWith("select")) {
            if (query.endsWith(";")) {
                query = query.substring(0, query.length() - 1);
            }
            return "SELECT * FROM (\n" + query + "\n) FETCH FIRST " + size + " ROWS ONLY";
        }
        return query;
    }

    @Override
    public SQLDialect.LimitMethod getLimitMethod() {
        return SQLDialect.LimitMethod.FETCH_FIRST_ROWS_FIRST;
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        return "CREATE TABLE " + this.getQuotedTableFullName(table) + "(" + columnListExpr + ")";
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE TABLE " + this.getQuotedTableFullName(table) + " AS (" + selectExpr + ") WITH NO DATA", "INSERT INTO " + this.getQuotedTableFullName(table) + " (" + selectExpr + ")"};
    }

    @Override
    public String getColumnExpressionForBoolean(String booleanExpression) {
        return "CASE WHEN " + booleanExpression + " THEN 1 ELSE 0 END";
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 127;
    }

    @Override
    public boolean supportsIndexing() {
        return true;
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.MultiLineCommentFinder.META, QuotedPortionFinders.SingleQuotedNoEscapeFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.OracleQuotedStringLiteralFinder.META};
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 1024;
    }

    @Override
    public SQLDialect.NaturalJoinSupport getNaturalJoinSupport() {
        return SQLDialect.NaturalJoinSupport.NONE;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public boolean supportsNullsOrdering() {
        return false;
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SHA256, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                return "HASH(" + column + ", 2)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SHA512, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                return "HASH(" + column + ", 3)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CONCAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String first = this.toSQLNoBrackets(args[0]);
                String second = args.length > 2 ? this.apply(Arrays.copyOfRange(args, 1, args.length)) : this.toSQLNoBrackets(args[1]);
                return "CONCAT(" + first + ", " + second + ")";
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.ISTRUE, "isTrue", QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.EQ.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String x = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                return x + " != 0";
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.ISFALSE, "isFalse", QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.EQ.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String x = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                return x + " = 0";
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.NOT, null, QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.NOT.priority, false){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String arg1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.NOT.priority);
                return "NOT " + arg1;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.NE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.OR.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " <> " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                String oneIsNull = null;
                if (!aIsConst && !bIsConst) {
                    oneIsNull = a2 + " IS NULL AND " + b2 + " IS NOT NULL OR " + a2 + " IS NOT NULL AND " + b2 + " IS NULL";
                } else if (!aIsConst) {
                    oneIsNull = a2 + " IS NULL";
                } else if (!bIsConst) {
                    oneIsNull = b2 + " IS NULL";
                }
                if (oneIsNull != null) {
                    ret = ret + " OR " + oneIsNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.GT, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " > " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.LT, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " < " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.GE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " >= " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.LE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " <= " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.EQ, "=", QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.OR.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " = " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                String bothNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNull = a2 + " IS NULL AND " + b2 + " IS NULL";
                }
                if (bothNull != null) {
                    ret = ret + " OR " + bothNull;
                }
                return ret;
            }
        });
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(this, QueryUtils.OperatorType.CONTAINS, false, true));
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(this, QueryUtils.OperatorType.STARTS_WITH, false, true));
        this.addGenericFunction(QueryUtils.OperatorType.MD5, "HASH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.MEDIAN, "MEDIAN", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.DATEDIFF, null, QueryUtils.Arity.NARY, GenericSQLDialect.SQLPriority.PLUS.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String unit;
                String end = this.toSQLNoBrackets(args[0]);
                String start = this.toSQLNoBrackets(args[1]);
                switch (unit = this.getParamAs(args[2], String.class)) {
                    case "YEAR": {
                        return "CAST((MONTHS_BETWEEN(" + end + " , " + start + ") + (HOUR(" + end + ") - HOUR(" + start + ")) / 744.0) / 12 AS BIGINT)";
                    }
                    case "MONTH": {
                        return "CAST(MONTHS_BETWEEN(" + end + " , " + start + ") + (HOUR(" + end + ") - HOUR(" + start + ")) / 744.0 AS BIGINT)";
                    }
                    case "WEEK": {
                        return "CAST(((DAYS(" + end + ") + MIDNIGHT_SECONDS(" + end + ") / 86400.0) - (DAYS(" + start + ") + MIDNIGHT_SECONDS(" + start + ") / 86400.0)) / 7 AS bigint)";
                    }
                    case "DAY": {
                        return "CAST((DAYS(" + end + ") + MIDNIGHT_SECONDS(" + end + ") / 86400.0) - (DAYS(" + start + ") + MIDNIGHT_SECONDS(" + start + ") / 86400.0) AS bigint)";
                    }
                    case "HOUR": {
                        return "TIMESTAMPDIFF(8, CHAR(CAST(" + end + " AS TIMESTAMP) - CAST(" + start + " AS TIMESTAMP)))";
                    }
                    case "MINUTE": {
                        return "TIMESTAMPDIFF(4, CHAR(CAST(" + end + " AS TIMESTAMP) - CAST(" + start + " AS TIMESTAMP)))";
                    }
                    case "SECOND": {
                        return "TIMESTAMPDIFF(2, CHAR(CAST(" + end + " AS TIMESTAMP) - CAST(" + start + " AS TIMESTAMP)))";
                    }
                }
                throw new IllegalArgumentException("Unknown datepart: '" + unit + "'");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_AGG, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "percentile_disc(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_CONT, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "percentile_cont(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                if (args.length > 2 && args[2] != null) {
                    return "TO_UTC_TIMESTAMP(FROM_UTC_TIMESTAMP( " + this.toSQLNoBrackets(args[0]) + ", " + this.toSQLNoBrackets(args[1]) + "), " + this.toSQLNoBrackets(args[2]) + ")";
                }
                if (args.length > 1 && args[1] != null) {
                    return "TO_UTC_TIMESTAMP( " + this.toSQLNoBrackets(args[0]) + ", " + this.toSQLNoBrackets(args[1]) + ")";
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "REGEXP_LIKE(" + input + ", " + regex + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    String converted;
                    String timezoneId;
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String string = timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    if (requestedType == Type.DATEONLY) {
                        String sqlFormat = DB2SQLDialect.this.toDateFormat(jodaFormat, true);
                        return "DATE(TIMESTAMP_FORMAT(" + input + ",'" + sqlFormat + "'))";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        String sqlFormat = DB2SQLDialect.this.toDateFormat(jodaFormat, true);
                        return "TIMESTAMP_FORMAT(" + input + ",'" + sqlFormat + "')";
                    }
                    if (DKUDateUtils.isISO8601FormatString((String)jodaFormat)) {
                        converted = "TIMESTAMP_FORMAT(REPLACE(REPLACE(" + input + ", 'T', ' '), 'Z', '') ,'YYYY-MM-DD HH24:MI:SS.FF')";
                    } else {
                        String sqlFormat = DB2SQLDialect.this.toDateFormat(jodaFormat, true);
                        converted = "TIMESTAMP_FORMAT(" + input + ",'" + sqlFormat + "')";
                    }
                    if (StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        return "FROM_UTC_TIMESTAMP(" + converted + ", 'UTC')";
                    }
                    return "FROM_UTC_TIMESTAMP(TO_UTC_TIMESTAMP(" + converted + ", '" + timezoneId + "'), 'UTC')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = DB2SQLDialect.this.toDateFormat(jodaFormat, false);
                    if (requestedType.isTimestamp() && StringUtils.isNotBlank((String)timezoneId) && !StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        input = "FROM_UTC_TIMESTAMP(TO_UTC_TIMESTAMP(" + (String)input + ", '" + timezoneId + "'), 'UTC')";
                    }
                    return "VARCHAR_FORMAT(" + (String)input + ",'" + sqlFormat + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "TO_TIMESTAMP(", ", 'YYYY-MM-DD HH24:MI:SS')"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.STRING_TO_DATE, "CAST(", " AS DATE)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "TO_TIMESTAMP(", ", 'YYYY-MM-DD HH24:MI:SS')"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATE_ADD, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String datetimeNoTz = this.toSQLNoBrackets(args[0]);
                String addIntLong = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class).toUpperCase();
                if ("YEAR".equals(unit)) {
                    return "ADD_YEARS(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                if ("MONTH".equals(unit)) {
                    return "ADD_MONTHS(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                if ("WEEK".equals(unit)) {
                    return "ADD_DAYS(" + datetimeNoTz + ", 7 * (" + addIntLong + "))";
                }
                if ("DAY".equals(unit)) {
                    return "ADD_DAYS(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                if ("HOUR".equals(unit)) {
                    return "ADD_HOURS(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                if ("MINUTE".equals(unit)) {
                    return "ADD_MINUTES(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                if ("SECOND".equals(unit)) {
                    return "ADD_SECONDS(" + datetimeNoTz + ", " + addIntLong + ")";
                }
                if ("MILLISECOND".equals(unit)) {
                    return "ADD_SECONDS(" + datetimeNoTz + ", 1000 * (" + addIntLong + "))";
                }
                throw new IllegalArgumentException("Date addition for " + unit + " cannot be used for increment");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TRANSLATE, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                String from = this.getParamAs(args[1], String.class);
                String to = this.getParamAs(args[2], String.class);
                return String.format("TRANSLATE(VARGRAPHIC(%s), %s, %s)", input, DB2SQLDialect.this.quoteString(to), DB2SQLDialect.this.quoteString(from));
            }
        });
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        switch (part.type) {
            case MILLISECOND: {
                return "FF";
            }
            case TIMEZONE: {
                if (part.numeric) {
                    return "TZH:TZM";
                }
                throw new IllegalArgumentException("No timezone in db2 formats (only +/-HH:mm timezones)");
            }
            case TEXT: {
                return part.text.replace("'", "''");
            }
        }
        return super.toDateFormatPart(part, forParsing, hasIsoDatePart);
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        if (part.type == DKUDateUtils.FormatPatternPartType.TIMEZONE && forParsing) {
            return SQLCapability.nok("Cannot parse timezones");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUR || part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUROFHALFDAY) {
            return SQLCapability.nok("Cannot handle clock hour");
        }
        if ((part.type == DKUDateUtils.FormatPatternPartType.WEEK || part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR) && forParsing) {
            return SQLCapability.nok("Cannot parse week/year pairs");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.TEXT) {
            HashSet separators = Sets.newHashSet((Object[])new Character[]{Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf(','), Character.valueOf('\''), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf(' ')});
            for (char c2 : part.text.toCharArray()) {
                if (separators.contains(Character.valueOf(c2))) continue;
                return SQLCapability.nok("Cannot use '" + c2 + "' as separator");
            }
            return SQLCapability.ok();
        }
        return SQLCapability.ok();
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.MEDIAN, new SQLAggregateAbility(false, false, true, false));
        return abilities;
    }

    @Override
    public SQLCapability canFormatDate(String jodaFormat, boolean forParsing) {
        if (DKUDateUtils.isISO8601FormatString((String)jodaFormat)) {
            return SQLCapability.ok();
        }
        return super.canFormatDate(jodaFormat, forParsing);
    }

    @Override
    public boolean supportsTransactionalDdl() {
        return true;
    }

    @Override
    public String getId() {
        return "DB2";
    }

    @Override
    public String getLeftoverPipelineViewsQuery(String schema) {
        return "SELECT viewschema, viewname FROM syscat.views WHERE viewname LIKE 'DSSVIEW@_%' ESCAPE '@'" + this.getSchemaConditionForListingViews(schema, "viewschema", " AND viewschema NOT LIKE 'SYS%'");
    }

    @Override
    public boolean supportGroupByIndex() {
        return false;
    }

    @Override
    public String getLogClause(double base, String argument) {
        return this.getLogClauseForSingleArgumentLog(base, argument);
    }
}

