/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps;

import com.dataiku.dip.coremodel.Checklists;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum WebAppAdapter implements JSON.Adapter<WebApp>
{
    INSTANCE;

    private static final Map<String, Class<? extends WebApp.WebAppParams>> webAppParamsMap;
    private static final DKULogger logger;

    public static void registerType(String type, Class<? extends WebApp.WebAppParams> clazz) {
        webAppParamsMap.put(type, clazz);
    }

    public WebApp deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) {
        Class<? extends WebApp.WebAppParams> clazz;
        WebApp webApp = new WebApp();
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!this.has(jsonObj, "type")) {
            throw new IllegalStateException("Cannot deserialize web app: 'type' is required");
        }
        webApp.type = jsonObj.get("type").getAsString();
        webApp.projectKey = this.getStringOrNull(jsonObj, "projectKey");
        webApp.id = this.getStringOrNull(jsonObj, "id");
        if (this.has(jsonObj, "storageFile")) {
            webApp.storageFile = (RelFile)ctx.deserialize(jsonObj.get("storageFile"), RelFile.class);
        }
        if ((clazz = webAppParamsMap.get(webApp.type)) == null) {
            throw new JsonParseException("Web app type " + webApp.type + " is unknown");
        }
        if (this.has(jsonObj, "params")) {
            webApp.params = (WebApp.WebAppParams)ctx.deserialize(jsonObj.get("params"), clazz);
        } else {
            try {
                webApp.params = clazz.newInstance();
            }
            catch (Exception e) {
                logger.info((Object)"Failed to instanciate webapp params", (Throwable)e);
            }
        }
        if (webApp.params == null) {
            throw new JsonParseException("Web params are required");
        }
        if (this.has(jsonObj, "config")) {
            webApp.config = jsonObj.get("config").getAsJsonObject();
        }
        webApp.name = this.getStringOrNull(jsonObj, "name");
        webApp.apiKey = this.getStringOrNull(jsonObj, "apiKey");
        if (this.has(jsonObj, "hasLegacyBackendURL")) {
            webApp.hasLegacyBackendURL = jsonObj.get("hasLegacyBackendURL").getAsBoolean();
        }
        if (this.has(jsonObj, "versionTag")) {
            webApp.versionTag = (VersionTag)ctx.deserialize(jsonObj.get("versionTag"), VersionTag.class);
        }
        if (this.has(jsonObj, "creationTag")) {
            webApp.creationTag = (VersionTag)ctx.deserialize(jsonObj.get("creationTag"), VersionTag.class);
        }
        webApp.description = this.getStringOrNull(jsonObj, "description");
        webApp.shortDesc = this.getStringOrNull(jsonObj, "shortDesc");
        if (this.has(jsonObj, "tags")) {
            webApp.tags = (List)ctx.deserialize(jsonObj.get("tags"), List.class);
        }
        if (this.has(jsonObj, "checklists")) {
            webApp.checklists = (Checklists)ctx.deserialize(jsonObj.get("checklists"), Checklists.class);
        }
        if (this.has(jsonObj, "customFields")) {
            webApp.customFields = jsonObj.getAsJsonObject("customFields");
        }
        if (this.has(jsonObj, "isVirtual")) {
            webApp.isVirtual = jsonObj.get("isVirtual").getAsBoolean();
        }
        return webApp;
    }

    public JsonElement serialize(WebApp webApp, Type type, JsonSerializationContext ctx) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("type", webApp.type);
        jsonObj.addProperty("hasLegacyBackendURL", Boolean.valueOf(webApp.hasLegacyBackendURL));
        if (!JSON.excludesFileTransient((JsonSerializationContext)ctx)) {
            if (webApp.projectKey != null) {
                jsonObj.addProperty("projectKey", webApp.projectKey);
            }
            if (webApp.id != null) {
                jsonObj.addProperty("id", webApp.id);
            }
            if (webApp.storageFile != null) {
                jsonObj.add("storageFile", ctx.serialize((Object)webApp.storageFile));
            }
        }
        if (webApp.params != null) {
            jsonObj.add("params", ctx.serialize((Object)webApp.params));
        }
        if (webApp.config != null) {
            jsonObj.add("config", ctx.serialize((Object)webApp.config));
        }
        if (webApp.name != null) {
            jsonObj.addProperty("name", webApp.name);
        }
        if (webApp.apiKey != null) {
            jsonObj.addProperty("apiKey", webApp.apiKey);
        }
        if (webApp.versionTag != null) {
            jsonObj.add("versionTag", ctx.serialize((Object)webApp.versionTag));
        }
        if (webApp.creationTag != null) {
            jsonObj.add("creationTag", ctx.serialize((Object)webApp.creationTag));
        }
        if (webApp.description != null) {
            jsonObj.addProperty("description", webApp.description);
        }
        if (webApp.shortDesc != null) {
            jsonObj.addProperty("shortDesc", webApp.shortDesc);
        }
        if (webApp.tags != null) {
            jsonObj.add("tags", ctx.serialize((Object)webApp.tags));
        }
        if (webApp.checklists != null) {
            jsonObj.add("checklists", ctx.serialize((Object)webApp.checklists));
        }
        if (webApp.customFields != null) {
            jsonObj.add("customFields", (JsonElement)webApp.customFields);
        }
        jsonObj.addProperty("isVirtual", Boolean.valueOf(webApp.isVirtual));
        return jsonObj;
    }

    private boolean has(JsonObject jsonObj, String field) {
        return jsonObj.has(field) && !jsonObj.get(field).isJsonNull();
    }

    private String getStringOrNull(JsonObject jsonObj, String field) {
        if (this.has(jsonObj, field)) {
            return jsonObj.get(field).getAsString();
        }
        return null;
    }

    static {
        webAppParamsMap = Collections.synchronizedMap(new HashMap());
        logger = DKULogger.getLogger((String)"dku.webapps.serialization");
    }
}

