/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.shiny;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.coremodel.DkuComponentMetadataWithCategory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppTemplate;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendRunner;
import com.dataiku.dip.webapps.plugins.WebAppDesc;
import com.dataiku.dip.webapps.shiny.ShinyWebAppHandler;
import com.dataiku.dip.webapps.shiny.backend.ShinyWebAppBackendRunner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ShinyWebAppMeta
implements WebAppMeta,
MetaWithSelectableCodeEnv {
    public static final String TYPE = "SHINY";
    public static final String LIVELINESS_CHECK_PATH = "/shared/shiny.js";
    private static final WebAppDesc desc = ShinyWebAppMeta.makeDesc();
    public static final ShinyWebAppMeta META = new ShinyWebAppMeta();

    @Override
    public Class<? extends WebApp.WebAppParams> getParamsClass() {
        return ShinyWebAppParams.class;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isCustomWebApp() {
        return false;
    }

    @Override
    public WebAppBackendRunner buildRunner(WebApp webApp, WebAppBackend webAppBackend, JsonObject variables, AuthCtx user, WebAppBackendInstance webAppBackendInstance) {
        return new ShinyWebAppBackendRunner(webApp, webAppBackend, variables, user, webAppBackendInstance);
    }

    @Override
    public WebAppHandler buildHandler(WebApp webapp) {
        return new ShinyWebAppHandler(webapp);
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.R;
    }

    @Override
    public WebAppDesc getWebAppDesc() {
        return desc;
    }

    @Override
    public List<Object> getHashElements(WebApp webApp) {
        ShinyWebAppParams params = webApp.getParamsAs(ShinyWebAppParams.class);
        ArrayList ret = Lists.newArrayList();
        ret.add(params.forceAuthentication);
        ret.add(params.ui);
        ret.add(params.server);
        ret.add(params.envSelection);
        return ret;
    }

    private static WebAppDesc makeDesc() {
        String shortDesc = "Use <a target=\"_blank\" rel=\"noopener noreferrer\" href=\"https://shiny.rstudio.com\">Shiny</a> to generate interactive visualizations using only R";
        DkuComponentMetadataWithCategory data = new DkuComponentMetadataWithCategory("Shiny", shortDesc, "dku-icon-recipe-r-circle-fill-48", null);
        return new WebAppDesc(TYPE, data);
    }

    public static class ShinyWebAppParams
    extends WebApp.WebAppParams
    implements ParamsWithSelectableCodeEnv {
        @JSON.FileTransient
        public String ui = "";
        @JSON.FileTransient
        public String server = "";
        public boolean autoStartBackend;
        public CodeEnvSelection envSelection = new CodeEnvSelection();

        @Override
        public boolean isBackendEnabled() {
            return true;
        }

        @Override
        public boolean isAutoStartBackend() {
            return this.autoStartBackend;
        }

        @Override
        public JsonObject getSensitiveSettings(AuthCtx authCtx) throws IOException, DKUSecurityException {
            Preconditions.checkNotNull((Object)this.server);
            JsonObject ret = super.getSensitiveSettings(authCtx);
            ret.addProperty("type", ShinyWebAppMeta.TYPE);
            ret.addProperty("ui", this.ui);
            ret.addProperty("server", this.server);
            return ret;
        }

        @Override
        public boolean isLoadingPythonLibraries() {
            return false;
        }

        @Override
        public boolean isLoadingRLibraries() {
            return true;
        }

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.envSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.envSelection = envSelection;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList usages = Lists.newArrayList();
            if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.R, this.envSelection.envName, CodeEnvModel.EnvUsage.WEBAPP, object.getProjectKey(), object.getId()));
            }
            return usages;
        }
    }

    public static class ShinyWebAppTemplateMeta
    extends WebAppTemplate {
    }
}

