/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints;

import com.dataiku.dip.ProcessorWithSingleCopyAdditionalInputs;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableSISOWrapper;
import com.dataiku.dip.datalayer.memimpl.MemTableSRPWrapper;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.server.NoOpAdditionalInputAccessor;
import com.dataiku.dip.shaker.server.StepInitException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class PreparationStep {
    private final VariablesContext variablesContext;
    private SerializedShakerScript script;
    private BaseProcessorsFactory.PipelineContext pipelineContext;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.predict.prepare");

    public PreparationStep(File modelFolder, List<UserDefinedMeaning> userDefinedMeanings, VariablesContext vc) throws IOException {
        this.pipelineContext = new BaseProcessorsFactory.PipelineContext(userDefinedMeanings);
        this.script = (SerializedShakerScript)JSON.parseFile((File)new File(modelFolder, "script.json"), SerializedShakerScript.class);
        this.variablesContext = vc;
    }

    public void init() throws Exception {
    }

    public void process(MemTable table) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Data table pre-prepare:\n" + table.dumpToString()));
        }
        int stepIndex = 0;
        for (ProcessorScriptStep step : ScriptUtils.getProcessorsFromSteps(this.script.steps)) {
            this.initAndRunStep(table, step, stepIndex);
            ++stepIndex;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Data table post-prepare:\n" + table.dumpToString()));
        }
    }

    private void initAndRunStep(MemTable table, ProcessorScriptStep step, int stepIndex) throws Exception {
        Processor baseProcessor;
        if (step.disabled) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing script step: " + step.type));
        }
        if (this.variablesContext != null) {
            step.expand(this.variablesContext, stepIndex);
        }
        try {
            baseProcessor = BaseProcessorsFactory.build(step, this.pipelineContext);
        }
        catch (Exception e) {
            throw new StepInitException(-1, step.type, e);
        }
        if (baseProcessor instanceof SingleRowProcessor) {
            SingleRowProcessor srp = (SingleRowProcessor)baseProcessor;
            MemTableSRPWrapper wrapper = new MemTableSRPWrapper(srp);
            wrapper.init();
            this.initAdditionalInputs((Processor)srp);
            wrapper.process(table);
        } else if (baseProcessor instanceof SingleInputSingleOutputRowProcessor) {
            SingleInputSingleOutputRowProcessor siso = (SingleInputSingleOutputRowProcessor)baseProcessor;
            MemTableSISOWrapper wrapper = new MemTableSISOWrapper(siso);
            wrapper.init();
            this.initAdditionalInputs((Processor)siso);
            wrapper.process(table);
        } else {
            throw new Error("Don't know how to run processor for step type " + step.type + ": " + String.valueOf(baseProcessor.getClass()));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Data table after step:\n" + table.dumpToString()));
        }
    }

    private void initAdditionalInputs(Processor processor) throws Exception {
        if (processor instanceof ProcessorWithSingleCopyAdditionalInputs) {
            NoOpAdditionalInputAccessor noop = new NoOpAdditionalInputAccessor();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loading additional inputs on processor " + String.valueOf(processor)));
            }
            ProcessorWithSingleCopyAdditionalInputs pwscai = (ProcessorWithSingleCopyAdditionalInputs)processor;
            Object loader = pwscai.buildLoader();
            loader.loadAdditionalInputs(noop);
            pwscai.setAdditionalInputs(loader);
        }
    }
}

