/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;

public class DecodeFromBase64
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length >= 1 && args[0] != null) {
            Object o = args[0];
            String s = o instanceof String ? (String)o : o.toString();
            String charset = "utf-8";
            if (args.length >= 2 && args[1] != null) {
                Object charsetO = args[1];
                charset = charsetO instanceof String ? (String)charsetO : charsetO.toString();
            }
            try {
                byte[] bytes = Base64.decodeBase64((String)s);
                return new String(bytes, charset);
            }
            catch (UnsupportedEncodingException e) {
                return new EvalError("The base64 string '" + s + "' cannot be decoded in " + charset);
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a string");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.DecodeFromBase64.DOCUMENTATION", "Returns the string whose Base64 representation is given. By default, the string is read using the UTF-8 charset.").withParams("string s, [string charset]").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"SA==\"").returns("\"H\""));
    }
}

