/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.spark.GlobalMetastoreHiveConfig$;
import com.dataiku.dip.spark.LocalMetastoreHiveConfig$;
import com.dataiku.dip.spark.SparkJobFilesInitialFetchRequest;
import com.dataiku.dip.spark.submit.DKUSparkKubernetesEntrypoint;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.ClassLoaderObjectInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Mirrors;
import scala.reflect.api.Symbols;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class package$ {
    public static package$ MODULE$;
    private DataType datetimeNoTzDataType;
    private ThreadLocal<Boolean> _booleanMeaning;
    private ThreadLocal<Date> _dateMeaning;
    private ThreadLocal<DateOnly> _dateOnlyMeaning;
    private ThreadLocal<DatetimeNoTz> _datetimeNoTzMeaning;
    private volatile byte bitmap$0;

    static {
        new package$();
    }

    private DataType datetimeNoTzDataType$lzycompute() {
        package$ package$2 = this;
        synchronized (package$2) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String sparkVersion = System.getenv().getOrDefault("DKU_SPARK_VERSION", org.apache.spark.package$.MODULE$.SPARK_VERSION());
                boolean is34OrMore = !sparkVersion.isBlank() ? package$.liftedTree1$1(sparkVersion) : false;
                this.datetimeNoTzDataType = is34OrMore ? package$.liftedTree2$1() : TimestampType$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.datetimeNoTzDataType;
    }

    public DataType datetimeNoTzDataType() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.datetimeNoTzDataType$lzycompute();
        }
        return this.datetimeNoTzDataType;
    }

    public Tuple3<JavaSparkContext, SQLContext, Object> startSparkContextAndSetupSQLContext(Map<String, String> jconf, String hiveDB, boolean loadDefaults) {
        Tuple3<SparkContext, SQLContext, Object> tuple3;
        SparkConf sparkConf = new SparkConf(loadDefaults);
        sparkConf.setAll((Iterable)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(jconf).asScala()).toMap(Predef$.MODULE$.$conforms()));
        Tuple3<SparkContext, SQLContext, Object> tuple32 = tuple3 = hiveDB != null && hiveDB.length() > 0 ? this.setupSQLContext(GlobalMetastoreHiveConfig$.MODULE$.apply("ExternalDSSJob"), (Option<String>)new Some((Object)hiveDB), sparkConf) : this.setupSQLContext(LocalMetastoreHiveConfig$.MODULE$.apply(sparkConf, "ExternalDSSJob"), (Option<String>)None$.MODULE$, sparkConf);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        SparkContext sc = (SparkContext)tuple3._1();
        SQLContext ssc = (SQLContext)tuple3._2();
        boolean isHive = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple3 tuple33 = new Tuple3((Object)sc, (Object)ssc, (Object)BoxesRunTime.boxToBoolean((boolean)isHive));
        SparkContext sc2 = (SparkContext)tuple33._1();
        SQLContext ssc2 = (SQLContext)tuple33._2();
        boolean isHive2 = BoxesRunTime.unboxToBoolean((Object)tuple33._3());
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(sc2);
        return new Tuple3((Object)jsc, (Object)ssc2, (Object)BoxesRunTime.boxToBoolean((boolean)isHive2));
    }

    public Tuple2<SQLContext, Object> createSQLContext(Map<String, String> jconf, String hiveDB, JavaSparkContext jsc) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = hiveDB != null && hiveDB.length() > 0 ? new Tuple2((Object)new Some((Object)hiveDB), GlobalMetastoreHiveConfig$.MODULE$.apply("ExternalDSSJob")) : new Tuple2((Object)None$.MODULE$, LocalMetastoreHiveConfig$.MODULE$.apply(jsc.getConf(), "ExternalDSSJob"));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option hiveDBOption = (Option)tuple2._1();
        scala.collection.immutable.Map hiveConfig = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)hiveDBOption, (Object)hiveConfig);
        Option hiveDBOption2 = (Option)tuple23._1();
        scala.collection.immutable.Map hiveConfig2 = (scala.collection.immutable.Map)tuple23._2();
        return this.createSQLContext((scala.collection.immutable.Map<String, String>)hiveConfig2.$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(jconf).asScala()).toMap(Predef$.MODULE$.$conforms())), (Option<String>)hiveDBOption2, jsc.sc());
    }

    public Tuple3<SparkContext, SQLContext, Object> setupSQLContext(scala.collection.immutable.Map<String, String> hiveConfig, Option<String> hiveDB, SparkConf conf) {
        SparkContext sparkContext;
        conf.setAll(hiveConfig);
        boolean bl = com.dataiku.dip.remoterun.package$.MODULE$.isDatabricks();
        if (!bl) {
            SparkContext sc = new SparkContext(conf);
            SparkJobFilesInitialFetchRequest fr = DKUSparkKubernetesEntrypoint.getFetchRequest();
            if (fr != null) {
                ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(fr.pathsToDistribute).asScala()).toList().foreach((Function1 & Serializable & scala.Serializable)path -> {
                    sc.addFile(path);
                    return BoxedUnit.UNIT;
                });
            }
            sparkContext = sc;
        } else if (bl) {
            sparkContext = SparkContext$.MODULE$.getOrCreate();
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        SparkContext sc = sparkContext;
        Tuple2<SQLContext, Object> tuple2 = this.createSQLContext(hiveConfig, hiveDB, sc);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        SQLContext ssc = (SQLContext)tuple2._1();
        boolean isHive = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)ssc, (Object)BoxesRunTime.boxToBoolean((boolean)isHive));
        SQLContext ssc2 = (SQLContext)tuple22._1();
        boolean isHive2 = tuple22._2$mcZ$sp();
        this.addRemoteRunEnvDefForExecutors(sc);
        return new Tuple3((Object)sc, (Object)ssc2, (Object)BoxesRunTime.boxToBoolean((boolean)isHive2));
    }

    public SparkConf setupSQLContext$default$3() {
        return new SparkConf();
    }

    public Tuple2<SQLContext, Object> createSQLContext(scala.collection.immutable.Map<String, String> hiveConfig, Option<String> hiveDB, SparkContext sc) {
        Throwable e;
        Logger logger = Logger.getLogger((String)"dku.spark.sql");
        sc.getConf().setAll(hiveConfig);
        String currentCatalogImplementation = sc.getConf().get("spark.sql.catalogImplementation", null);
        if ("in-memory".equals(currentCatalogImplementation)) {
            return new Tuple2((Object)new SQLContext(sc), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        boolean bl = false;
        Failure failure = null;
        Try<SQLContext> try_ = com.dataiku.dip.spark.compat.package$.MODULE$.instantiateHiveContext(hiveConfig, sc);
        if (try_ instanceof Success) {
            Failure failure2;
            Throwable e2;
            Success success = (Success)try_;
            SQLContext hiveContext = (SQLContext)success.value();
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                hiveDB.filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isEmpty())).foreach((Function1 & Serializable & scala.Serializable)db -> {
                    logger.info((Object)new StringBuilder(19).append("Hive metastore DB: ").append((String)db).toString());
                    return hiveContext.sql(new StringBuilder(4).append("USE ").append((String)db).toString());
                });
                return hiveContext;
            });
            if (try_2 instanceof Success) {
                Success success2 = (Success)try_2;
                SQLContext hiveContext2 = (SQLContext)success2.value();
                return new Tuple2((Object)hiveContext2, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            if (try_2 instanceof Failure && (e2 = (failure2 = (Failure)try_2).exception()) instanceof Exception) {
                Exception exception = (Exception)e2;
                Object object = currentCatalogImplementation != null ? sc.getConf().set("spark.sql.catalogImplementation", currentCatalogImplementation) : BoxedUnit.UNIT;
                logger.warn((Object)"Could not instantiate HiveContext with desired db, falling back to SQLContext", (Throwable)exception);
                return new Tuple2((Object)new SQLContext(sc), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            throw new MatchError((Object)try_2);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable e3 = failure.exception();
            if (e3 instanceof Exception) {
                Exception exception = (Exception)e3;
                if (hiveDB.isDefined()) {
                    logger.error((Object)"Could not instantiate HiveContext, is Spark properly set up for Hadoop?", (Throwable)exception);
                    throw exception;
                }
            }
        }
        if (bl && (e = failure.exception()) instanceof Exception) {
            Exception exception = (Exception)e;
            Object object = currentCatalogImplementation != null ? sc.getConf().set("spark.sql.catalogImplementation", currentCatalogImplementation) : BoxedUnit.UNIT;
            logger.warn((Object)new StringBuilder(63).append("Could not instantiate HiveContext, falling back to SQLContext: ").append(ExceptionUtils.getMessageWithCauses((Throwable)exception)).toString());
            return new Tuple2((Object)new SQLContext(sc), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        throw new MatchError(try_);
    }

    public void addRemoteRunEnvDefForExecutors(SparkContext sc) {
        File f = new File("remote-run-env-def.json");
        if (f.exists()) {
            Logger.getLogger((String)"dku").info((Object)"passing env def to executors");
            sc.addFile(f.getAbsolutePath());
            return;
        }
    }

    public Configuration getSparkHadoopUtilConf() {
        Class<?> sparkHadoopUtilClass = Class.forName("org.apache.spark.deploy.SparkHadoopUtil");
        Field sparkHadoopUtilConfField = sparkHadoopUtilClass.getDeclaredField("conf");
        sparkHadoopUtilConfField.setAccessible(true);
        Object sparkHadoopUtilInstance = sparkHadoopUtilClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
        return (Configuration)sparkHadoopUtilConfField.get(sparkHadoopUtilInstance);
    }

    public StructField dkuToSpark(SchemaColumn c2) {
        DoubleType$ doubleType$;
        String name = c2.getName();
        Type type = c2.getType();
        if (Type.DOUBLE.equals(type)) {
            doubleType$ = DoubleType$.MODULE$;
        } else if (Type.BOOLEAN.equals(type)) {
            doubleType$ = BooleanType$.MODULE$;
        } else if (Type.FLOAT.equals(type)) {
            doubleType$ = FloatType$.MODULE$;
        } else if (Type.BIGINT.equals(type)) {
            doubleType$ = LongType$.MODULE$;
        } else if (Type.INT.equals(type)) {
            doubleType$ = IntegerType$.MODULE$;
        } else if (Type.SMALLINT.equals(type)) {
            doubleType$ = ShortType$.MODULE$;
        } else if (Type.TINYINT.equals(type)) {
            doubleType$ = ByteType$.MODULE$;
        } else if (Type.STRING.equals(type)) {
            doubleType$ = StringType$.MODULE$;
        } else if (Type.DATE.equals(type)) {
            doubleType$ = TimestampType$.MODULE$;
        } else if (Type.DATEONLY.equals(type)) {
            doubleType$ = DateType$.MODULE$;
        } else if (Type.DATETIMENOTZ.equals(type)) {
            doubleType$ = this.datetimeNoTzDataType();
        } else {
            if (Type.GEOPOINT.equals(type)) {
                throw new UnsupportedOperationException(new StringBuilder(63).append("Spark schema: GEOPOINT columns are not supported (in column '").append(name).append("')").toString());
            }
            if (Type.GEOMETRY.equals(type)) {
                throw new UnsupportedOperationException(new StringBuilder(63).append("Spark schema: GEOMETRY columns are not supported (in column '").append(name).append("')").toString());
            }
            if (Type.ARRAY.equals(type)) {
                if (c2.arrayContent == null || c2.arrayContent.getType() == null) {
                    throw new UnsupportedOperationException(new StringBuilder(75).append("Spark schema: Cannot handle an ARRAY without specified content type (in '").append(name).append("')").toString());
                }
                doubleType$ = ArrayType$.MODULE$.apply(this.dkuToSpark(c2.arrayContent).dataType());
            } else if (Type.MAP.equals(type)) {
                if (c2.mapKeys == null || c2.mapKeys.getType() == null) {
                    throw new UnsupportedOperationException(new StringBuilder(68).append("Spark schema: Cannot handle a MAP without specified key type (in '").append(name).append("')").toString());
                }
                Type type2 = c2.mapKeys.getType();
                Type type3 = Type.STRING;
                if (type2 == null ? type3 != null : !type2.equals(type3)) {
                    throw new UnsupportedOperationException(new StringBuilder(62).append("Spark schema: cannot handle a MAP with non-string keys (in '").append(name).append("')").toString());
                }
                if (c2.mapValues == null || c2.mapValues.getType() == null) {
                    throw new UnsupportedOperationException(new StringBuilder(68).append("Spark schema: Cannot handle a MAP without specified key type (in '").append(name).append("')").toString());
                }
                doubleType$ = MapType$.MODULE$.apply(this.dkuToSpark(c2.mapKeys).dataType(), this.dkuToSpark(c2.mapValues).dataType());
            } else if (Type.OBJECT.equals(type)) {
                if (c2.objectFields == null || JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(c2.objectFields).length() == 0) {
                    throw new UnsupportedOperationException(new StringBuilder(70).append("Spark schema: Cannot handle an OBJECT without specified fields (in '").append(name).append("')").toString());
                }
                doubleType$ = StructType$.MODULE$.apply((Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(c2.objectFields).map((Function1 & Serializable & scala.Serializable)c -> MODULE$.dkuToSpark((SchemaColumn)c), Buffer$.MODULE$.canBuildFrom()));
            } else {
                throw new MatchError((Object)type);
            }
        }
        return new StructField(name, (DataType)doubleType$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public StructType dkuToSpark(List<SchemaColumn> cols) {
        return StructType$.MODULE$.apply((Seq)cols.map((Function1 & Serializable & scala.Serializable)c -> MODULE$.dkuToSpark((SchemaColumn)c), List$.MODULE$.canBuildFrom()));
    }

    public StructType dkuToSpark(Schema schema) {
        return this.dkuToSpark((List<SchemaColumn>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(schema.columns).toList());
    }

    public Object dkuStringToSparkInternal(String v, SchemaColumn colSchema) {
        Type type;
        Type colType;
        block42: {
            block41: {
                colType = colSchema.getType();
                if (v == null) break block41;
                if (!v.isEmpty()) break block42;
                Type type2 = colType;
                Type type3 = Type.STRING;
                if (!(type2 == null ? type3 != null : !type2.equals(type3))) break block42;
            }
            return null;
        }
        if (Type.BOOLEAN.equals(type = colType)) {
            return BoxesRunTime.boxToBoolean((boolean)this.booleanMeaning().parse(v));
        }
        if (Type.TINYINT.equals(type)) {
            Byte by;
            try {
                by = BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(v)).toByte());
            }
            catch (NumberFormatException numberFormatException) {
                by = null;
            }
            return by;
        }
        if (Type.SMALLINT.equals(type)) {
            Short s;
            try {
                s = BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(v)).toShort());
            }
            catch (NumberFormatException numberFormatException) {
                s = null;
            }
            return s;
        }
        if (Type.INT.equals(type)) {
            Integer n;
            try {
                n = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(v)).toInt());
            }
            catch (NumberFormatException numberFormatException) {
                n = null;
            }
            return n;
        }
        if (Type.BIGINT.equals(type)) {
            Long l;
            try {
                l = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(v)).toLong());
            }
            catch (NumberFormatException numberFormatException) {
                l = null;
            }
            return l;
        }
        if (Type.FLOAT.equals(type)) {
            Float f;
            try {
                f = BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(v)).toFloat());
            }
            catch (NumberFormatException numberFormatException) {
                f = BoxesRunTime.boxToFloat((float)Float.NaN);
            }
            return f;
        }
        if (Type.DOUBLE.equals(type)) {
            Double d;
            try {
                d = BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(v)).toDouble());
            }
            catch (NumberFormatException numberFormatException) {
                d = BoxesRunTime.boxToDouble((double)Double.NaN);
            }
            return d;
        }
        if (Type.DATE.equals(type)) {
            long timestamp = this.dateMeaning().msSinceEpoch(v);
            if (timestamp == Long.MAX_VALUE) {
                return null;
            }
            return BoxesRunTime.boxToLong((long)(timestamp * 1000L));
        }
        if (Type.DATEONLY.equals(type)) {
            long timestamp = this.dateOnlyMeaning().msSinceEpoch(v);
            if (timestamp == Long.MAX_VALUE) {
                return null;
            }
            return BoxesRunTime.boxToInteger((int)((int)(timestamp / 86400000L)));
        }
        if (Type.DATETIMENOTZ.equals(type)) {
            long timestamp = this.datetimeNoTzMeaning().msSinceEpoch(v);
            if (timestamp == Long.MAX_VALUE) {
                DataType dataType = this.datetimeNoTzDataType();
                TimestampType$ timestampType$ = TimestampType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null)) {
                    long timestamp2 = this.dateMeaning().msSinceEpoch(v);
                    if (timestamp2 == Long.MAX_VALUE) {
                        return null;
                    }
                    return BoxesRunTime.boxToLong((long)(timestamp2 * 1000L));
                }
                return null;
            }
            return BoxesRunTime.boxToLong((long)(timestamp * 1000L));
        }
        if (Type.GEOPOINT.equals(type)) {
            throw new UnsupportedOperationException("GEOPOINT columns are not supported on Spark");
        }
        if (Type.GEOMETRY.equals(type)) {
            throw new UnsupportedOperationException("GEOMETRY columns are not supported on Spark");
        }
        if (Type.ARRAY.equals(type)) {
            Object object;
            try {
                object = this.dkuToSparkInternalArray(new JSONArray(v), colSchema);
            }
            catch (JSONException jSONException) {
                object = null;
            }
            catch (ClassCastException classCastException) {
                object = null;
            }
            return object;
        }
        if (Type.MAP.equals(type) ? true : Type.OBJECT.equals(type)) {
            Object object;
            try {
                object = this.dkuToSparkInternalObj(new JSONObject(v), colSchema);
            }
            catch (JSONException jSONException) {
                object = null;
            }
            catch (ClassCastException classCastException) {
                object = null;
            }
            return object;
        }
        return UTF8String.fromString((String)v);
    }

    public Object dkuToSpark(String v, SchemaColumn colSchema) {
        Type type;
        Type colType;
        block43: {
            block42: {
                colType = colSchema.getType();
                if (v == null) break block42;
                if (!v.isEmpty()) break block43;
                Type type2 = colType;
                Type type3 = Type.STRING;
                if (!(type2 == null ? type3 != null : !type2.equals(type3))) break block43;
            }
            return null;
        }
        if (Type.BOOLEAN.equals(type = colType)) {
            return BoxesRunTime.boxToBoolean((boolean)this.booleanMeaning().parse(v));
        }
        if (Type.TINYINT.equals(type)) {
            Byte by;
            try {
                by = BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(v)).toByte());
            }
            catch (NumberFormatException numberFormatException) {
                by = null;
            }
            return by;
        }
        if (Type.SMALLINT.equals(type)) {
            Short s;
            try {
                s = BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(v)).toShort());
            }
            catch (NumberFormatException numberFormatException) {
                s = null;
            }
            return s;
        }
        if (Type.INT.equals(type)) {
            Integer n;
            try {
                n = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(v)).toInt());
            }
            catch (NumberFormatException numberFormatException) {
                n = null;
            }
            return n;
        }
        if (Type.BIGINT.equals(type)) {
            Long l;
            try {
                l = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(v)).toLong());
            }
            catch (NumberFormatException numberFormatException) {
                l = null;
            }
            return l;
        }
        if (Type.FLOAT.equals(type)) {
            Float f;
            try {
                f = BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(v)).toFloat());
            }
            catch (NumberFormatException numberFormatException) {
                f = BoxesRunTime.boxToFloat((float)Float.NaN);
            }
            return f;
        }
        if (Type.DOUBLE.equals(type)) {
            Double d;
            try {
                d = BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(v)).toDouble());
            }
            catch (NumberFormatException numberFormatException) {
                d = BoxesRunTime.boxToDouble((double)Double.NaN);
            }
            return d;
        }
        if (Type.DATE.equals(type)) {
            long timestamp = this.dateMeaning().msSinceEpoch(v);
            if (timestamp == Long.MAX_VALUE) {
                return null;
            }
            return new Timestamp(timestamp);
        }
        if (Type.DATEONLY.equals(type)) {
            long timestamp = this.dateOnlyMeaning().msSinceEpoch(v);
            if (timestamp == Long.MAX_VALUE) {
                return null;
            }
            return new java.sql.Date(timestamp);
        }
        if (Type.DATETIMENOTZ.equals(type)) {
            DataType dataType = this.datetimeNoTzDataType();
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            if (!(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null)) {
                long timestamp = this.datetimeNoTzMeaning().msSinceEpoch(v);
                if (timestamp == Long.MAX_VALUE) {
                    long timestamp2 = this.dateMeaning().msSinceEpoch(v);
                    if (timestamp2 == Long.MAX_VALUE) {
                        return null;
                    }
                    return new Timestamp(timestamp2);
                }
                return new Timestamp(timestamp);
            }
            long timestamp = this.datetimeNoTzMeaning().msSinceEpoch(v);
            if (timestamp == Long.MAX_VALUE) {
                return null;
            }
            return LocalDateTime.ofEpochSecond(timestamp / 1000L, (int)(timestamp % 1000L * 1000000L), ZoneOffset.UTC);
        }
        if (Type.GEOPOINT.equals(type)) {
            throw new UnsupportedOperationException("GEOPOINT columns are not supported on Spark");
        }
        if (Type.GEOMETRY.equals(type)) {
            throw new UnsupportedOperationException("GEOMETRY columns are not supported on Spark");
        }
        if (Type.ARRAY.equals(type)) {
            Object object;
            try {
                object = this.dkuToSparkArray(new JSONArray(v), colSchema);
            }
            catch (JSONException jSONException) {
                object = null;
            }
            catch (ClassCastException classCastException) {
                object = null;
            }
            return object;
        }
        if (Type.MAP.equals(type) ? true : Type.OBJECT.equals(type)) {
            Object object;
            try {
                object = this.dkuToSparkObj(new JSONObject(v), colSchema);
            }
            catch (JSONException jSONException) {
                object = null;
            }
            catch (ClassCastException classCastException) {
                object = null;
            }
            return object;
        }
        return v;
    }

    public Object dkuToSparkArray(JSONArray a, SchemaColumn colSchema) {
        if (a == null || a.equals(null)) {
            return null;
        }
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), a.length()).map((Function1 & Serializable & scala.Serializable)i -> package$.MODULE$.dkuToSparkObj(a.opt(BoxesRunTime.unboxToInt((Object)i)), colSchema.arrayContent), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Object dkuToSparkInternalArray(JSONArray a, SchemaColumn colSchema) {
        if (a == null || a.equals(null)) {
            return null;
        }
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), a.length()).map((Function1 & Serializable & scala.Serializable)i -> package$.MODULE$.dkuToSparkInternalObj(a.opt(BoxesRunTime.unboxToInt((Object)i)), colSchema.arrayContent), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Object dkuToSparkObj(Object o, SchemaColumn colSchema) {
        if (o == null || o.equals(null)) {
            return null;
        }
        Type type = colSchema.getType();
        if (Type.BOOLEAN.equals(type)) {
            return BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)o));
        }
        if (Type.TINYINT.equals(type)) {
            return BoxesRunTime.boxToByte((byte)((Number)o).byteValue());
        }
        if (Type.SMALLINT.equals(type)) {
            return BoxesRunTime.boxToShort((short)((Number)o).shortValue());
        }
        if (Type.INT.equals(type)) {
            return BoxesRunTime.boxToInteger((int)((Number)o).intValue());
        }
        if (Type.BIGINT.equals(type)) {
            return BoxesRunTime.boxToLong((long)((Number)o).longValue());
        }
        if (Type.FLOAT.equals(type)) {
            return BoxesRunTime.boxToFloat((float)((Number)o).floatValue());
        }
        if (Type.DOUBLE.equals(type)) {
            return BoxesRunTime.boxToDouble((double)((Number)o).doubleValue());
        }
        if (Type.DATE.equals(type)) {
            return this.dkuToSpark((String)o, colSchema);
        }
        if (Type.DATEONLY.equals(type)) {
            return this.dkuToSpark((String)o, colSchema);
        }
        if (Type.DATETIMENOTZ.equals(type)) {
            return this.dkuToSpark((String)o, colSchema);
        }
        if (Type.GEOPOINT.equals(type)) {
            throw new UnsupportedOperationException("GEOPOINT columns are not supported on Spark");
        }
        if (Type.GEOMETRY.equals(type)) {
            throw new UnsupportedOperationException("GEOMETRY columns are not supported on Spark");
        }
        if (Type.ARRAY.equals(type)) {
            return this.dkuToSparkArray((JSONArray)o, colSchema);
        }
        if (Type.MAP.equals(type)) {
            JSONObject jObj = (JSONObject)o;
            return JavaConversions$.MODULE$.deprecated$u0020asScalaIterator(jObj.keys()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string = x0$1;
                if (string != null) {
                    String string2 = string;
                    return new Tuple2((Object)string2, MODULE$.dkuToSparkObj(jObj.opt(string2), colSchema$3.mapValues));
                }
                throw new MatchError((Object)string);
            }).toMap(Predef$.MODULE$.$conforms());
        }
        if (Type.OBJECT.equals(type)) {
            JSONObject jObj = (JSONObject)o;
            Buffer seq = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(colSchema.objectFields).map((Function1 & Serializable & scala.Serializable)sc -> MODULE$.dkuToSparkObj(jObj.opt(sc.getName()), (SchemaColumn)sc), Buffer$.MODULE$.canBuildFrom());
            return Row$.MODULE$.fromSeq((Seq)seq);
        }
        return o.toString();
    }

    public Object dkuToSparkInternalObj(Object o, SchemaColumn colSchema) {
        if (o == null || o.equals(null)) {
            return null;
        }
        Type type = colSchema.getType();
        if (Type.BOOLEAN.equals(type)) {
            return BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)o));
        }
        if (Type.TINYINT.equals(type)) {
            return BoxesRunTime.boxToByte((byte)((Number)o).byteValue());
        }
        if (Type.SMALLINT.equals(type)) {
            return BoxesRunTime.boxToShort((short)((Number)o).shortValue());
        }
        if (Type.INT.equals(type)) {
            return BoxesRunTime.boxToInteger((int)((Number)o).intValue());
        }
        if (Type.BIGINT.equals(type)) {
            return BoxesRunTime.boxToLong((long)((Number)o).longValue());
        }
        if (Type.FLOAT.equals(type)) {
            return BoxesRunTime.boxToFloat((float)((Number)o).floatValue());
        }
        if (Type.DOUBLE.equals(type)) {
            return BoxesRunTime.boxToDouble((double)((Number)o).doubleValue());
        }
        if (Type.DATE.equals(type)) {
            return this.dkuStringToSparkInternal((String)o, colSchema);
        }
        if (Type.DATEONLY.equals(type)) {
            return this.dkuStringToSparkInternal((String)o, colSchema);
        }
        if (Type.DATETIMENOTZ.equals(type)) {
            return this.dkuStringToSparkInternal((String)o, colSchema);
        }
        if (Type.GEOPOINT.equals(type)) {
            throw new UnsupportedOperationException("GEOPOINT columns are not supported on Spark");
        }
        if (Type.GEOMETRY.equals(type)) {
            throw new UnsupportedOperationException("GEOMETRY columns are not supported on Spark");
        }
        if (Type.ARRAY.equals(type)) {
            return this.dkuToSparkInternalArray((JSONArray)o, colSchema);
        }
        if (Type.MAP.equals(type)) {
            JSONObject jObj = (JSONObject)o;
            return JavaConversions$.MODULE$.deprecated$u0020asScalaIterator(jObj.keys()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string = x0$1;
                if (string != null) {
                    String string2 = string;
                    return new Tuple2((Object)UTF8String.fromString((String)string2), MODULE$.dkuToSparkInternalObj(jObj.opt(string2), colSchema$4.mapValues));
                }
                throw new MatchError((Object)string);
            }).toMap(Predef$.MODULE$.$conforms());
        }
        if (Type.OBJECT.equals(type)) {
            JSONObject jObj = (JSONObject)o;
            Buffer seq = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(colSchema.objectFields).map((Function1 & Serializable & scala.Serializable)sc -> MODULE$.dkuToSparkInternalObj(jObj.opt(sc.getName()), (SchemaColumn)sc), Buffer$.MODULE$.canBuildFrom());
            return InternalRow$.MODULE$.fromSeq((Seq)seq);
        }
        return UTF8String.fromString((String)o.toString());
    }

    private ThreadLocal<Boolean> _booleanMeaning$lzycompute() {
        package$ package$2 = this;
        synchronized (package$2) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this._booleanMeaning = new ThreadLocal();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this._booleanMeaning;
    }

    private ThreadLocal<Boolean> _booleanMeaning() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this._booleanMeaning$lzycompute();
        }
        return this._booleanMeaning;
    }

    public Boolean booleanMeaning() {
        block0: {
            if (this._booleanMeaning().get() != null) break block0;
            this._booleanMeaning().set(new Boolean());
        }
        return this._booleanMeaning().get();
    }

    private ThreadLocal<Date> _dateMeaning$lzycompute() {
        package$ package$2 = this;
        synchronized (package$2) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this._dateMeaning = new ThreadLocal();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this._dateMeaning;
    }

    private ThreadLocal<Date> _dateMeaning() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this._dateMeaning$lzycompute();
        }
        return this._dateMeaning;
    }

    private ThreadLocal<DateOnly> _dateOnlyMeaning$lzycompute() {
        package$ package$2 = this;
        synchronized (package$2) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this._dateOnlyMeaning = new ThreadLocal();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this._dateOnlyMeaning;
    }

    private ThreadLocal<DateOnly> _dateOnlyMeaning() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this._dateOnlyMeaning$lzycompute();
        }
        return this._dateOnlyMeaning;
    }

    private ThreadLocal<DatetimeNoTz> _datetimeNoTzMeaning$lzycompute() {
        package$ package$2 = this;
        synchronized (package$2) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this._datetimeNoTzMeaning = new ThreadLocal();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this._datetimeNoTzMeaning;
    }

    private ThreadLocal<DatetimeNoTz> _datetimeNoTzMeaning() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this._datetimeNoTzMeaning$lzycompute();
        }
        return this._datetimeNoTzMeaning;
    }

    public Date dateMeaning() {
        block0: {
            if (this._dateMeaning().get() != null) break block0;
            this._dateMeaning().set(new Date());
        }
        return this._dateMeaning().get();
    }

    public DateOnly dateOnlyMeaning() {
        block0: {
            if (this._dateOnlyMeaning().get() != null) break block0;
            this._dateOnlyMeaning().set(new DateOnly());
        }
        return this._dateOnlyMeaning().get();
    }

    public DatetimeNoTz datetimeNoTzMeaning() {
        block0: {
            if (this._datetimeNoTzMeaning().get() != null) break block0;
            this._datetimeNoTzMeaning().set(new DatetimeNoTz());
        }
        return this._datetimeNoTzMeaning().get();
    }

    public SchemaColumn sparkToDku(StructField f) {
        DataType dataType;
        DataType dataType2 = f.dataType();
        TimestampType$ timestampType$ = TimestampType$.MODULE$;
        if (dataType2 == null ? timestampType$ != null : !dataType2.equals(timestampType$)) {
            DataType dataType3 = f.dataType();
            DataType dataType4 = this.datetimeNoTzDataType();
            if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
                return new SchemaColumn(f.name(), Type.DATETIMENOTZ);
            }
        }
        if (BooleanType$.MODULE$.equals(dataType = f.dataType())) {
            return new SchemaColumn(f.name(), Type.BOOLEAN);
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return new SchemaColumn(f.name(), Type.TINYINT);
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return new SchemaColumn(f.name(), Type.SMALLINT);
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return new SchemaColumn(f.name(), Type.INT);
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return new SchemaColumn(f.name(), Type.BIGINT);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new SchemaColumn(f.name(), Type.FLOAT);
        }
        if (dataType instanceof DecimalType) {
            return new SchemaColumn(f.name(), Type.DOUBLE);
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new SchemaColumn(f.name(), Type.DOUBLE);
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return new SchemaColumn(f.name(), Type.DATE);
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return new SchemaColumn(f.name(), Type.DATEONLY);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            SchemaColumn sc = new SchemaColumn(f.name(), Type.ARRAY);
            sc.arrayContent = this.sparkToDku(new StructField("_arraycontent_", elementType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
            return sc;
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            DataType dataType5 = keyType;
            StringType$ stringType$ = StringType$.MODULE$;
            Predef$.MODULE$.require(!(dataType5 != null ? !dataType5.equals(stringType$) : stringType$ != null), (Function0 & Serializable & scala.Serializable)() -> "map with non-string keys not supported");
            SchemaColumn sc = new SchemaColumn(f.name(), Type.MAP);
            sc.mapKeys = this.sparkToDku(new StructField("_mapkeys_", keyType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
            sc.mapValues = this.sparkToDku(new StructField("_mapvalues_", valueType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
            return sc;
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            SchemaColumn sc = new SchemaColumn(f.name(), Type.OBJECT);
            sc.objectFields = JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.sparkToDku((StructField)x$5), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SchemaColumn.class))))).toList());
            return sc;
        }
        return new SchemaColumn(f.name(), Type.STRING);
    }

    public String sparkToDku(Row row, int colIdx, DataType colType, Type dsType) {
        DataType dataType;
        DataType dataType2 = colType;
        TimestampType$ timestampType$ = TimestampType$.MODULE$;
        if (dataType2 == null ? timestampType$ != null : !dataType2.equals(timestampType$)) {
            DataType dataType3 = colType;
            DataType dataType4 = this.datetimeNoTzDataType();
            if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
                return DKUtils.isoFormatReadableByDatetimeNoTzFormat((long)((ChronoLocalDateTime)row.getAs(colIdx)).toInstant(ZoneOffset.UTC).toEpochMilli());
            }
        }
        if (BooleanType$.MODULE$.equals(dataType = colType)) {
            if (row.getBoolean(colIdx)) {
                return "true";
            }
            return "false";
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return DKUtils.isoFormatReadableByDateFormat((long)((Timestamp)row.getAs(colIdx)).getTime());
        }
        if (DateType$.MODULE$.equals(dataType)) {
            Type type = dsType;
            Type type2 = Type.DATE;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                return new StringBuilder(14).append(((java.sql.Date)row.getAs(colIdx)).toString()).append("T00:00:00.000Z").toString();
            }
            return ((java.sql.Date)row.getAs(colIdx)).toString();
        }
        if (dataType instanceof ArrayType) {
            return this.sparkToDkuObj(row.get(colIdx)).toString();
        }
        if (dataType instanceof MapType) {
            return this.sparkToDkuObj(row.get(colIdx)).toString();
        }
        if (dataType instanceof StructType) {
            return this.sparkToDkuObj(row.get(colIdx)).toString();
        }
        return (String)Option$.MODULE$.apply(row.apply(colIdx)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString()).orNull(Predef$.MODULE$.$conforms());
    }

    public String sparkToDku(Object x, DataType colType) {
        DataType dataType;
        DataType dataType2 = colType;
        TimestampType$ timestampType$ = TimestampType$.MODULE$;
        if (dataType2 == null ? timestampType$ != null : !dataType2.equals(timestampType$)) {
            DataType dataType3 = colType;
            DataType dataType4 = this.datetimeNoTzDataType();
            if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
                if (x == null) {
                    return null;
                }
                if (x instanceof Timestamp) {
                    return DKUtils.isoFormatReadableByDatetimeNoTzFormat((long)((Timestamp)x).getTime());
                }
                if (x instanceof Long) {
                    return DKUtils.isoFormatReadableByDatetimeNoTzFormat((long)Predef$.MODULE$.Long2long((Long)x));
                }
                if (x instanceof LocalDateTime) {
                    return DKUtils.isoFormatReadableByDatetimeNoTzFormat((long)(((LocalDateTime)x).toEpochSecond(ZoneOffset.UTC) * 1000L));
                }
                return x.toString();
            }
        }
        if (BooleanType$.MODULE$.equals(dataType = colType)) {
            if (x != null && BoxesRunTime.unboxToBoolean((Object)x)) {
                return "true";
            }
            return "false";
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            if (x == null) {
                return null;
            }
            return DKUtils.isoFormatReadableByDateFormat((long)((Timestamp)x).getTime());
        }
        if (DateType$.MODULE$.equals(dataType)) {
            if (x == null) {
                return null;
            }
            return ((java.sql.Date)x).toString();
        }
        if (dataType instanceof ArrayType) {
            return this.sparkToDkuObj(x).toString();
        }
        if (dataType instanceof MapType) {
            return this.sparkToDkuObj(x).toString();
        }
        if (dataType instanceof StructType) {
            return this.sparkToDkuObj(x).toString();
        }
        return (String)Option$.MODULE$.apply(x).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toString()).orNull(Predef$.MODULE$.$conforms());
    }

    public Object sparkToDkuObj(Object v2) {
        Object object = v2;
        if (object == null) {
            return JSONObject.NULL;
        }
        if (object instanceof java.lang.Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return BoxesRunTime.boxToBoolean((boolean)bl);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return number;
        }
        if (object instanceof Seq) {
            Seq seq = (Seq)object;
            JSONArray result = new JSONArray();
            seq.foreach((Function1 & Serializable & scala.Serializable)v -> result.put(MODULE$.sparkToDkuObj(v)));
            return result;
        }
        if (object instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
            JSONObject result = new JSONObject();
            map.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    return result.put(k.toString(), MODULE$.sparkToDkuObj(v));
                }
                throw new MatchError((Object)tuple2);
            });
            return result;
        }
        if (object instanceof Row) {
            Row row = (Row)object;
            StructType schema = row.schema();
            JSONObject result = new JSONObject();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.length()).foreach((Function1 & Serializable & scala.Serializable)i -> result.put(schema.apply(BoxesRunTime.unboxToInt((Object)i)).name(), package$.MODULE$.sparkToDkuObj(row.get(BoxesRunTime.unboxToInt((Object)i)))));
            return result;
        }
        return v2.toString();
    }

    public List<SchemaColumn> getSchemaColumns(Schema schema, List<String> columnNames) {
        Predef$.MODULE$.require(schema != null, (Function0 & Serializable & scala.Serializable)() -> "Dataset has no schema");
        if (columnNames == null) {
            return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(schema.getColumns()).toList();
        }
        return (List)columnNames.map((Function1 & Serializable & scala.Serializable)c -> {
            SchemaColumn sc = schema.getColumn(c);
            Predef$.MODULE$.require(sc != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Dataset schema does not contain required column ").append((String)c).toString());
            return sc;
        }, List$.MODULE$.canBuildFrom());
    }

    public void objToFile(File f, Serializable obj) {
        try (FileOutputStream fos = new FileOutputStream(f);){
            new ObjectOutputStream(fos).writeObject(obj);
        }
    }

    public <T> T objFromFile(File f, Class<T> klass) {
        Object object;
        try (FileInputStream fis = new FileInputStream(f);){
            object = new ClassLoaderObjectInputStream(this.getClass().getClassLoader(), (InputStream)fis).readObject();
        }
        return (T)object;
    }

    public void printToFile(File f, Function1<PrintWriter, BoxedUnit> op) {
        Logger.getLogger((String)"dku").info((Object)new StringBuilder(18).append("Writing to file : ").append(f).toString());
        try (PrintWriter p = new PrintWriter(f, "UTF-8");){
            op.apply((Object)p);
        }
    }

    private static final /* synthetic */ boolean liftedTree1$1(String sparkVersion$1) {
        boolean bl;
        block3: {
            try {
                String[] parts = new StringOps(Predef$.MODULE$.augmentString(sparkVersion$1)).split('.');
                int major = new StringOps(Predef$.MODULE$.augmentString(parts[0])).toInt();
                int minor = new StringOps(Predef$.MODULE$.augmentString(parts[1])).toInt();
                if (major > 3 || major == 3 && minor >= 4) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
        return bl;
    }

    private static final /* synthetic */ DataType liftedTree2$1() {
        TimestampType$ timestampType$;
        try {
            JavaUniverse.JavaMirror runtimeMirror = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(DataType.class.getClassLoader());
            Symbols.ModuleSymbolApi module = ((Mirror)runtimeMirror).staticModule("org.apache.spark.sql.types.TimestampNTZType");
            Mirrors.ModuleMirror obj = runtimeMirror.reflectModule(module);
            timestampType$ = (DataType)obj.instance();
        }
        catch (Throwable throwable) {
            timestampType$ = TimestampType$.MODULE$;
        }
        return timestampType$;
    }

    private package$() {
        MODULE$ = this;
    }
}

