/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.Dispatcher;
import twitter4j.HttpResponse;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.UserStream;
import twitter4j.UserStreamListener;
import twitter4j.conf.Configuration;

final class UserStreamImpl
extends StatusStreamImpl
implements UserStream {
    UserStreamImpl(Dispatcher dispatcher, InputStream stream, Configuration conf) throws IOException {
        super(dispatcher, stream, conf);
    }

    UserStreamImpl(Dispatcher dispatcher, HttpResponse response, Configuration conf) throws IOException {
        super(dispatcher, response, conf);
    }

    @Override
    public void next(UserStreamListener listener) throws TwitterException {
        this.handleNextElement(new StreamListener[]{listener}, EMPTY);
    }

    @Override
    protected void onSender(JSONObject json, StreamListener[] listeners) throws TwitterException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onDirectMessage((DirectMessage)new DirectMessageJSONImpl(json));
        }
    }

    @Override
    protected void onDirectMessage(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        DirectMessage directMessage = this.asDirectMessage(json);
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onDirectMessage(directMessage);
        }
    }

    @Override
    protected void onScrubGeo(JSONObject json, StreamListener[] listeners) throws TwitterException {
        logger.info("Geo-tagging deletion notice (not implemented yet): " + this.line);
    }

    @Override
    protected void onFriends(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        long[] friendIds = this.asFriendList(json);
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onFriendList(friendIds);
        }
    }

    @Override
    protected void onFavorite(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onFavorite(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
        }
    }

    @Override
    protected void onUnfavorite(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onUnfavorite(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
        }
    }

    @Override
    protected void onFollow(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onFollow(this.asUser(source), this.asUser(target));
        }
    }

    @Override
    protected void onUnfollow(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onUnfollow(this.asUser(source), this.asUser(target));
        }
    }

    @Override
    protected void onUserListMemberAddition(JSONObject addedMember, JSONObject owner, JSONObject target, StreamListener[] listeners) throws TwitterException, JSONException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onUserListMemberAddition(this.asUser(addedMember), this.asUser(owner), this.asUserList(target));
        }
    }

    @Override
    protected void onUserListMemberDeletion(JSONObject deletedMember, JSONObject owner, JSONObject target, StreamListener[] listeners) throws TwitterException, JSONException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onUserListMemberDeletion(this.asUser(deletedMember), this.asUser(owner), this.asUserList(target));
        }
    }

    @Override
    protected void onUserListSubscription(JSONObject source, JSONObject owner, JSONObject target, StreamListener[] listeners) throws TwitterException, JSONException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onUserListSubscription(this.asUser(source), this.asUser(owner), this.asUserList(target));
        }
    }

    @Override
    protected void onUserListUnsubscription(JSONObject source, JSONObject owner, JSONObject target, StreamListener[] listeners) throws TwitterException, JSONException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onUserListUnsubscription(this.asUser(source), this.asUser(owner), this.asUserList(target));
        }
    }

    @Override
    protected void onUserListCreation(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException, JSONException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onUserListCreation(this.asUser(source), this.asUserList(target));
        }
    }

    @Override
    protected void onUserListUpdated(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException, JSONException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onUserListUpdate(this.asUser(source), this.asUserList(target));
        }
    }

    @Override
    protected void onUserListDestroyed(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onUserListDeletion(this.asUser(source), this.asUserList(target));
        }
    }

    @Override
    protected void onUserUpdate(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onUserProfileUpdate(this.asUser(source));
        }
    }

    @Override
    protected void onBlock(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onBlock(this.asUser(source), this.asUser(target));
        }
    }

    @Override
    protected void onUnblock(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        for (StreamListener listener : listeners) {
            ((UserStreamListener)listener).onUnblock(this.asUser(source), this.asUser(target));
        }
    }
}

