/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateVpcEndpointRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DnsOptionsSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.SubnetConfiguration;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateVpcEndpointRequestMarshaller
implements Marshaller<Request<CreateVpcEndpointRequest>, CreateVpcEndpointRequest> {
    @Override
    public Request<CreateVpcEndpointRequest> marshall(CreateVpcEndpointRequest createVpcEndpointRequest) {
        SdkInternalList createVpcEndpointRequestSubnetConfigurationsList;
        SdkInternalList createVpcEndpointRequestTagSpecificationsList;
        DnsOptionsSpecification dnsOptions;
        SdkInternalList createVpcEndpointRequestSecurityGroupIdsList;
        SdkInternalList createVpcEndpointRequestSubnetIdsList;
        SdkInternalList createVpcEndpointRequestRouteTableIdsList;
        if (createVpcEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateVpcEndpointRequest> request = new DefaultRequest<CreateVpcEndpointRequest>(createVpcEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVpcEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcEndpointRequest.getVpcEndpointType() != null) {
            request.addParameter("VpcEndpointType", StringUtils.fromString(createVpcEndpointRequest.getVpcEndpointType()));
        }
        if (createVpcEndpointRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString(createVpcEndpointRequest.getVpcId()));
        }
        if (createVpcEndpointRequest.getServiceName() != null) {
            request.addParameter("ServiceName", StringUtils.fromString(createVpcEndpointRequest.getServiceName()));
        }
        if (createVpcEndpointRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(createVpcEndpointRequest.getPolicyDocument()));
        }
        if (!(createVpcEndpointRequestRouteTableIdsList = (SdkInternalList)createVpcEndpointRequest.getRouteTableIds()).isEmpty() || !createVpcEndpointRequestRouteTableIdsList.isAutoConstruct()) {
            int routeTableIdsListIndex = 1;
            for (Object createVpcEndpointRequestRouteTableIdsListValue : createVpcEndpointRequestRouteTableIdsList) {
                if (createVpcEndpointRequestRouteTableIdsListValue != null) {
                    request.addParameter("RouteTableId." + routeTableIdsListIndex, StringUtils.fromString((String)createVpcEndpointRequestRouteTableIdsListValue));
                }
                ++routeTableIdsListIndex;
            }
        }
        if (!(createVpcEndpointRequestSubnetIdsList = (SdkInternalList)createVpcEndpointRequest.getSubnetIds()).isEmpty() || !createVpcEndpointRequestSubnetIdsList.isAutoConstruct()) {
            int subnetIdsListIndex = 1;
            for (Object createVpcEndpointRequestSubnetIdsListValue : createVpcEndpointRequestSubnetIdsList) {
                if (createVpcEndpointRequestSubnetIdsListValue != null) {
                    request.addParameter("SubnetId." + subnetIdsListIndex, StringUtils.fromString((String)createVpcEndpointRequestSubnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        if (!(createVpcEndpointRequestSecurityGroupIdsList = (SdkInternalList)createVpcEndpointRequest.getSecurityGroupIds()).isEmpty() || !createVpcEndpointRequestSecurityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String createVpcEndpointRequestSecurityGroupIdsListValue : createVpcEndpointRequestSecurityGroupIdsList) {
                if (createVpcEndpointRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString(createVpcEndpointRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (createVpcEndpointRequest.getIpAddressType() != null) {
            request.addParameter("IpAddressType", StringUtils.fromString(createVpcEndpointRequest.getIpAddressType()));
        }
        if ((dnsOptions = createVpcEndpointRequest.getDnsOptions()) != null) {
            if (dnsOptions.getDnsRecordIpType() != null) {
                request.addParameter("DnsOptions.DnsRecordIpType", StringUtils.fromString(dnsOptions.getDnsRecordIpType()));
            }
            if (dnsOptions.getPrivateDnsOnlyForInboundResolverEndpoint() != null) {
                request.addParameter("DnsOptions.PrivateDnsOnlyForInboundResolverEndpoint", StringUtils.fromBoolean(dnsOptions.getPrivateDnsOnlyForInboundResolverEndpoint()));
            }
        }
        if (createVpcEndpointRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createVpcEndpointRequest.getClientToken()));
        }
        if (createVpcEndpointRequest.getPrivateDnsEnabled() != null) {
            request.addParameter("PrivateDnsEnabled", StringUtils.fromBoolean(createVpcEndpointRequest.getPrivateDnsEnabled()));
        }
        if (!(createVpcEndpointRequestTagSpecificationsList = (SdkInternalList)createVpcEndpointRequest.getTagSpecifications()).isEmpty() || !createVpcEndpointRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVpcEndpointRequestTagSpecificationsListValue : createVpcEndpointRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVpcEndpointRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createVpcEndpointRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVpcEndpointRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (!(createVpcEndpointRequestSubnetConfigurationsList = (SdkInternalList)createVpcEndpointRequest.getSubnetConfigurations()).isEmpty() || !createVpcEndpointRequestSubnetConfigurationsList.isAutoConstruct()) {
            int subnetConfigurationsListIndex = 1;
            for (SubnetConfiguration createVpcEndpointRequestSubnetConfigurationsListValue : createVpcEndpointRequestSubnetConfigurationsList) {
                if (createVpcEndpointRequestSubnetConfigurationsListValue.getSubnetId() != null) {
                    request.addParameter("SubnetConfiguration." + subnetConfigurationsListIndex + ".SubnetId", StringUtils.fromString(createVpcEndpointRequestSubnetConfigurationsListValue.getSubnetId()));
                }
                if (createVpcEndpointRequestSubnetConfigurationsListValue.getIpv4() != null) {
                    request.addParameter("SubnetConfiguration." + subnetConfigurationsListIndex + ".Ipv4", StringUtils.fromString(createVpcEndpointRequestSubnetConfigurationsListValue.getIpv4()));
                }
                if (createVpcEndpointRequestSubnetConfigurationsListValue.getIpv6() != null) {
                    request.addParameter("SubnetConfiguration." + subnetConfigurationsListIndex + ".Ipv6", StringUtils.fromString(createVpcEndpointRequestSubnetConfigurationsListValue.getIpv6()));
                }
                ++subnetConfigurationsListIndex;
            }
        }
        return request;
    }
}

