/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.hive.executor;

import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.ExecutionQuery;
import com.dataiku.hproxy.model.hive.ExecutionResults;
import com.dataiku.hproxy.model.hive.QueryStatus;
import com.dataiku.hproxy.model.hive.ResultCount;
import com.dataiku.hproxy.server.hive.executor.IQueryHandler;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DebugQueryHandler
implements IQueryHandler {
    private final ExecutionResults results;
    private final String identifier;
    private final ExecutionQuery query;

    public DebugQueryHandler(String identifier, ExecutionQuery query, ExecutionResults results) {
        this.identifier = identifier;
        this.query = query;
        this.results = results;
    }

    public DebugQueryHandler(String identifier, ExecutionQuery query, String ... strings) {
        this(identifier, query, DebugQueryHandler.makeSimpleResults(strings));
    }

    private static ExecutionResults makeSimpleResults(String ... strings) {
        ExecutionResults results = new ExecutionResults();
        results.columns = Lists.newArrayList((Object[])new ColumnSchema[]{new ColumnSchema().withName("column").withType("string")});
        results.rows = Lists.newArrayList();
        results.firstRowOffset = 0L;
        for (String string : strings) {
            results.rows.add(new String[]{string});
        }
        return results;
    }

    @Override
    public void startExecution() {
    }

    @Override
    public List<ColumnSchema> getSchema() {
        return this.results.columns;
    }

    @Override
    public Future<Long> getLowerBoundOnCount() {
        return new FakeFuture<Long>(new Long(1000L));
    }

    @Override
    public Future<ExecutionResults> fetchResult(long from, long limit) {
        return new FakeFuture<ExecutionResults>(this.results);
    }

    @Override
    public Future<ResultCount> countResults(long limit) {
        return new FakeFuture<ResultCount>(new ResultCount((long)this.results.rows.size()));
    }

    @Override
    public void kill() {
    }

    @Override
    public void release() {
    }

    @Override
    public String getDeathReason() {
        return "can't die";
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getLogTail() {
        return "";
    }

    @Override
    public void setMaxIdleTime(long ms) {
    }

    @Override
    public long getMaxIdleTime() {
        return 0L;
    }

    @Override
    public void updateLastUsedTime() {
    }

    @Override
    public long getStartTime() {
        return 0L;
    }

    @Override
    public long getLastUsedTime() {
        return 0L;
    }

    @Override
    public long getFinishTime() {
        return 0L;
    }

    @Override
    public QueryStatus.HiveQueryState getState() {
        return QueryStatus.HiveQueryState.READY_TO_FETCH;
    }

    @Override
    public ExecutionQuery getQuery() {
        return this.query;
    }

    @Override
    public void injectLogMessage(String msg) {
    }

    @Override
    public QueryStatus.HiveQueryState waitForNextState(long timeout) throws InterruptedException {
        return this.getState();
    }

    @Override
    public void update() {
    }

    @Override
    public boolean isFetching() {
        return false;
    }

    private class FakeFuture<T>
    implements Future<T> {
        private final T result;

        public FakeFuture(T result) {
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.result;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

