/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.ScanBuilder;
import io.delta.kernel.Snapshot;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.internal.ScanBuilderImpl;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.CommitInfo;
import io.delta.kernel.internal.actions.DomainMetadata;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.CreateCheckpointIterator;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.snapshot.TableCommitCoordinatorClientHandler;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.StructType;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SnapshotImpl
implements Snapshot {
    private final Path logPath;
    private final Path dataPath;
    private final long version;
    private final LogReplay logReplay;
    private final Protocol protocol;
    private final Metadata metadata;
    private final LogSegment logSegment;
    private Optional<Long> inCommitTimestampOpt;

    public SnapshotImpl(Path path, LogSegment logSegment, LogReplay logReplay, Protocol protocol, Metadata metadata) {
        this.logPath = new Path(path, "_delta_log");
        this.dataPath = path;
        this.version = logSegment.version;
        this.logSegment = logSegment;
        this.logReplay = logReplay;
        this.protocol = protocol;
        this.metadata = metadata;
        this.inCommitTimestampOpt = Optional.empty();
    }

    @Override
    public long getVersion(Engine engine) {
        return this.version;
    }

    @Override
    public long getTimestamp(Engine engine) {
        if (TableConfig.IN_COMMIT_TIMESTAMPS_ENABLED.fromMetadata(this.metadata).booleanValue()) {
            if (!this.inCommitTimestampOpt.isPresent()) {
                Optional<CommitInfo> optional = CommitInfo.getCommitInfoOpt(engine, this.logPath, this.logSegment.version);
                this.inCommitTimestampOpt = Optional.of(CommitInfo.getRequiredInCommitTimestamp(optional, String.valueOf(this.logSegment.version), this.dataPath));
            }
            return this.inCommitTimestampOpt.get();
        }
        return this.logSegment.lastCommitTimestamp;
    }

    @Override
    public StructType getSchema(Engine engine) {
        return this.getMetadata().getSchema();
    }

    @Override
    public ScanBuilder getScanBuilder(Engine engine) {
        return new ScanBuilderImpl(this.dataPath, this.protocol, this.metadata, this.getSchema(engine), this.logReplay, engine);
    }

    public Path getLogPath() {
        return this.logPath;
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public List<String> getPartitionColumnNames(Engine engine) {
        return VectorUtils.toJavaList(this.getMetadata().getPartitionColumns());
    }

    public Map<String, DomainMetadata> getDomainMetadataMap() {
        return this.logReplay.getDomainMetadataMap();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public LogSegment getLogSegment() {
        return this.logSegment;
    }

    public CreateCheckpointIterator getCreateCheckpointIterator(Engine engine) {
        long l = System.currentTimeMillis() - TableConfig.TOMBSTONE_RETENTION.fromMetadata(this.metadata);
        return new CreateCheckpointIterator(engine, this.logSegment, l);
    }

    public Optional<Long> getLatestTransactionVersion(Engine engine, String string) {
        return this.logReplay.getLatestTransactionIdentifier(engine, string);
    }

    public Optional<TableCommitCoordinatorClientHandler> getTableCommitCoordinatorClientHandlerOpt(Engine engine) {
        return Optional.empty();
    }
}

