/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hadoop.gcp;

import com.google.cloud.hadoop.util.AccessTokenProvider;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class RemoteDSSOAuth2Provider
implements AccessTokenProvider {
    private static Logger logger = Logger.getLogger(RemoteDSSOAuth2Provider.class);
    private static DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    public static final String CONFIG_ACCESS_TOKEN_INITIAL_REFRESH = "fs.gs.auth.access.token.force.initial.refresh";
    public static final String CONFIG_ACCESS_TOKEN = "fs.gs.auth.access.token";
    public static final String CONFIG_ACCESS_TOKEN_EXPIRES_ON = "fs.gs.auth.access.token.expires.on";
    public static final String CONFIG_CONNECTION_NAME = "fs.gs.auth.dss.connection.name";
    public static final String CONFIG_PROJECT_KEY = "fs.gs.auth.dss.project.key";
    private static final AccessTokenProvider.AccessToken EXPIRED_TOKEN = new AccessTokenProvider.AccessToken("", Long.valueOf(-1L));
    private Configuration config;
    private AccessTokenProvider.AccessToken accessToken = EXPIRED_TOKEN;

    public RemoteDSSOAuth2Provider() {
        logger.info((Object)"Getting access tokens from remote DSS");
    }

    public AccessTokenProvider.AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void refresh() {
        String connectionName = this.config.get(CONFIG_CONNECTION_NAME);
        String projectKey = this.config.get(CONFIG_PROJECT_KEY, "__DKU_ANY_PROJECT__");
        try {
            Class<?> cloudStorageConnectionClazz;
            try {
                cloudStorageConnectionClazz = this.getClass().getClassLoader().loadClass("com.dataiku.dip.connections.AbstractCloudStorageConnection");
            }
            catch (ClassNotFoundException e2) {
                logger.warn((Object)"Class not found in hadoop's classloader");
                cloudStorageConnectionClazz = Thread.currentThread().getContextClassLoader().loadClass("com.dataiku.dip.connections.AbstractCloudStorageConnection");
            }
            Method refreshCredentialsMethod = cloudStorageConnectionClazz.getDeclaredMethod("refreshCredentials", String.class, String.class, Boolean.TYPE, Boolean.TYPE);
            JsonObject creds = (JsonObject)refreshCredentialsMethod.invoke(null, connectionName, projectKey, true, true);
            logger.info((Object)"Retrieved creds from remote");
            this.accessToken = new AccessTokenProvider.AccessToken(creds.get("oauthAccessToken").getAsString(), Long.valueOf(creds.get("oauthAccessTokenExpiresOn").getAsLong()));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Can't access remote creds", e);
        }
    }

    public void setConf(Configuration config) {
        this.config = config;
        logger.info((Object)"Config set");
        if (config != null && !"true".equals(config.get(CONFIG_ACCESS_TOKEN_INITIAL_REFRESH)) && config.get(CONFIG_ACCESS_TOKEN, "").length() > 0) {
            logger.info((Object)"Starting with token from config");
            String accessTokenValue = config.get(CONFIG_ACCESS_TOKEN);
            long accessTokenExpiresOn = -1L;
            try {
                accessTokenExpiresOn = Long.parseLong(config.get(CONFIG_ACCESS_TOKEN_EXPIRES_ON, "-1"));
            }
            catch (Exception e) {
                logger.warn((Object)"Invalid token expiration value", (Throwable)e);
            }
            this.accessToken = new AccessTokenProvider.AccessToken(accessTokenValue, Long.valueOf(accessTokenExpiresOn));
        }
    }

    public Configuration getConf() {
        return this.config;
    }
}

