/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Document;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexableField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LuceneHelpers {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.lucene.helpers");

    public static void convertDocumentToSourceMap(Document hitDoc, LuceneResponseWrapper.HitCommon hit, LuceneMappingsAnalyzer lma) {
        String type;
        hit._type = type = hitDoc.getField("_type").stringValue();
        for (IndexableField field : hitDoc.getFields()) {
            if (field.name().equals("_type")) continue;
            if (field.name().equals("_id")) {
                hit._id = field.stringValue();
                continue;
            }
            if (!field.name().startsWith("$json_") && (!lma.getSerializableMappingForType(type).containsKey(field.name()) || !((Boolean)lma.getSerializableMappingForType(type).get(field.name())).booleanValue())) continue;
            LuceneHelpers.addFieldInSource(field, hit._source, lma.getMultivaluedFieldSetForType(type), lma.getFieldTypeMappingForType(type));
        }
    }

    private static void addFieldInSource(IndexableField field, Map<String, Object> source, Set<String> multivaluedFields, Map<String, LuceneMappingsAnalyzer.MappingFieldType> fieldTypes) {
        LuceneMappingsAnalyzer.MappingFieldType fieldType;
        LuceneMappingsAnalyzer.MappingFieldType mappingFieldType = fieldType = field.name().startsWith("$json_") ? LuceneMappingsAnalyzer.MappingFieldType.STRING : fieldTypes.get(field.name());
        if (source.containsKey(field.name())) {
            Object storedObj = source.get(field.name());
            if (storedObj instanceof List) {
                ((List)storedObj).add(LuceneHelpers.getFieldValue(field, false, fieldType));
            } else {
                logger.errorV("Field [%s] should not be multivalued", new Object[]{field.name()});
            }
        } else {
            source.put(field.name(), LuceneHelpers.getFieldValue(field, multivaluedFields.contains(field.name()), fieldType));
        }
    }

    private static Object getFieldValue(IndexableField field, boolean isMultivalued, LuceneMappingsAnalyzer.MappingFieldType fieldType) {
        Object fieldValue;
        if (fieldType == LuceneMappingsAnalyzer.MappingFieldType.BOOLEAN) {
            String stringFieldValue = field.stringValue();
            fieldValue = "true".equals(stringFieldValue) ? Boolean.valueOf(true) : ("false".equals(stringFieldValue) ? Boolean.valueOf(false) : null);
        } else if (fieldType == LuceneMappingsAnalyzer.MappingFieldType.INTEGER || fieldType == LuceneMappingsAnalyzer.MappingFieldType.LONG) {
            fieldValue = field.numericValue();
        } else if (fieldType == LuceneMappingsAnalyzer.MappingFieldType.STRING || fieldType == LuceneMappingsAnalyzer.MappingFieldType.TEXT) {
            fieldValue = field.stringValue();
        } else {
            throw new IllegalStateException("Field type " + fieldType.name() + " not implemented");
        }
        return isMultivalued ? new ArrayList<Object>(Collections.singletonList(fieldValue)) : fieldValue;
    }
}

